/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Locale;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.opensearch.common.Nullable;
import org.opensearch.common.ssl.SslConfigException;

final class KeyStoreUtil {
    private KeyStoreUtil() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    static String inferKeyStoreType(Path path) {
        String name;
        String string = name = path == null ? "" : path.toString().toLowerCase(Locale.ROOT);
        if (name.endsWith(".p12") || name.endsWith(".pfx") || name.endsWith(".pkcs12")) {
            return "PKCS12";
        }
        return "jks";
    }

    static KeyStore readKeyStore(Path path, String type, char[] password) throws GeneralSecurityException {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new SslConfigException("cannot read a [" + type + "] keystore from [" + path.toAbsolutePath() + "] because the file does not exist");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                keyStore.load(in, password);
            }
            return keyStore;
        }
        catch (IOException e) {
            throw new SslConfigException("cannot read a [" + type + "] keystore from [" + path.toAbsolutePath() + "] - " + e.getMessage(), e);
        }
    }

    static KeyStore buildKeyStore(Collection<Certificate> certificateChain, PrivateKey privateKey, char[] password) throws GeneralSecurityException {
        KeyStore keyStore = KeyStoreUtil.buildNewKeyStore();
        keyStore.setKeyEntry("key", privateKey, password, certificateChain.toArray(new Certificate[0]));
        return keyStore;
    }

    static KeyStore buildTrustStore(Iterable<Certificate> certificates) throws GeneralSecurityException {
        assert (certificates != null) : "Cannot create keystore with null certificates";
        KeyStore store = KeyStoreUtil.buildNewKeyStore();
        int counter = 0;
        for (Certificate certificate : certificates) {
            store.setCertificateEntry("cert-" + counter, certificate);
            ++counter;
        }
        return store;
    }

    private static KeyStore buildNewKeyStore() throws GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            keyStore.load(null, null);
        }
        catch (IOException e) {
            throw new SslConfigException("Unexpected error initializing a new in-memory keystore", e);
        }
        return keyStore;
    }

    static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] password, String algorithm) throws GeneralSecurityException {
        KeyManager[] keyManagers;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keyStore, password);
        for (KeyManager keyManager : keyManagers = kmf.getKeyManagers()) {
            if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)keyManager;
        }
        throw new SslConfigException("failed to find a X509ExtendedKeyManager in the key manager factory for [" + algorithm + "] and keystore [" + keyStore + "]");
    }

    static X509ExtendedTrustManager createTrustManager(@Nullable KeyStore trustStore, String algorithm) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagers;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(trustStore);
        for (TrustManager trustManager : trustManagers = tmf.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)trustManager;
        }
        throw new SslConfigException("failed to find a X509ExtendedTrustManager in the trust manager factory for [" + algorithm + "] and truststore [" + trustStore + "]");
    }
}

