/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UIMessages {
    private final int _maxSize;
    private int _count;
    private final LinkedList<Message> _messages;

    public UIMessages(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException();
        }
        this._maxSize = maxSize;
        this._messages = new LinkedList();
    }

    public int addMessage(String message) {
        return this.addMessageNoEscape(message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
    }

    public synchronized int addMessageNoEscape(String message) {
        this._messages.offer(new Message(this._count++, message));
        while (this._messages.size() > this._maxSize) {
            this._messages.poll();
        }
        return this._count;
    }

    public synchronized int getLastMessageID() {
        return this._count - 1;
    }

    public synchronized List<Message> getMessages() {
        if (this._messages.peekLast() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Message>(this._messages);
    }

    public synchronized List<String> getMessageStrings() {
        if (this._messages.peekLast() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> rv = new ArrayList<String>(this._messages.size());
        for (Message m : this._messages) {
            rv.add(m.message);
        }
        return rv;
    }

    public synchronized void clear() {
        this._messages.clear();
    }

    public synchronized void clearThrough(int id) {
        Message m = this._messages.peekLast();
        if (m != null) {
            if (m.id <= id) {
                this._messages.clear();
            } else {
                Iterator iter = this._messages.iterator();
                while (iter.hasNext()) {
                    Message msg = (Message)iter.next();
                    if (msg.id > id) break;
                    iter.remove();
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this._messages.peekLast() == null;
    }

    public static class Message {
        public final int id;
        public final String message;

        private Message(int i, String msg) {
            this.id = i;
            this.message = msg;
        }

        public String toString() {
            return this.message;
        }
    }
}

