/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.request;

import java.awt.Component;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestBodyPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestBodySyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestBodyPanelSyntaxHighlightTextView(RequestBodyStringHttpPanelViewModel model) {
        super(model);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = -426000345249750052L;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!HttpRequestBodyPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestBodyPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestBodyPanelSyntaxHighlightTextView.this, x, y);
            }
        });
    }

    @Override
    protected HttpRequestBodyPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestBodyPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestBodyPanelSyntaxHighlightTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!this.supports(location)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, new TextMessageLocationHighlight(DisplayUtils.getHighlightColor()));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!this.supports(location) || !(highlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        TextMessageLocationHighlight textHighlight = (TextMessageLocationHighlight)highlight;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, textHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(highlightReference instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)highlightReference).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof TextHttpMessageLocation)) {
            return false;
        }
        return ((TextHttpMessageLocation)location).getLocation() == HttpMessageLocation.Location.REQUEST_BODY;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return TextHttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().removeFocusListener(focusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    private static class HttpRequestBodyPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = -2102275261139781996L;
        private static final String X_WWW_FORM_URLENCODED = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xWwwFormUrlencoded");
        private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
        private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
        private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");
        private static final String SYNTAX_STYLE_X_WWW_FORM = "application/x-www-form-urlencoded";
        private static RequestBodyTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisibilityEnforcer;

        public HttpRequestBodyPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(X_WWW_FORM_URLENCODED, SYNTAX_STYLE_X_WWW_FORM);
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
            this.caretVisibilityEnforcer = new CaretVisibilityEnforcerOnFocusGain(this);
            this.setCodeFoldingAllowed(true);
        }

        @Override
        public String getName() {
            return HttpRequestBodyPanelSyntaxHighlightTextView.NAME;
        }

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message aMessage) {
            super.setMessage(aMessage);
            this.caretVisibilityEnforcer.setEnforceVisibilityOnFocusGain(aMessage != null);
        }

        protected MessageLocation getSelection() {
            int end;
            int start = this.getSelectionStart();
            if (start == (end = this.getSelectionEnd())) {
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_BODY, start);
            }
            return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_BODY, start, end, this.getSelectedText());
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textLocation, TextMessageLocationHighlight textHighlight) {
            textHighlight.setHighlightReference(this.highlight(textLocation.getStart(), textLocation.getEnd(), textHighlight));
            return textHighlight;
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_BODY, m.start(), m.end()));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            int len = this.getText().length();
            if (sm.getStart() > len || sm.getEnd() > len) {
                return;
            }
            this.highlight(sm.getStart(), sm.getEnd());
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String contentType;
            String syntax = null;
            if (httpMessage != null && (contentType = httpMessage.getRequestHeader().getHeader("Content-Type")) != null && !contentType.isEmpty()) {
                int pos = (contentType = contentType.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos).trim();
                }
                syntax = contentType.contains("javascript") ? "text/javascript" : (contentType.contains("json") ? "text/json" : (contentType.contains("xml") ? "text/xml" : contentType));
            }
            return syntax;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestBodyTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestBodyTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public RequestBodyTokenMakerFactory() {
                String pkg = "org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.lexers.";
                this.putMapping(HttpRequestBodyPanelSyntaxHighlightTextArea.SYNTAX_STYLE_X_WWW_FORM, pkg + "WwwFormTokenMaker");
                pkg = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/javascript", pkg + "JavaScriptTokenMaker");
                this.putMapping("text/json", pkg + "JsonTokenMaker");
                this.putMapping("text/xml", pkg + "XMLTokenMaker");
            }
        }
    }
}

