/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantGWTQuery
extends VariantAbstractRPCQuery {
    public static final String GWT_RPC_CONTENT_TYPE = "text/x-gwt-rpc";
    public static final int RPC_SEPARATOR_CHAR = 124;
    public static final int FLAG_RPC_TOKEN_INCLUDED = 2;

    @Override
    public boolean isValidContentType(String contentType) {
        return contentType.startsWith(GWT_RPC_CONTENT_TYPE);
    }

    @Override
    public void parseContent(String content) {
        int i;
        GWTStringTokenizer st = new GWTStringTokenizer(content, 124);
        int version = Integer.parseInt(st.nextToken());
        int flags = Integer.parseInt(st.nextToken());
        int columns = Integer.parseInt(st.nextToken());
        int[] stringTableIndices = new int[columns + 1];
        String[] stringTable = new String[columns];
        for (int i2 = 0; i2 < columns; ++i2) {
            stringTableIndices[i2] = st.getPosition();
            stringTable[i2] = st.nextToken();
        }
        stringTableIndices[columns] = st.getPosition();
        String moduleBaseUrl = stringTable[Integer.parseInt(st.nextToken()) - 1];
        String strongName = stringTable[Integer.parseInt(st.nextToken()) - 1];
        String rpcToken = null;
        if ((flags & 2) == 2) {
            rpcToken = stringTable[Integer.parseInt(st.nextToken()) - 1];
        }
        String serviceInterfaceName = stringTable[Integer.parseInt(st.nextToken()) - 1];
        String serviceMethodName = stringTable[Integer.parseInt(st.nextToken()) - 1];
        int paramCount = Integer.parseInt(st.nextToken());
        String[] parameterTypes = new String[paramCount];
        for (i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = stringTable[Integer.parseInt(st.nextToken()) - 1];
        }
        for (i = 0; i < paramCount; ++i) {
            int idx;
            String strIndex = st.nextToken();
            if (!parameterTypes[i].startsWith("java.lang.String") || (idx = Integer.parseInt(strIndex)) <= 0) continue;
            this.addParameter(String.valueOf(i), stringTableIndices[idx - 1], stringTableIndices[idx] - 1, false, true);
        }
    }

    @Override
    public String getEscapedValue(String value, boolean toQuote) {
        StringBuilder buf = new StringBuilder(value.length());
        int idx = 0;
        while (idx < value.length()) {
            char ch;
            if ((ch = value.charAt(idx++)) == '\u0000') {
                buf.append("\\0");
                continue;
            }
            if (ch == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (ch == '|') {
                buf.append("\\!");
                continue;
            }
            if (ch >= '\ud800' && ch < '\uffff') {
                buf.append(String.format("\\u%04x", ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    @Override
    public String getUnescapedValue(String value) {
        if (value.indexOf(92) < 0) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length());
        int idx = 0;
        block8: while (idx < value.length()) {
            char ch;
            if ((ch = value.charAt(idx++)) == '\\') {
                if (idx == value.length()) break;
                ch = value.charAt(idx++);
                switch (ch) {
                    case '0': {
                        buf.append('\u0000');
                        continue block8;
                    }
                    case '!': {
                        buf.append('|');
                        continue block8;
                    }
                    case '\\': {
                        buf.append(ch);
                        continue block8;
                    }
                    case 'u': {
                        try {
                            if (idx + 4 < value.length()) {
                                ch = (char)Integer.parseInt(value.substring(idx, idx + 4), 16);
                                buf.append(ch);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        idx += 4;
                        continue block8;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    protected class GWTStringTokenizer {
        private String str;
        private int delim;
        private int currentPosition;

        public GWTStringTokenizer(String str, int delim) {
            this.str = str;
            this.delim = delim;
        }

        public String nextToken() {
            int nextDelimPosition = this.str.indexOf(this.delim, this.currentPosition);
            if (nextDelimPosition < 0) {
                nextDelimPosition = this.str.length();
            }
            String token = this.str.substring(this.currentPosition, nextDelimPosition);
            this.currentPosition = nextDelimPosition + 1;
            return token;
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.str.length();
        }

        public int getPosition() {
            return this.currentPosition;
        }
    }
}

