/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.data.FileFilterImpl;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;

public class ExportTemplate {
    private static final Logger LOG = Logger.getLogger("tr.view.projects.ExportTemplate");
    private static final int VERSION_MAJOR = 1;
    private static final int VERSION_MINOR = 0;
    private static final String VERSION = "1.0";
    private static final String EXTN = "trpt";
    private static final String EXTN_NAME = NbBundle.getMessage(ExportTemplate.class, (String)"template.file.extension.name");

    public void export(Project project) {
        File outfile;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(ExportTemplate.class, (String)"export.template.file.chooser.title"));
        chooser.setFileSelectionMode(0);
        FileFilterImpl filter = new FileFilterImpl(EXTN_NAME, new String[]{EXTN}, true);
        chooser.setFileFilter((FileFilter)filter);
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = chooser.showDialog(p, NbBundle.getMessage(ExportTemplate.class, (String)"export.template.file.chooser.button"));
        if (returnVal != 0) {
            return;
        }
        String path = chooser.getSelectedFile().getPath();
        String extn = FileUtil.getExtension((String)path);
        if (extn == null || extn.length() == 0) {
            path = path + ".trpt";
        }
        if ((outfile = new File(path)).exists()) {
            String t = NbBundle.getMessage(ExportTemplate.class, (String)"export.template.file.chooser.title");
            String m = NbBundle.getMessage(ExportTemplate.class, (String)"confirm.replace.file");
            int r = JOptionPane.showConfirmDialog(p, m, t, 0);
            if (r != 0) {
                return;
            }
            outfile.delete();
        }
        try {
            Writer writer = this.initialise(outfile);
            this.process(project, writer);
            this.finalise(writer);
        }
        catch (Exception ex) {
            LOG.severe("Export project template failed: " + ex.getMessage());
        }
    }

    private Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<template version=\"1.0\">\r\n");
        return out;
    }

    private void finalise(Writer out) throws Exception {
        out.write("</template>\r\n");
        out.flush();
        out.close();
    }

    private void process(Project project, Writer out) {
        try {
            LOG.info("Export project template ... ");
            out.write("<project>\r\n");
            this.writeProject(project, out);
            out.write("</project>\r\n");
            LOG.info("Export project template ... done");
        }
        catch (Exception ex) {
            LOG.severe("Export project template failed: " + ex.getMessage());
        }
    }

    public void writeProject(Project project, Writer out) throws Exception {
        out.write("<descr>" + this.escape(project.getDescription()) + "</descr>\r\n");
        out.write("<topic>" + this.escape(project.getTopic().getName()) + "</topic>\r\n");
        out.write("<purpose>" + this.escape(project.getPurpose()) + "</purpose>\r\n");
        out.write("<success>" + this.escape(project.getVision()) + "</success>\r\n");
        out.write("<brainstorming>" + this.escape(project.getBrainstorming()) + "</brainstorming>\r\n");
        out.write("<organising>" + this.escape(project.getOrganising()) + "</organising>\r\n");
        out.write("<sequence>" + project.isSequencing() + "</sequence>\r\n");
        out.write("<sequence-into>" + project.isSequenceIntoSubProjects() + "</sequence-into>\r\n");
        out.write("<notes>" + this.escape(project.getNotes().trim()) + "</notes>\r\n");
        Value priority = project.getPriority();
        if (priority != null) {
            out.write("<priority>" + this.escape(priority.getName()) + "</priority>\r\n");
        }
        for (Item child : project.getChildren()) {
            if (child instanceof Project) {
                out.write("<child type='project'>\r\n");
                this.writeProject((Project)child, out);
                out.write("</child>\r\n");
                continue;
            }
            if (!(child instanceof Action)) continue;
            out.write("<child type='action'>\r\n");
            this.writeAction((Action)child, out);
            out.write("</child>\r\n");
        }
    }

    public void writeAction(Action action, Writer out) throws Exception {
        Value priority;
        Value energy;
        Thought thought = action.getThought();
        if (thought != null) {
            out.write("<thought>" + this.escape(thought.getDescription()) + "</thought>\r\n");
        }
        out.write("<descr>" + this.escape(action.getDescription()) + "</descr>\r\n");
        out.write("<topic>" + this.escape(action.getTopic().getName()) + "</topic>\r\n");
        out.write("<context>" + this.escape(action.getContext().getName()) + "</context>\r\n");
        out.write("<notes>" + this.escape(action.getNotes().trim()) + "</notes>\r\n");
        Value time = action.getTime();
        if (time != null) {
            out.write("<time>" + this.escape(time.getName()) + "</time>\r\n");
        }
        if ((energy = action.getEnergy()) != null) {
            out.write("<energy>" + this.escape(energy.getName()) + "</energy>\r\n");
        }
        if ((priority = action.getPriority()) != null) {
            out.write("<priority>" + this.escape(priority.getName()) + "</priority>\r\n");
        }
        out.write("<success>" + this.escape(action.getSuccess()) + "</success>\r\n");
        switch (action.getState().getType()) {
            case DELEGATED: {
                this.writeStateDelegated((ActionStateDelegated)action.getState(), out);
                break;
            }
            case SCHEDULED: {
                this.writeStateScheduled((ActionStateScheduled)action.getState(), out);
                break;
            }
            case INACTIVE: {
                this.writeStateInactive((ActionStateInactive)action.getState(), out);
                break;
            }
            case DOASAP: {
                this.writeStateDoASAP((ActionStateASAP)action.getState(), out);
                break;
            }
        }
    }

    private void writeStateDelegated(ActionStateDelegated s, Writer out) throws Exception {
        out.write("<state type='DELEGATED'>");
        out.write("<delegate>" + this.escape(s.getTo()) + "</delegate>\r\n");
        out.write("</state>");
    }

    private void writeStateScheduled(ActionStateScheduled s, Writer out) throws Exception {
        out.write("<state type='SCHEDULED'>");
        out.write("</state>");
    }

    private void writeStateInactive(ActionStateInactive s, Writer out) throws Exception {
        out.write("<state type='INACTIVE'>");
        out.write("</state>");
    }

    private void writeStateDoASAP(ActionStateASAP s, Writer out) throws Exception {
        out.write("<state type='DOASAP'>");
        out.write("</state>");
    }

    private String escape(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }
}

