/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestFileViewedState;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRFilesService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProvider;", "Lcom/intellij/openapi/Disposable;", "filesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRFilesService;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRFilesService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "viewedState", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestFileViewedState;", "kotlin.jvm.PlatformType", "addViewedStateListener", "", "parent", "listener", "Lkotlin/Function0;", "dispose", "getViewedState", "loadViewedState", "Ljava/util/concurrent/CompletableFuture;", "reset", "updateViewedState", "path", "isViewed", "", "intellij.vcs.github"})
public final class GHPRViewedStateDataProviderImpl
implements GHPRViewedStateDataProvider,
Disposable {
    private final LazyCancellableBackgroundProcessValue<Map<String, GHPullRequestFileViewedState>> viewedState;
    private final GHPRFilesService filesService;
    private final GHPRIdentifier pullRequestId;

    @Override
    @NotNull
    public CompletableFuture<Map<String, GHPullRequestFileViewedState>> loadViewedState() {
        CompletableFuture completableFuture = (CompletableFuture)this.viewedState.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"viewedState.value");
        return completableFuture;
    }

    @Override
    @NotNull
    public Map<String, GHPullRequestFileViewedState> getViewedState() {
        Object object;
        if (!this.viewedState.isCached()) {
            return MapsKt.emptyMap();
        }
        Object object2 = this;
        try {
            GHPRViewedStateDataProviderImpl $this$runCatching = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((CompletableFuture)$this$runCatching.viewedState.getValue()).getNow(MapsKt.emptyMap()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = MapsKt.emptyMap();
        return (Map)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    @Override
    public void updateViewedState(@NotNull String path, boolean isViewed) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompletableFuture<Unit> result = this.filesService.updateViewedState((ProgressIndicator)new EmptyProgressIndicator(), this.pullRequestId, path, isViewed);
        this.viewedState.combineResult(result, (Function2)new Function2<Map<String, ? extends GHPullRequestFileViewedState>, Unit, Map<String, ? extends GHPullRequestFileViewedState>>(isViewed, path){
            final /* synthetic */ boolean $isViewed;
            final /* synthetic */ String $path;

            public final Map<String, GHPullRequestFileViewedState> invoke(Map<String, ? extends GHPullRequestFileViewedState> files, @NotNull Unit $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                GHPullRequestFileViewedState newState = this.$isViewed ? GHPullRequestFileViewedState.VIEWED : GHPullRequestFileViewedState.UNVIEWED;
                Map<String, ? extends GHPullRequestFileViewedState> map2 = files;
                Intrinsics.checkNotNullExpressionValue(map2, (String)"files");
                return MapsKt.plus(map2, (Pair)TuplesKt.to((Object)this.$path, (Object)((Object)newState)));
            }
            {
                this.$isViewed = bl;
                this.$path = string;
                super(2);
            }
        });
    }

    @Override
    public void addViewedStateListener(@NotNull Disposable parent, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.viewedState.addDropEventListener(parent, listener2);
    }

    @Override
    public void reset() {
        this.viewedState.drop();
    }

    public void dispose() {
        this.reset();
    }

    public GHPRViewedStateDataProviderImpl(@NotNull GHPRFilesService filesService, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)filesService, (String)"filesService");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        this.filesService = filesService;
        this.pullRequestId = pullRequestId;
        this.viewedState = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Map<String, ? extends GHPullRequestFileViewedState>>>(this){
            final /* synthetic */ GHPRViewedStateDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<Map<String, GHPullRequestFileViewedState>> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CompletionStage completionStage = GHPRViewedStateDataProviderImpl.access$getFilesService$p(this.this$0).loadFiles(indicator, GHPRViewedStateDataProviderImpl.access$getPullRequestId$p(this.this$0)).thenApply((Function)viewedState.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"filesService\n      .load\u2026it.viewerViewedState }) }");
                return completionStage;
            }
            {
                this.this$0 = gHPRViewedStateDataProviderImpl;
                super(1);
            }
        });
    }

    public static final /* synthetic */ GHPRFilesService access$getFilesService$p(GHPRViewedStateDataProviderImpl $this) {
        return $this.filesService;
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRViewedStateDataProviderImpl $this) {
        return $this.pullRequestId;
    }
}

