/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser.frontmatter;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterHeaderMarkerProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\r2\n\u0010\u0011\u001a\u00060\u0003R\u00020\u0004H\u0016R\u0012\u0010\n\u001a\u00060\u0003R\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0018\u00010\u0003R\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/frontmatter/FrontMatterHeaderBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;)V", "closingDelimiterPosition", "lastContentPosition", "shouldClose", "", "allowsSubBlocks", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "position", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "intellij.markdown.core"})
public final class FrontMatterHeaderBlock
extends MarkerBlockImpl {
    private LookaheadText.Position lastContentPosition;
    private LookaheadText.Position closingDelimiterPosition;
    private boolean shouldClose;
    private final LookaheadText.Position startPosition;
    private final ProductionHolder productionHolder;

    public boolean allowsSubBlocks() {
        return false;
    }

    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position position, @NotNull MarkdownConstraints currentConstraints) {
        int delimiterStartOffset;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (this.shouldClose) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (!FrontMatterHeaderMarkerProvider.Companion.isDelimiterLine(position.getCurrentLine())) {
            this.lastContentPosition = position;
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        LookaheadText.Position position2 = this.startPosition.nextLinePosition();
        if (position2 == null) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        LookaheadText.Position secondLinePosition = position2;
        Integer n = secondLinePosition.charsToNonWhitespace();
        int contentStartOffset = secondLinePosition.getOffset() + (n != null ? n : 0);
        if (this.lastContentPosition == null) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        this.closingDelimiterPosition = position;
        int n2 = contentStartOffset;
        LookaheadText.Position position3 = this.lastContentPosition;
        Intrinsics.checkNotNull((Object)position3);
        IntRange contentRange = new IntRange(n2, position3.getNextLineOrEofOffset());
        SequentialParser.Node contentNode = new SequentialParser.Node(contentRange, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_CONTENT);
        Integer n3 = position.charsToNonWhitespace();
        int n4 = delimiterStartOffset = position.getOffset() + (n3 != null ? n3 : 0);
        IntRange closingDelimiterRange = new IntRange(n4, position.getNextLineOrEofOffset());
        SequentialParser.Node delimiterNode = new SequentialParser.Node(closingDelimiterRange, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_DELIMITER);
        this.productionHolder.addProduction((Collection)CollectionsKt.listOf((Object[])new SequentialParser.Node[]{contentNode, delimiterNode}));
        this.shouldClose = true;
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @NotNull
    public IElementType getDefaultNodeType() {
        return (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER;
    }

    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    public FrontMatterHeaderBlock(@NotNull LookaheadText.Position startPosition, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        super(constraints, productionHolder.mark());
        this.startPosition = startPosition;
        this.productionHolder = productionHolder;
        int n = this.startPosition.getOffset();
        IntRange range = new IntRange(n, this.startPosition.getNextLineOrEofOffset());
        SequentialParser.Node delimiterNode = new SequentialParser.Node(range, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_DELIMITER);
        this.productionHolder.addProduction((Collection)CollectionsKt.listOf((Object)delimiterNode));
    }
}

