/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.html.CommonDefsImplJvmKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.DefinitionListMarkerProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\n\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\n\u0010\u0012\u001a\u00060\u0003R\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0014J\b\u0010\u001b\u001a\u00020\u000fH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\u0003R\u00020\u0004H\u0016R\u0014\u0010\n\u001a\b\u0018\u00010\u0003R\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0018\u00010\u0003R\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/lang/parser/DefinitionListBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;)V", "lastDefinitionNextPosition", "lastDefinitionStartPosition", "acceptAction", "", "action", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "addDefinitionProduction", "", "currentPosition", "allowsSubBlocks", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "position", "currentConstraints", "getDefaultAction", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "Companion", "intellij.markdown.core"})
public final class DefinitionListBlock
extends MarkerBlockImpl {
    private LookaheadText.Position lastDefinitionStartPosition;
    private LookaheadText.Position lastDefinitionNextPosition;
    private final ProductionHolder productionHolder;
    private static final String definitionMarker = ": ";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean allowsSubBlocks() {
        return false;
    }

    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position position, @NotNull MarkdownConstraints currentConstraints) {
        block9: {
            MarkerBlock.ProcessingResult processingResult;
            CharSequence charSequence;
            block11: {
                block10: {
                    boolean bl;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
                        if (DefinitionListMarkerProvider.Companion.isDefinitionLine(position.getCurrentLine())) break block9;
                        String currentLine = position.getCurrentLine();
                        charSequence = currentLine;
                        if (charSequence.length() == 0) break block10;
                        CharSequence $this$all$iv = currentLine;
                        boolean $i$f$all = false;
                        for (int i = 0; i < $this$all$iv.length(); ++i) {
                            char element$iv;
                            char p1 = element$iv = $this$all$iv.charAt(i);
                            boolean bl2 = false;
                            if (CommonDefsImplJvmKt.isWhitespace((char)p1)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                    if (!bl) break block11;
                }
                if (this.lastDefinitionStartPosition != null) {
                    LookaheadText.Position position2 = this.lastDefinitionStartPosition;
                    Intrinsics.checkNotNull((Object)position2);
                    LookaheadText.Position position3 = this.lastDefinitionNextPosition;
                    Intrinsics.checkNotNull((Object)position3);
                    this.addDefinitionProduction(position2, position3);
                }
                this.lastDefinitionStartPosition = null;
                this.lastDefinitionNextPosition = null;
                return MarkerBlock.ProcessingResult.Companion.getCANCEL();
            }
            charSequence = this.lastDefinitionStartPosition;
            if (charSequence == null) {
                processingResult = MarkerBlock.ProcessingResult.Companion.getDEFAULT();
            } else {
                this.lastDefinitionNextPosition = position;
                processingResult = MarkerBlock.ProcessingResult.Companion.getCANCEL();
            }
            return processingResult;
        }
        if (this.lastDefinitionStartPosition != null) {
            LookaheadText.Position position4 = this.lastDefinitionStartPosition;
            Intrinsics.checkNotNull((Object)position4);
            LookaheadText.Position position5 = this.lastDefinitionNextPosition;
            Intrinsics.checkNotNull((Object)position5);
            this.addDefinitionProduction(position4, position5);
        }
        this.lastDefinitionStartPosition = position;
        this.lastDefinitionNextPosition = position;
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    public boolean acceptAction(@NotNull MarkerBlock.ClosingAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if ((action2 == MarkerBlock.ClosingAction.DONE || action2 == MarkerBlock.ClosingAction.DEFAULT) && this.lastDefinitionStartPosition != null) {
            LookaheadText.Position position = this.lastDefinitionStartPosition;
            Intrinsics.checkNotNull((Object)position);
            LookaheadText.Position position2 = this.lastDefinitionNextPosition;
            Intrinsics.checkNotNull((Object)position2);
            this.addDefinitionProduction(position, position2);
        }
        return super.acceptAction(action2);
    }

    private final void addDefinitionProduction(LookaheadText.Position startPosition, LookaheadText.Position currentPosition) {
        Integer n = startPosition.charsToNonWhitespace();
        int start = startPosition.getOffset() + (n != null ? n : 0);
        int end = currentPosition.getNextLineOrEofOffset();
        int markerEnd = start + definitionMarker.length();
        int n2 = start;
        SequentialParser.Node definitionNode = new SequentialParser.Node(new IntRange(n2, end), DefinitionListMarkerProvider.DEFINITION);
        int n3 = start;
        SequentialParser.Node markerNode = new SequentialParser.Node(new IntRange(n3, markerEnd), DefinitionListMarkerProvider.DEFINITION_MARKER);
        int n4 = markerEnd;
        SequentialParser.Node contentNode = new SequentialParser.Node(new IntRange(n4, end), MarkdownElementTypes.PARAGRAPH);
        this.productionHolder.addProduction((Collection)CollectionsKt.listOf((Object[])new SequentialParser.Node[]{contentNode, markerNode, definitionNode}));
    }

    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @NotNull
    public IElementType getDefaultNodeType() {
        return DefinitionListMarkerProvider.DEFINITION_LIST;
    }

    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    public DefinitionListBlock(@NotNull LookaheadText.Position startPosition, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        super(constraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        int n = startPosition.getOffset();
        IntRange range = new IntRange(n, startPosition.getNextLineOrEofOffset());
        DefinitionListBlock.Companion.addWrappedProduction(this.productionHolder, range, DefinitionListMarkerProvider.TERM);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/DefinitionListBlock$Companion;", "", "()V", "definitionMarker", "", "addWrappedProduction", "", "Lorg/intellij/markdown/parser/ProductionHolder;", "range", "Lkotlin/ranges/IntRange;", "type", "Lorg/intellij/markdown/IElementType;", "intellij.markdown.core"})
    public static final class Companion {
        private final void addWrappedProduction(ProductionHolder $this$addWrappedProduction, IntRange range, IElementType type) {
            SequentialParser.Node contentNode = new SequentialParser.Node(range, MarkdownElementTypes.PARAGRAPH);
            SequentialParser.Node definitionNode = new SequentialParser.Node(range, type);
            $this$addWrappedProduction.addProduction((Collection)CollectionsKt.listOf((Object[])new SequentialParser.Node[]{contentNode, definitionNode}));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

