/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlightingLexer;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

public class MarkdownSyntaxHighlighter
extends SyntaxHighlighterBase {
    protected final Lexer lexer = new MarkdownHighlightingLexer();
    protected static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.lexer;
        if (lexer == null) {
            MarkdownSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = MarkdownSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            MarkdownSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.TEXT, (TextAttributesKey)MarkdownHighlighterColors.TEXT_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.STRONG, (TextAttributesKey)MarkdownHighlighterColors.BOLD_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.EMPH, (TextAttributesKey)MarkdownHighlighterColors.ITALIC_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.STRIKETHROUGH, (TextAttributesKey)MarkdownHighlighterColors.STRIKE_THROUGH_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.HORIZONTAL_RULE, (TextAttributesKey)MarkdownHighlighterColors.HRULE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.TABLE_SEPARATOR, (TextAttributesKey)MarkdownHighlighterColors.TABLE_SEPARATOR_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.BLOCK_QUOTE, (TextAttributesKey)MarkdownHighlighterColors.BLOCK_QUOTE_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.LIST_MARKERS, (TextAttributesKey)MarkdownHighlighterColors.LIST_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_MARKERS, (TextAttributesKey)MarkdownHighlighterColors.HEADER_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_1_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_2_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_3_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_4_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_5_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_6_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_6_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.INLINE_LINK, (TextAttributesKey)MarkdownHighlighterColors.EXPLICIT_LINK_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.REFERENCE_LINK_SET, (TextAttributesKey)MarkdownHighlighterColors.REFERENCE_LINK_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.IMAGE, (TextAttributesKey)MarkdownHighlighterColors.IMAGE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.AUTOLINK, (TextAttributesKey)MarkdownHighlighterColors.AUTO_LINK_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_DEFINITION, (TextAttributesKey)MarkdownHighlighterColors.LINK_DEFINITION_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_TEXT, (TextAttributesKey)MarkdownHighlighterColors.LINK_TEXT_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_LABEL, (TextAttributesKey)MarkdownHighlighterColors.LINK_LABEL_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_DESTINATION, (TextAttributesKey)MarkdownHighlighterColors.LINK_DESTINATION_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_TITLE, (TextAttributesKey)MarkdownHighlighterColors.LINK_TITLE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_COMMENT, (TextAttributesKey)MarkdownHighlighterColors.COMMENT_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.BLOCK_QUOTE, (TextAttributesKey)MarkdownHighlighterColors.BLOCK_QUOTE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.UNORDERED_LIST, (TextAttributesKey)MarkdownHighlighterColors.UNORDERED_LIST_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.ORDERED_LIST, (TextAttributesKey)MarkdownHighlighterColors.ORDERED_LIST_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LIST_ITEM, (TextAttributesKey)MarkdownHighlighterColors.LIST_ITEM_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.BACKTICK, (TextAttributesKey)MarkdownHighlighterColors.TEXT_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.CODE_SPAN, (TextAttributesKey)MarkdownHighlighterColors.CODE_SPAN_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_LINE, (TextAttributesKey)MarkdownHighlighterColors.CODE_BLOCK_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_CONTENT, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_START, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_END, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.FENCE_LANG, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_LANGUAGE_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.HTML_BLOCK, (TextAttributesKey)MarkdownHighlighterColors.HTML_BLOCK_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.HTML_TAG, (TextAttributesKey)MarkdownHighlighterColors.INLINE_HTML_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_LIST, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION_LIST_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_MARKER, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION_LIST_MARKER_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION_ATTR_KEY);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_TERM, (TextAttributesKey)MarkdownHighlighterColors.TERM_ATTR_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/markdown/highlighting/MarkdownSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

