/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.AccountManagerBase;
import com.intellij.collaboration.auth.AccountsRepository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.google.accounts.GooglePersistentAccounts;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0003H\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "Lcom/intellij/collaboration/auth/AccountManagerBase;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "()V", "accountsRepository", "Lcom/intellij/collaboration/auth/AccountsRepository;", "deserializeCredentials", "credentials", "", "serializeCredentials", "Companion", "intellij.markdown.core"})
public final class GoogleAccountManager
extends AccountManagerBase<GoogleAccount, GoogleCredentials> {
    @NotNull
    public static final String SERVICE_DISPLAY_NAME = "Google Accounts";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected AccountsRepository<GoogleAccount> accountsRepository() {
        boolean $i$f$service = false;
        Class<GooglePersistentAccounts> serviceClass$iv = GooglePersistentAccounts.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (AccountsRepository)object;
    }

    @NotNull
    protected String serializeCredentials(@NotNull GoogleCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        String string = GoogleAccountsUtils.INSTANCE.getJacksonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)credentials);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonMapper.writerWith\u2026alueAsString(credentials)");
        return string;
    }

    @NotNull
    protected GoogleCredentials deserializeCredentials(@NotNull String credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Object object = GoogleAccountsUtils.INSTANCE.getJacksonMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readValue(credentials, GoogleCredentials.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.disable(De\u2026eCredentials::class.java)");
        return (GoogleCredentials)object;
    }

    public GoogleAccountManager() {
        super(SERVICE_DISPLAY_NAME);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager$Companion;", "", "()V", "SERVICE_DISPLAY_NAME", "", "createAccount", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "userInfo", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "intellij.markdown.core"})
    public static final class Companion {
        @NotNull
        public final GoogleAccount createAccount(@NotNull GoogleUserInfo userInfo) {
            Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
            return new GoogleAccount(userInfo.getId(), userInfo.getEmail());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

