/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.GraphPropertyImpl;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportDialog;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010!\u001a\u00020\u0012*\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestedFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "fileTypeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "selectedFileType", "supportedExportProviders", "", "getSupportedExportProviders", "()Ljava/util/List;", "doAction", "", "selectedFileUrl", "findFirstValidProvider", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "getSettingsComponents", "Lcom/intellij/openapi/ui/DialogPanel;", "createFileTypeField", "Lcom/intellij/ui/layout/Row;", "Lcom/intellij/ui/layout/LayoutBuilder;", "validateFileType", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "combobox", "visible", "Ljavax/swing/JComponent;", "predicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "FileTypeRenderer", "intellij.markdown.core"})
public final class MarkdownExportDialog
extends MarkdownFileActionsBaseDialog {
    private ComboBox<MarkdownExportProvider> fileTypeSelector;
    private MarkdownExportProvider selectedFileType;

    private final List<MarkdownExportProvider> getSupportedExportProviders() {
        return MarkdownExportProvider.Companion.getAllProviders();
    }

    @Override
    protected void doAction(@NotNull String selectedFileUrl) {
        Object v1;
        block3: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
            Iterable iterable2 = iterable = (Iterable)this.getSupportedExportProviders();
            for (Object t : iterable2) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                MarkdownExportProvider markdownExportProvider = this.selectedFileType;
                if (markdownExportProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
                }
                if (!Intrinsics.areEqual((Object)it, (Object)markdownExportProvider)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        MarkdownExportProvider markdownExportProvider = v1;
        if (markdownExportProvider == null) {
            return;
        }
        MarkdownExportProvider provider = markdownExportProvider;
        String outputFile = selectedFileUrl + "." + provider.getFormatDescription().getExtension();
        provider.exportFile(this.getProject(), this.getFile(), outputFile);
    }

    @Override
    @Nullable
    protected String getFileNameIfExist(@NotNull String dir, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
        }
        String fullName = fileNameWithoutExtension + "." + ((MarkdownExportProvider)comboBox.getItem()).getFormatDescription().getExtension();
        return FileUtil.exists((String)FileUtil.join((String[])new String[]{dir, fullName})) ? fullName : null;
    }

    @Override
    @NotNull
    protected Row createFileTypeField(@NotNull LayoutBuilder $this$createFileTypeField) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileTypeField, (String)"$this$createFileTypeField");
        return RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$createFileTypeField), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ MarkdownExportDialog this$0;

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Collection $this$toTypedArray$iv = MarkdownExportDialog.access$getSupportedExportProviders$p(this.this$0);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                MarkdownExportProvider[] markdownExportProviderArray = thisCollection$iv.toArray(new MarkdownExportProvider[0]);
                if (markdownExportProviderArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                DefaultComboBoxModel<MarkdownExportProvider> model = new DefaultComboBoxModel<MarkdownExportProvider>(markdownExportProviderArray);
                GraphProperty fileTypeProperty2 = GraphPropertyImpl.Companion.graphProperty(new PropertyGraph(null, false, 3, null), (Function0)new Function0<MarkdownExportProvider>(this){
                    final /* synthetic */ createFileTypeField.1 this$0;

                    @NotNull
                    public final MarkdownExportProvider invoke() {
                        return MarkdownExportDialog.access$getSelectedFileType$p(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                fileTypeProperty2.afterChange((Function1)new Function1<MarkdownExportProvider, Unit>(this){
                    final /* synthetic */ createFileTypeField.1 this$0;

                    public final void invoke(@NotNull MarkdownExportProvider it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MarkdownExportDialog.access$setSelectedFileType$p(this.this$0.this$0, it);
                        Action action2 = MarkdownExportDialog.access$getOKAction(this.this$0.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"okAction");
                        CharSequence charSequence = it.validate(MarkdownExportDialog.access$getProject$p(this.this$0.this$0), MarkdownExportDialog.access$getFile$p(this.this$0.this$0));
                        action2.setEnabled(charSequence == null || charSequence.length() == 0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                MarkdownExportProvider markdownExportProvider = MarkdownExportDialog.access$findFirstValidProvider(this.this$0);
                if (markdownExportProvider == null) {
                    markdownExportProvider = (MarkdownExportProvider)CollectionsKt.first((List)MarkdownExportDialog.access$getSupportedExportProviders$p(this.this$0));
                }
                MarkdownExportDialog.access$setSelectedFileType$p(this.this$0, markdownExportProvider);
                Cell cell = (Cell)$this$row;
                String string = MarkdownBundle.message("markdown.export.dialog.filetype.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026t.dialog.filetype.label\")");
                Cell.label$default((Cell)cell, (String)string, null, null, (boolean)false, (int)14, null);
                MarkdownExportDialog.access$setFileTypeSelector$p(this.this$0, (ComboBox)$this$row.comboBox((ComboBoxModel)model, fileTypeProperty2, (ListCellRenderer)((Object)this.this$0.new FileTypeRenderer())).withValidationOnApply((Function2)new Function2<ValidationInfoBuilder, ComboBox<MarkdownExportProvider>, ValidationInfo>(this){
                    final /* synthetic */ createFileTypeField.1 this$0;

                    @Nullable
                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$withValidationOnApply, @NotNull ComboBox<MarkdownExportProvider> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$withValidationOnApply, (String)"$receiver");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return MarkdownExportDialog.access$validateFileType(this.this$0.this$0, $this$withValidationOnApply, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }).focused().getComponent());
            }
            {
                this.this$0 = markdownExportDialog;
                super(1);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected DialogPanel getSettingsComponents() {
        void $this$mapNotNullTo$iv$iv;
        DialogPanel panel2 = new DialogPanel((LayoutManager)new BorderLayout());
        Iterable $this$mapNotNull$iv = this.getSupportedExportProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JComponent jComponent;
            JComponent jComponent2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownExportProvider it = (MarkdownExportProvider)element$iv$iv;
            boolean bl2 = false;
            if (it.createSettingsComponent(this.getProject(), new File(this.getSuggestedFilePath())) != null) {
                JComponent jComponent3;
                JComponent $this$apply = jComponent3;
                boolean bl3 = false;
                ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
                if (comboBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
                }
                this.visible($this$apply, ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)it));
                jComponent2 = jComponent3;
            } else {
                jComponent2 = null;
            }
            if (jComponent2 == null) continue;
            JComponent it$iv$iv = jComponent = jComponent2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl = false;
            panel2.add((Component)it);
        }
        return panel2;
    }

    private final MarkdownExportProvider findFirstValidProvider() {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.getSupportedExportProviders();
            for (Object t : iterable2) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                if (!(it.validate(this.getProject(), this.getFile()) == null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void visible(JComponent $this$visible, ComponentPredicate predicate) {
        $this$visible.setVisible((Boolean)predicate.invoke());
        predicate.addListener((Function1)new Function1<Boolean, Unit>($this$visible){
            final /* synthetic */ JComponent $this_visible;

            public final void invoke(boolean it) {
                this.$this_visible.setVisible(it);
            }
            {
                this.$this_visible = jComponent;
                super(1);
            }
        });
    }

    private final ValidationInfo validateFileType(ValidationInfoBuilder $this$validateFileType, ComboBox<MarkdownExportProvider> combobox) {
        ValidationInfo validationInfo;
        String errorMessage;
        MarkdownExportProvider provider = (MarkdownExportProvider)combobox.getItem();
        String string = errorMessage = provider.validate(this.getProject(), this.getFile());
        if (string != null) {
            String string2;
            String p1 = string2 = string;
            boolean bl = false;
            validationInfo = $this$validateFileType.error(p1);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public MarkdownExportDialog(@NotNull VirtualFile targetFile, @NotNull String suggestedFilePath, @NotNull Project project) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, suggestedFilePath, targetFile);
        this.setTitle(MarkdownBundle.message("markdown.export.from.docx.dialog.title", new Object[0]));
        this.setOKButtonText(MarkdownBundle.message("markdown.export.dialog.ok.button", new Object[0]));
        Action action2 = this.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"okAction");
        MarkdownExportProvider markdownExportProvider = this.selectedFileType;
        if (markdownExportProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
        }
        action2.setEnabled((charSequence = (CharSequence)markdownExportProvider.validate(project, targetFile)) == null || charSequence.length() == 0);
    }

    public static final /* synthetic */ List access$getSupportedExportProviders$p(MarkdownExportDialog $this) {
        return $this.getSupportedExportProviders();
    }

    public static final /* synthetic */ MarkdownExportProvider access$getSelectedFileType$p(MarkdownExportDialog $this) {
        MarkdownExportProvider markdownExportProvider = $this.selectedFileType;
        if (markdownExportProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
        }
        return markdownExportProvider;
    }

    public static final /* synthetic */ void access$setSelectedFileType$p(MarkdownExportDialog $this, MarkdownExportProvider markdownExportProvider) {
        $this.selectedFileType = markdownExportProvider;
    }

    public static final /* synthetic */ Action access$getOKAction(MarkdownExportDialog $this) {
        return $this.getOKAction();
    }

    public static final /* synthetic */ MarkdownExportProvider access$findFirstValidProvider(MarkdownExportDialog $this) {
        return $this.findFirstValidProvider();
    }

    public static final /* synthetic */ ComboBox access$getFileTypeSelector$p(MarkdownExportDialog $this) {
        ComboBox<MarkdownExportProvider> comboBox = $this.fileTypeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
        }
        return comboBox;
    }

    public static final /* synthetic */ void access$setFileTypeSelector$p(MarkdownExportDialog $this, ComboBox comboBox) {
        $this.fileTypeSelector = comboBox;
    }

    public static final /* synthetic */ ValidationInfo access$validateFileType(MarkdownExportDialog $this, ValidationInfoBuilder $this$access_u24validateFileType, ComboBox combobox) {
        return $this.validateFileType($this$access_u24validateFileType, (ComboBox<MarkdownExportProvider>)combobox);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog$FileTypeRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;)V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.markdown.core"})
    private final class FileTypeRenderer
    extends SimpleListCellRenderer<MarkdownExportProvider> {
        public void customize(@NotNull JList<? extends MarkdownExportProvider> list2, @Nullable MarkdownExportProvider value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value == null) {
                return;
            }
            this.setText(value.getFormatDescription().getFormatName());
            String errorMessage = value.validate(MarkdownExportDialog.this.getProject(), MarkdownExportDialog.this.getFile());
            if (errorMessage != null) {
                this.setEnabled(false);
                this.setToolTipText(errorMessage);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

