/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils$WhenMappings;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\f\b\u0002\u0010\n\u001a\u00060\u0004j\u0002`\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\n\u001a\u00060\u0004j\u0002`\u0005J\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u001c\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005*\u00020\u001f2\f\b\u0002\u0010\n\u001a\u00060\u0004j\u0002`\u0005J\u0012\u0010 \u001a\u00020\f*\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\n\u0010#\u001a\u00020\u0019*\u00020\u001fJ\n\u0010#\u001a\u00020\u0019*\u00020$J\n\u0010#\u001a\u00020\u0019*\u00020%J\n\u0010&\u001a\u00020\u0019*\u00020\u001dJ\n\u0010'\u001a\u00020\u0019*\u00020\u001dJ\u0012\u0010'\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010(\u001a\u00020\u0013J8\u0010)\u001a\u00020**\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00072\b\b\u0002\u0010,\u001a\u00020\u00192\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010-\u001a\u00020\u0007J\u001c\u0010.\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010+\u001a\u00020\u00072\b\b\u0002\u0010/\u001a\u00020\u0019J\u0014\u00100\u001a\u00020\u0019*\u00020\u001f2\b\b\u0002\u0010/\u001a\u00020\u0019J:\u00101\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010+\u001a\u00020\u00072\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020*032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020*03J\u0012\u00105\u001a\u00020**\u00020%2\u0006\u0010+\u001a\u00020\u0007J\u0012\u00106\u001a\u00020**\u00020\u001f2\u0006\u0010+\u001a\u00020\u0007J8\u00107\u001a\u00020**\u00020\u001f2\u0006\u00108\u001a\u0002092\u0006\u0010+\u001a\u00020\u00072\b\b\u0002\u0010:\u001a\u00020\u00192\b\b\u0002\u0010;\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u0019J\u0014\u0010<\u001a\u00020**\u00020=2\u0006\u0010>\u001a\u00020\u001bH\u0002J\u001a\u0010?\u001a\u00020**\u00020%2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007J\u001a\u0010B\u001a\u00020**\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010B\u001a\u00020**\u00020%2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010C\u001a\u00020**\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0007J\"\u0010C\u001a\u00020**\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010D\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010+\u001a\u00020\u0007\u00a8\u0006E"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableModificationUtils;", "", "()V", "buildEmptyRow", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "columns", "", "fillCharacter", "", "builder", "buildEmptyTable", "", "contentRows", "buildHeaderSeparator", "buildRealignedCellContent", "cellContent", "wholeCellWidth", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "buildSeparatorCellContent", "cellContentWidth", "getCellPotentialWidth", "cellText", "isSeparatorCellCorrectlyFormatted", "", "obtainCellSelectionRange", "Lcom/intellij/openapi/util/TextRange;", "cell", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "withBorders", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "getContentWithoutWhitespaces", "document", "Lcom/intellij/openapi/editor/Document;", "hasCorrectBorders", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "hasCorrectPadding", "hasValidAlignment", "expected", "insertColumn", "", "columnIndex", "after", "columnWidth", "isColumnCorrectlyFormatted", "checkAlignment", "isCorrectlyFormatted", "modifyColumn", "transformSeparator", "Lkotlin/Function1;", "transformCell", "removeCell", "removeColumn", "selectColumn", "editor", "Lcom/intellij/openapi/editor/Editor;", "withHeader", "withSeparator", "setSelectionFromRange", "Lcom/intellij/openapi/editor/Caret;", "textRange", "swapCells", "leftIndex", "rightIndex", "updateAlignment", "updateColumnAlignment", "validateColumnAlignment", "intellij.markdown.core"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class TableModificationUtils {
    @NotNull
    public static final TableModificationUtils INSTANCE;

    public final boolean modifyColumn(@NotNull MarkdownTable $this$modifyColumn, int columnIndex, @NotNull Function1<? super TextRange, Unit> transformSeparator, @NotNull Function1<? super MarkdownTableCell, Unit> transformCell) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyColumn, (String)"$this$modifyColumn");
        Intrinsics.checkNotNullParameter(transformSeparator, (String)"transformSeparator");
        Intrinsics.checkNotNullParameter(transformCell, (String)"transformCell");
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$modifyColumn);
        if (markdownTableSeparatorRow == null || (markdownTableSeparatorRow = MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null)) == null) {
            return false;
        }
        MarkdownTableSeparatorRow separatorRange = markdownTableSeparatorRow;
        MarkdownCompositePsiElementBase markdownCompositePsiElementBase = $this$modifyColumn.getHeaderRow();
        if (markdownCompositePsiElementBase == null || (markdownCompositePsiElementBase = markdownCompositePsiElementBase.getCell(columnIndex)) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)markdownCompositePsiElementBase, (String)"headerRow?.getCell(columnIndex) ?: return false");
        MarkdownCompositePsiElementBase headerCell = markdownCompositePsiElementBase;
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$modifyColumn, columnIndex, false);
        for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
            transformCell.invoke((Object)cell);
        }
        transformSeparator.invoke((Object)separatorRange);
        transformCell.invoke((Object)headerCell);
        return true;
    }

    private final int getCellPotentialWidth(String cellText) {
        int width = cellText.length();
        if (!StringsKt.startsWith$default((CharSequence)cellText, (char)' ', (boolean)false, (int)2, null)) {
            ++width;
        }
        if (!StringsKt.endsWith$default((CharSequence)cellText, (char)' ', (boolean)false, (int)2, null)) {
            ++width;
        }
        return width;
    }

    private final boolean isSeparatorCellCorrectlyFormatted(String cellText) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = cellText;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '-' || it == ':') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectPadding(@NotNull MarkdownTableCell $this$hasCorrectPadding) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectPadding, (String)"$this$hasCorrectPadding");
        String cellText = $this$hasCorrectPadding.getText();
        if ($this$hasCorrectPadding.getText().length() < 5) return false;
        String string = cellText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cellText");
        if (!StringsKt.startsWith$default((String)string, (String)" ", (boolean)false, (int)2, null)) return false;
        if (!StringsKt.endsWith$default((String)cellText, (String)" ", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isColumnCorrectlyFormatted(@NotNull MarkdownTable $this$isColumnCorrectlyFormatted, int columnIndex, boolean checkAlignment) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isColumnCorrectlyFormatted, (String)"$this$isColumnCorrectlyFormatted");
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$isColumnCorrectlyFormatted, columnIndex, true);
        if (cells.isEmpty()) {
            return true;
        }
        if (checkAlignment && !this.validateColumnAlignment($this$isColumnCorrectlyFormatted, columnIndex)) {
            return false;
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$isColumnCorrectlyFormatted);
        String string = markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getCellText(columnIndex) : null;
        Intrinsics.checkNotNull((Object)string);
        String separatorCellText = string;
        String string2 = ((MarkdownTableCell)CollectionsKt.first(cells)).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cells.first().text");
        int width = this.getCellPotentialWidth(string2);
        if (separatorCellText.length() != width) return false;
        if (!this.isSeparatorCellCorrectlyFormatted(separatorCellText)) {
            return false;
        }
        Iterable $this$all$iv = cells;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            MarkdownTableCell it = (MarkdownTableCell)element$iv;
            boolean bl2 = false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.text");
            int selfWidth = INSTANCE.getCellPotentialWidth(string3);
            if (!INSTANCE.hasCorrectPadding(it)) return false;
            TextRange textRange = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it.textRange");
            if (selfWidth != textRange.getLength()) return false;
            if (selfWidth != width) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public static /* synthetic */ boolean isColumnCorrectlyFormatted$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableModificationUtils.isColumnCorrectlyFormatted(markdownTable, n, bl);
    }

    public final boolean isCorrectlyFormatted(@NotNull MarkdownTable $this$isCorrectlyFormatted, boolean checkAlignment) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isCorrectlyFormatted, (String)"$this$isCorrectlyFormatted");
            Iterable $this$all$iv = (Iterable)RangesKt.until((int)0, (int)TableUtils.INSTANCE.getColumnsCount($this$isCorrectlyFormatted));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (INSTANCE.isColumnCorrectlyFormatted($this$isCorrectlyFormatted, it, checkAlignment)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isCorrectlyFormatted$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return tableModificationUtils.isCorrectlyFormatted(markdownTable, bl);
    }

    public final boolean hasValidAlignment(@NotNull MarkdownTableCell $this$hasValidAlignment) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidAlignment, (String)"$this$hasValidAlignment");
        MarkdownTable markdownTable = $this$hasValidAlignment.getParentTable();
        if (markdownTable == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)markdownTable, (String)"parentTable ?: return true");
        MarkdownTable table = markdownTable;
        MarkdownTableSeparatorRow.CellAlignment columnAlignment = TableUtils.INSTANCE.getColumnAlignment(table, $this$hasValidAlignment.getColumnIndex());
        return this.hasValidAlignment($this$hasValidAlignment, columnAlignment);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean hasValidAlignment(@NotNull MarkdownTableCell $this$hasValidAlignment, @NotNull MarkdownTableSeparatorRow.CellAlignment expected) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidAlignment, (String)"$this$hasValidAlignment");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        content = $this$hasValidAlignment.getText();
        if (content.length() < 5) {
            return false;
        }
        v0 = content;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"content");
        if (StringsKt.isBlank((CharSequence)v0)) {
            return true;
        }
        switch (TableModificationUtils$WhenMappings.$EnumSwitchMapping$0[expected.ordinal()]) {
            case 1: {
                return content.charAt(0) == ' ' && content.charAt(1) != ' ';
            }
            case 2: {
                return StringsKt.last((CharSequence)content) == ' ' && content.charAt(StringsKt.getLastIndex((CharSequence)content) - 1) != ' ';
            }
            case 3: {
                $this$indexOfFirst$iv = content;
                $i$f$indexOfFirst = false;
                var8_9 = $this$indexOfFirst$iv.length();
                for (index$iv = 0; index$iv < var8_9; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    $i$a$-indexOfFirst-TableModificationUtils$hasValidAlignment$spacesLeft$1 = false;
                    if (!(it != ' ')) continue;
                    v1 = index$iv;
                    ** GOTO lbl26
                }
                v1 = -1;
lbl26:
                // 2 sources

                spacesLeft = v1;
                $this$indexOfLast$iv = content;
                $i$f$indexOfLast = false;
                var8_9 = $this$indexOfLast$iv.length() + -1;
                if (0 > var8_9) ** GOTO lbl39
                do {
                    index$iv = var8_9--;
                    it = $this$indexOfLast$iv.charAt(index$iv);
                    $i$a$-indexOfLast-TableModificationUtils$hasValidAlignment$spacesRight$1 = false;
                    if (!(it != ' ')) continue;
                    v2 = index$iv;
                    ** GOTO lbl40
                } while (0 <= var8_9);
lbl39:
                // 2 sources

                v2 = spacesRight = -1;
lbl40:
                // 2 sources

                if (spacesLeft == -1 || spacesRight == -1) {
                    return true;
                }
                spacesRight = StringsKt.getLastIndex((CharSequence)content) - spacesRight + 1;
                return ++spacesLeft == spacesRight || spacesLeft + 1 == spacesRight;
            }
        }
        return true;
    }

    public final boolean validateColumnAlignment(@NotNull MarkdownTable $this$validateColumnAlignment, int columnIndex) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$validateColumnAlignment, (String)"$this$validateColumnAlignment");
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$validateColumnAlignment);
            Intrinsics.checkNotNull((Object)markdownTableSeparatorRow);
            MarkdownTableSeparatorRow.CellAlignment expected = markdownTableSeparatorRow.getCellAlignment(columnIndex);
            if (expected == MarkdownTableSeparatorRow.CellAlignment.NONE) {
                return true;
            }
            Iterable $this$all$iv = TableUtils.INSTANCE.getColumnCells($this$validateColumnAlignment, columnIndex, true);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MarkdownTableCell it = (MarkdownTableCell)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.hasValidAlignment(it, expected)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final String buildSeparatorCellContent(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment, int cellContentWidth) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        boolean bl2 = bl = cellContentWidth > 4;
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        switch (TableModificationUtils$WhenMappings.$EnumSwitchMapping$1[alignment.ordinal()]) {
            case 1: {
                object = StringsKt.repeat((CharSequence)"-", (int)cellContentWidth);
                break;
            }
            case 2: {
                object = ":" + StringsKt.repeat((CharSequence)"-", (int)(cellContentWidth - 1));
                break;
            }
            case 3: {
                object = StringsKt.repeat((CharSequence)"-", (int)(cellContentWidth - 1)) + ":";
                break;
            }
            case 4: {
                object = ":" + StringsKt.repeat((CharSequence)"-", (int)(cellContentWidth - 2)) + ":";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @NotNull
    public final String buildRealignedCellContent(@NotNull String cellContent, int wholeCellWidth, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cellContent, (String)"cellContent");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        boolean bl2 = bl = wholeCellWidth >= cellContent.length();
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        switch (TableModificationUtils$WhenMappings.$EnumSwitchMapping$2[alignment.ordinal()]) {
            case 1: {
                object = StringsKt.repeat((CharSequence)" ", (int)(wholeCellWidth - cellContent.length() - 1)) + cellContent + " ";
                break;
            }
            case 2: {
                int it;
                StringBuilder stringBuilder;
                int leftPadding = (wholeCellWidth - cellContent.length()) / 2;
                int rightPadding = wholeCellWidth - cellContent.length() - leftPadding;
                StringBuilder $this$buildString = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                int n = leftPadding;
                int n2 = 0;
                while (n2 < n) {
                    it = n2++;
                    boolean bl4 = false;
                    $this$buildString.append(' ');
                }
                $this$buildString.append(cellContent);
                n = rightPadding;
                n2 = 0;
                while (n2 < n) {
                    it = n2++;
                    boolean bl5 = false;
                    $this$buildString.append(' ');
                }
                String string = stringBuilder.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                break;
            }
            default: {
                object = " " + cellContent + StringsKt.repeat((CharSequence)" ", (int)(wholeCellWidth - cellContent.length() - 1));
            }
        }
        return object;
    }

    @NotNull
    public final String getContentWithoutWhitespaces(@NotNull MarkdownTableCell $this$getContentWithoutWhitespaces, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getContentWithoutWhitespaces, (String)"$this$getContentWithoutWhitespaces");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange range = $this$getContentWithoutWhitespaces.getTextRange();
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence charSequence2 = charSequence;
        TextRange textRange = range;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
        int n = textRange.getStartOffset();
        int n2 = range.getEndOffset();
        String content2 = ((Object)charSequence2.subSequence(n, n2)).toString();
        return StringsKt.trim((String)content2, (char[])new char[]{' '});
    }

    public final void updateAlignment(@NotNull MarkdownTableSeparatorRow $this$updateAlignment, @NotNull Document document, int columnIndex, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAlignment, (String)"$this$updateAlignment");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default($this$updateAlignment, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange cellRange = textRange;
        int width = cellRange.getLength();
        String replacement = this.buildSeparatorCellContent(alignment, width);
        document.replaceString(cellRange.getStartOffset(), cellRange.getEndOffset(), (CharSequence)replacement);
    }

    public final void updateAlignment(@NotNull MarkdownTableCell $this$updateAlignment, @NotNull Document document, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAlignment, (String)"$this$updateAlignment");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        if (alignment == MarkdownTableSeparatorRow.CellAlignment.NONE) {
            return;
        }
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence documentText = charSequence;
        TextRange cellRange = $this$updateAlignment.getTextRange();
        CharSequence charSequence2 = documentText;
        TextRange textRange = cellRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"cellRange");
        int n = textRange.getStartOffset();
        int n2 = cellRange.getEndOffset();
        String cellText = ((Object)charSequence2.subSequence(n, n2)).toString();
        String actualContent = StringsKt.trim((String)cellText, (char[])new char[]{' '});
        String replacement = this.buildRealignedCellContent(actualContent, cellText.length(), alignment);
        document.replaceString(cellRange.getStartOffset(), cellRange.getEndOffset(), (CharSequence)replacement);
    }

    public final void updateColumnAlignment(@NotNull MarkdownTable $this$updateColumnAlignment, @NotNull Document document, int columnIndex, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateColumnAlignment, (String)"$this$updateColumnAlignment");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.modifyColumn($this$updateColumnAlignment, columnIndex, (Function1<? super TextRange, Unit>)((Function1)new Function1<TextRange, Unit>($this$updateColumnAlignment, document, columnIndex, alignment){
            final /* synthetic */ MarkdownTable $this_updateColumnAlignment;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $columnIndex;
            final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment $alignment;

            public final void invoke(@NotNull TextRange it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(this.$this_updateColumnAlignment);
                    if (markdownTableSeparatorRow == null) break block0;
                    TableModificationUtils.INSTANCE.updateAlignment(markdownTableSeparatorRow, this.$document, this.$columnIndex, this.$alignment);
                }
            }
            {
                this.$this_updateColumnAlignment = markdownTable;
                this.$document = document;
                this.$columnIndex = n;
                this.$alignment = cellAlignment;
                super(1);
            }
        }), (Function1<? super MarkdownTableCell, Unit>)((Function1)new Function1<MarkdownTableCell, Unit>(document, alignment){
            final /* synthetic */ Document $document;
            final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment $alignment;

            public final void invoke(@NotNull MarkdownTableCell it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TableModificationUtils.INSTANCE.updateAlignment(it, this.$document, this.$alignment);
            }
            {
                this.$document = document;
                this.$alignment = cellAlignment;
                super(1);
            }
        }));
    }

    public final void updateColumnAlignment(@NotNull MarkdownTable $this$updateColumnAlignment, @NotNull Document document, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$updateColumnAlignment, (String)"$this$updateColumnAlignment");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = TableUtils.INSTANCE.getSeparatorRow($this$updateColumnAlignment);
        if (object == null || (object = object.getCellAlignment(columnIndex)) == null) {
            return;
        }
        Object alignment = object;
        this.updateColumnAlignment($this$updateColumnAlignment, document, columnIndex, (MarkdownTableSeparatorRow.CellAlignment)((Object)alignment));
    }

    @NotNull
    public final StringBuilder buildEmptyRow(@NotNull MarkdownTable $this$buildEmptyRow, @NotNull StringBuilder builder) {
        MarkdownTableRow markdownTableRow;
        Intrinsics.checkNotNullParameter((Object)$this$buildEmptyRow, (String)"$this$buildEmptyRow");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MarkdownTableRow markdownTableRow2 = markdownTableRow = $this$buildEmptyRow.getHeaderRow();
        if (markdownTableRow2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)markdownTableRow2, (String)"checkNotNull(headerRow)");
        MarkdownTableRow header = markdownTableRow2;
        builder.append('|');
        Iterator<MarkdownTableCell> iterator = header.getCells().iterator();
        while (iterator.hasNext()) {
            MarkdownTableCell cell;
            MarkdownTableCell markdownTableCell = cell = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)markdownTableCell, (String)"cell");
            TextRange textRange = markdownTableCell.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"cell.textRange");
            int n = textRange.getLength();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                builder.append(' ');
            }
            builder.append('|');
        }
        return builder;
    }

    public static /* synthetic */ StringBuilder buildEmptyRow$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            stringBuilder = new StringBuilder();
        }
        return tableModificationUtils.buildEmptyRow(markdownTable, stringBuilder);
    }

    public final void selectColumn(@NotNull MarkdownTable $this$selectColumn, @NotNull Editor editor2, int columnIndex, boolean withHeader, boolean withSeparator, boolean withBorders) {
        Caret caret;
        Intrinsics.checkNotNullParameter((Object)$this$selectColumn, (String)"$this$selectColumn");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$selectColumn, columnIndex, withHeader);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        CaretModel caretModel2 = caretModel;
        caretModel2.removeSecondaryCarets();
        Caret $this$apply = caret = caretModel2.getCurrentCaret();
        boolean bl = false;
        TextRange textRange = INSTANCE.obtainCellSelectionRange((MarkdownTableCell)CollectionsKt.first(cells), withBorders);
        $this$apply.moveToOffset(textRange.getStartOffset());
        INSTANCE.setSelectionFromRange($this$apply, textRange);
        if (withSeparator) {
            TextRange range;
            TextRange textRange2;
            if (withBorders) {
                MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$selectColumn);
                textRange2 = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRangeWithPipes$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
            } else {
                MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$selectColumn);
                textRange2 = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
            }
            TextRange textRange3 = range = textRange2;
            if (textRange3 != null) {
                Caret caret2;
                Iterator iterator;
                Iterator textRange4 = iterator = textRange3;
                boolean bl2 = false;
                Caret caret3 = caret2 = caretModel2.addCaret(editor2.offsetToVisualPosition(textRange4.getStartOffset()));
                if (caret3 != null) {
                    INSTANCE.setSelectionFromRange(caret3, (TextRange)textRange4);
                }
            }
        }
        for (MarkdownTableCell cell : SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)cells), (int)1)) {
            Caret caret4;
            TextRange textRange5 = this.obtainCellSelectionRange(cell, withBorders);
            Caret caret5 = caret4 = caretModel2.addCaret(editor2.offsetToVisualPosition(textRange5.getStartOffset()));
            if (caret5 == null) continue;
            this.setSelectionFromRange(caret5, textRange5);
        }
    }

    public static /* synthetic */ void selectColumn$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, Editor editor2, int n, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        tableModificationUtils.selectColumn(markdownTable, editor2, n, bl, bl2, bl3);
    }

    private final TextRange obtainCellSelectionRange(MarkdownTableCell cell, boolean withBorders) {
        int n;
        int n2;
        Object v4;
        PsiElement leftPipe2;
        TextRange range;
        block8: {
            Object v2;
            Object object2;
            Sequence sequence;
            block7: {
                Sequence sequence2;
                range = cell.getTextRange();
                if (!withBorders) {
                    TextRange textRange = range;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                    return textRange;
                }
                sequence = sequence2 = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)cell), (boolean)false, (boolean)false), (Function1)obtainCellSelectionRange.leftPipe.1.INSTANCE);
                for (Object object2 : sequence) {
                    PsiElement it = (PsiElement)object2;
                    boolean bl = false;
                    IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
                    if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                    v2 = object2;
                    break block7;
                }
                v2 = null;
            }
            leftPipe2 = v2;
            sequence = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)cell), (boolean)true, (boolean)false), (Function1)obtainCellSelectionRange.rightPipe.1.INSTANCE);
            Iterator iterator = sequence;
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                v4 = e;
                break block8;
            }
            v4 = null;
        }
        PsiElement rightPipe2 = v4;
        PsiElement psiElement = leftPipe2;
        if (psiElement != null) {
            n2 = UtilsKt.getStartOffset((PsiElement)psiElement);
        } else {
            TextRange textRange = range;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
            n2 = textRange.getStartOffset();
        }
        int left = n2;
        PsiElement psiElement2 = rightPipe2;
        if (psiElement2 != null) {
            n = UtilsKt.getEndOffset((PsiElement)psiElement2);
        } else {
            TextRange textRange = range;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
            n = textRange.getEndOffset();
        }
        int right = n;
        return new TextRange(left, right);
    }

    private final void setSelectionFromRange(Caret $this$setSelectionFromRange, TextRange textRange) {
        $this$setSelectionFromRange.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public final void insertColumn(@NotNull MarkdownTable $this$insertColumn, @NotNull Document document, int columnIndex, boolean after, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment, int columnWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$insertColumn, (String)"$this$insertColumn");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$insertColumn, columnIndex, false);
        MarkdownTableRow markdownTableRow = $this$insertColumn.getHeaderRow();
        MarkdownTableCell markdownTableCell = markdownTableRow != null ? markdownTableRow.getCell(columnIndex) : null;
        Intrinsics.checkNotNull((Object)markdownTableCell);
        Intrinsics.checkNotNullExpressionValue((Object)markdownTableCell, (String)"headerRow?.getCell(columnIndex)!!");
        MarkdownTableCell headerCell = markdownTableCell;
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$insertColumn);
        TextRange textRange = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
        Intrinsics.checkNotNull(textRange);
        TextRange separatorCell = textRange;
        String cellContent = StringsKt.repeat((CharSequence)" ", (int)columnWidth);
        for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
            if (after) {
                document.insertString(UtilsKt.getEndOffset((PsiElement)((PsiElement)cell)) + 1, (CharSequence)(cellContent + "|"));
                continue;
            }
            document.insertString(UtilsKt.getStartOffset((PsiElement)((PsiElement)cell)) - 1, (CharSequence)("|" + cellContent));
        }
        if (after) {
            document.insertString(separatorCell.getEndOffset() + 1, (CharSequence)(this.buildSeparatorCellContent(alignment, columnWidth) + "|"));
        } else {
            document.insertString(separatorCell.getStartOffset() - 1, (CharSequence)("|" + this.buildSeparatorCellContent(alignment, columnWidth)));
        }
        if (after) {
            document.insertString(UtilsKt.getEndOffset((PsiElement)((PsiElement)headerCell)) + 1, (CharSequence)(cellContent + "|"));
        } else {
            document.insertString(UtilsKt.getStartOffset((PsiElement)((PsiElement)headerCell)) - 1, (CharSequence)("|" + cellContent));
        }
    }

    public static /* synthetic */ void insertColumn$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, Document document, int n, boolean bl, MarkdownTableSeparatorRow.CellAlignment cellAlignment, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            cellAlignment = MarkdownTableSeparatorRow.CellAlignment.NONE;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 5;
        }
        tableModificationUtils.insertColumn(markdownTable, document, n, bl, cellAlignment, n2);
    }

    @NotNull
    public final StringBuilder buildEmptyRow(int columns, char fillCharacter, @NotNull StringBuilder builder) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        StringBuilder $this$apply = stringBuilder = builder;
        boolean bl = false;
        int n = columns;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl2 = false;
            $this$apply.append('|');
            int n2 = 5;
            int n3 = 0;
            while (n3 < n2) {
                int it2 = n3++;
                boolean bl3 = false;
                $this$apply.append(fillCharacter);
            }
        }
        $this$apply.append('|');
        return stringBuilder;
    }

    public static /* synthetic */ StringBuilder buildEmptyRow$default(TableModificationUtils tableModificationUtils, int n, char c, StringBuilder stringBuilder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            c = (char)32;
        }
        if ((n2 & 4) != 0) {
            stringBuilder = new StringBuilder();
        }
        return tableModificationUtils.buildEmptyRow(n, c, stringBuilder);
    }

    @NotNull
    public final StringBuilder buildHeaderSeparator(int columns, @NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.buildEmptyRow(columns, '-', builder);
    }

    public static /* synthetic */ StringBuilder buildHeaderSeparator$default(TableModificationUtils tableModificationUtils, int n, StringBuilder stringBuilder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return tableModificationUtils.buildHeaderSeparator(n, stringBuilder);
    }

    @NotNull
    public final String buildEmptyTable(int contentRows, int columns) {
        StringBuilder builder = new StringBuilder();
        TableModificationUtils.buildEmptyRow$default(this, columns, '\u0000', builder, 2, null);
        builder.append('\n');
        this.buildHeaderSeparator(columns, builder);
        builder.append('\n');
        int n = 0;
        while (n < contentRows) {
            int it = n++;
            boolean bl = false;
            TableModificationUtils.buildEmptyRow$default(INSTANCE, columns, '\u0000', builder, 2, null);
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectBorders(@NotNull MarkdownTableRow $this$hasCorrectBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"$this$hasCorrectBorders");
        PsiElement psiElement = $this$hasCorrectBorders.getFirstChild();
        if (psiElement == null) return false;
        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
        if (!PsiUtilsKt.hasType(psiElement, iElementType)) return false;
        PsiElement psiElement2 = $this$hasCorrectBorders.getLastChild();
        if (psiElement2 == null) return false;
        IElementType iElementType2 = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
        if (!PsiUtilsKt.hasType(psiElement2, iElementType2)) return false;
        return true;
    }

    public final boolean hasCorrectBorders(@NotNull MarkdownTableSeparatorRow $this$hasCorrectBorders) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"$this$hasCorrectBorders");
        String it = string = $this$hasCorrectBorders.getText();
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        return StringsKt.startsWith$default((CharSequence)string2, (char)'|', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)it, (char)'|', (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectBorders(@NotNull MarkdownTable $this$hasCorrectBorders) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"$this$hasCorrectBorders");
        List<MarkdownTableRow> list2 = $this$hasCorrectBorders.getRows(true);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(true)");
        List<MarkdownTableRow> rows = list2;
        Iterable $this$all$iv = rows;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                MarkdownTableRow it = (MarkdownTableRow)element$iv;
                boolean bl2 = false;
                MarkdownTableRow markdownTableRow = it;
                Intrinsics.checkNotNullExpressionValue((Object)markdownTableRow, (String)"it");
                if (INSTANCE.hasCorrectBorders(markdownTableRow)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$hasCorrectBorders);
        if (markdownTableSeparatorRow == null) return false;
        if (!this.hasCorrectBorders(markdownTableSeparatorRow)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeCell(@NotNull MarkdownTableSeparatorRow $this$removeCell, int columnIndex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeCell, (String)"$this$removeCell");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$removeCell.getCellsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((int)it), (Object)$this$removeCell.getCellText((int)it));
            collection.add(pair);
        }
        List contents2 = (List)destination$iv$iv;
        String newContents2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)contents2), (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Boolean>(columnIndex){
            final /* synthetic */ int $columnIndex;

            public final boolean invoke(@NotNull Pair<Integer, String> $dstr$index$_u24__u24) {
                Intrinsics.checkNotNullParameter($dstr$index$_u24__u24, (String)"<name for destructuring parameter 0>");
                int index = ((Number)$dstr$index$_u24__u24.component1()).intValue();
                return index != this.$columnIndex;
            }
            {
                this.$columnIndex = n;
                super(1);
            }
        })), (Function1)removeCell.newContents.2.INSTANCE), (CharSequence)String.valueOf('|'), (CharSequence)String.valueOf('|'), (CharSequence)String.valueOf('|'), (int)0, null, null, (int)56, null);
        $this$removeCell.replaceWithText(newContents2);
    }

    public final void swapCells(@NotNull MarkdownTableSeparatorRow $this$swapCells, int leftIndex, int rightIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$swapCells, (String)"$this$swapCells");
        List contents2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)$this$swapCells.getCellsCount()))), (Function1)((Function1)new Function1<Integer, String>($this$swapCells){
            final /* synthetic */ MarkdownTableSeparatorRow $this_swapCells;

            @Nullable
            public final String invoke(int it) {
                return this.$this_swapCells.getCellText(it);
            }
            {
                this.$this_swapCells = markdownTableSeparatorRow;
                super(1);
            }
        })));
        ContainerUtil.swapElements((List)contents2, (int)leftIndex, (int)rightIndex);
        String newContents2 = CollectionsKt.joinToString$default((Iterable)contents2, (CharSequence)String.valueOf('|'), (CharSequence)String.valueOf('|'), (CharSequence)String.valueOf('|'), (int)0, null, null, (int)56, null);
        $this$swapCells.replaceWithText(newContents2);
    }

    public final void removeColumn(@NotNull MarkdownTable $this$removeColumn, int columnIndex) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$removeColumn, (String)"$this$removeColumn");
            List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$removeColumn, columnIndex, true);
            for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
                PsiElement parent = cell.getParent();
                if (columnIndex == 0) {
                    PsiElement psiElement = cell.getPrevSibling();
                    if (psiElement != null) {
                        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
                        if (PsiUtilsKt.hasType(psiElement, iElementType)) {
                            parent.deleteChildRange(cell.getPrevSibling(), (PsiElement)cell);
                            continue;
                        }
                    }
                }
                PsiElement psiElement = cell.getNextSibling();
                if (psiElement != null) {
                    IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
                    if (PsiUtilsKt.hasType(psiElement, iElementType)) {
                        parent.deleteChildRange((PsiElement)cell, cell.getNextSibling());
                        continue;
                    }
                }
                cell.delete();
            }
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$removeColumn);
            if (markdownTableSeparatorRow == null) break block6;
            this.removeCell(markdownTableSeparatorRow, columnIndex);
        }
    }

    private TableModificationUtils() {
    }

    static {
        TableModificationUtils tableModificationUtils;
        INSTANCE = tableModificationUtils = new TableModificationUtils();
    }
}

