/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedLineIndentProvider;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedLineIndentProvider;", "()V", "doGetLineIndent", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "offset", "", "getLineIndent", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "isSuitableFor", "", "intellij.markdown.core"})
public final class MarkdownListIndentProvider
extends FormatterBasedLineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor2, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
            return null;
        }
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor2);
        if (!(psiFile instanceof MarkdownFile)) {
            psiFile = null;
        }
        MarkdownFile markdownFile = (MarkdownFile)psiFile;
        if (markdownFile == null) {
            return null;
        }
        MarkdownFile file = markdownFile;
        String string = this.doGetLineIndent(editor2, file, offset);
        if (string == null) {
            string = super.getLineIndent(project, editor2, language, offset);
        }
        return string;
    }

    private final String doGetLineIndent(Editor editor2, MarkdownFile file, int offset) {
        MarkdownBlockQuote blockQuote;
        MarkdownBlockQuote markdownBlockQuote;
        if (Intrinsics.areEqual((Object)((Boolean)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY)), (Object)true)) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int prevLine = document2.getLineNumber(offset) - 1;
        MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAtLineSafely(file, prevLine, document2);
        if (markdownListItem == null) {
            markdownListItem = ListUtils.INSTANCE.getListItemAtLineSafely(file, prevLine - 1, document2);
        }
        if (markdownListItem == null) {
            return null;
        }
        MarkdownListItem listItem = markdownListItem;
        PsiElement psiElement = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling((PsiFile)file, offset);
        if (psiElement != null) {
            PsiElement $this$parentOfType$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            markdownBlockQuote = (MarkdownBlockQuote)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownBlockQuote.class, (boolean)true);
        } else {
            markdownBlockQuote = blockQuote = null;
        }
        if (blockQuote != null && PsiTreeUtilKt.isAncestor$default((PsiElement)((PsiElement)listItem), (PsiElement)((PsiElement)blockQuote), (boolean)false, (int)2, null)) {
            return null;
        }
        return "";
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof MarkdownLanguage;
    }
}

