/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.headers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.headers.HeaderLevelInferenceTypedHandler$Companion$findPreviousHeader$;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "char", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Companion", "intellij.markdown.core"})
public final class HeaderLevelInferenceTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (!Registry.is((String)"markdown.experimental.header.level.inference.enable")) {
            TypedHandlerDelegate.Result result2 = super.beforeCharTyped(c, project, editor2, file, fileType);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"super.beforeCharTyped(ch\u2026, editor, file, fileType)");
            return result2;
        }
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) ^ true || !(file instanceof MarkdownFile) || c != '#') {
            TypedHandlerDelegate.Result result3 = super.beforeCharTyped(c, project, editor2, file, fileType);
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"super.beforeCharTyped(ch\u2026, editor, file, fileType)");
            return result3;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        if (HeaderLevelInferenceTypedHandler.Companion.shouldIgnore((MarkdownFile)file, editor2)) {
            TypedHandlerDelegate.Result result4 = super.beforeCharTyped(c, project, editor2, file, fileType);
            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"super.beforeCharTyped(ch\u2026, editor, file, fileType)");
            return result4;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int caretOffset = caretModel.getOffset();
        MarkdownHeader markdownHeader = HeaderLevelInferenceTypedHandler.Companion.findPreviousHeader((MarkdownFile)file, document2, caretOffset);
        int level = markdownHeader != null ? markdownHeader.getLevel() : 1;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = level;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$buildString.append('#');
        }
        $this$buildString.append(' ');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String header = string;
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project, new Runnable(editor2, header){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ String $header$inlined;
            {
                this.$editor$inlined = editor2;
                this.$header$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)this.$header$inlined);
            }
        }, name$iv, (Object)groupId$iv);
        return TypedHandlerDelegate.Result.STOP;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J#\u0010\u0018\u001a\u0004\u0018\u00010\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler$Companion;", "", "()V", "findListItemForOffset", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "offset", "", "document", "Lcom/intellij/openapi/editor/Document;", "findPossibleListItemForOffset", "findPreviousHeader", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "findStartElement", "Lcom/intellij/psi/PsiElement;", "isValidLinePrefix", "", "prefix", "", "obtainLinePrefix", "shouldIgnore", "editor", "Lcom/intellij/openapi/editor/Editor;", "obtainContentStartOffset", "line", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "walkTreeUp", "Lkotlin/sequences/Sequence;", "withSelf", "intellij.markdown.core"})
    public static final class Companion {
        private final boolean shouldIgnore(MarkdownFile file, Editor editor2) {
            int currentLine;
            Integer itemContentStartOffset;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int offset = caretModel.getOffset();
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            MarkdownListItem listItem = this.findListItemForOffset(file, offset, document2);
            if (listItem != null && (itemContentStartOffset = this.obtainContentStartOffset(listItem, document2, currentLine = document2.getLineNumber(offset))) != null && itemContentStartOffset <= offset) {
                CharSequence prefix = document2.getCharsSequence().subSequence(itemContentStartOffset, offset);
                return !this.isValidLinePrefix(file, prefix);
            }
            CharSequence prefix = this.obtainLinePrefix(document2, offset);
            return !this.isValidLinePrefix(file, prefix);
        }

        private final Integer obtainContentStartOffset(MarkdownListItem $this$obtainContentStartOffset, Document document, int line) {
            PsiElement psiElement = $this$obtainContentStartOffset.getMarkerElement();
            if (psiElement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"markerElement ?: return null");
            PsiElement marker2 = psiElement;
            int markerEndOffset = UtilsKt.getEndOffset((PsiElement)marker2);
            int markerLineStartOffset = DocumentUtil.getLineStartOffset((int)markerEndOffset, (Document)document);
            int contentOffsetInsideLine = markerEndOffset - markerLineStartOffset;
            int lineStartOffset = document.getLineStartOffset(line);
            return lineStartOffset + contentOffsetInsideLine;
        }

        private final boolean isValidLinePrefix(MarkdownFile file, CharSequence prefix) {
            CharSequence charSequence = prefix;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            CodeStyleSettingsFacade codeStyleSettingsFacade = CodeStyle.getFacade((PsiFile)((PsiFile)file));
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsFacade, (String)"CodeStyle.getFacade(file)");
            int tabSize = codeStyleSettingsFacade.getTabSize();
            String tabReplacement = StringsKt.repeat((CharSequence)" ", (int)tabSize);
            String actualPrefix = StringsKt.replace$default((String)((Object)prefix).toString(), (String)"\t", (String)tabReplacement, (boolean)false, (int)4, null);
            return actualPrefix.length() < 4;
        }

        private final CharSequence obtainLinePrefix(Document document, int offset) {
            int lineStart = DocumentUtil.getLineStartOffset((int)offset, (Document)document);
            return document.getCharsSequence().subSequence(lineStart, offset);
        }

        private final Sequence<PsiElement> walkTreeUp(PsiElement $this$walkTreeUp, boolean withSelf) {
            return SequencesKt.flatMap((Sequence)PsiTreeUtilKt.parents((PsiElement)$this$walkTreeUp, (boolean)true), (Function1)((Function1)new Function1<PsiElement, Sequence<? extends PsiElement>>(withSelf){
                final /* synthetic */ boolean $withSelf;

                @NotNull
                public final Sequence<PsiElement> invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return PsiTreeUtilKt.siblings((PsiElement)it, (boolean)false, (boolean)this.$withSelf);
                }
                {
                    this.$withSelf = bl;
                    super(1);
                }
            }));
        }

        private final MarkdownHeader findPreviousHeader(MarkdownFile file, Document document, int offset) {
            Sequence<PsiElement> elements2;
            PsiElement startElement = this.findStartElement(file, document, offset);
            Sequence<PsiElement> $this$filterIsInstance$iv = elements2 = this.walkTreeUp(startElement, true);
            boolean $i$f$filterIsInstance = false;
            return (MarkdownHeader)SequencesKt.firstOrNull((Sequence)SequencesKt.filter($this$filterIsInstance$iv, (Function1)Companion$findPreviousHeader$$inlined$filterIsInstance$1.INSTANCE));
        }

        private final PsiElement findStartElement(MarkdownFile file, Document document, int offset) {
            MarkdownListItem markdownListItem = this.findListItemForOffset(file, offset, document);
            Object listItemBefore = markdownListItem != null ? markdownListItem.getLastChild() : null;
            PsiElement psiElement = listItemBefore;
            if (psiElement == null) {
                PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)((PsiFile)file), (int)offset);
                psiElement = psiElement2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
            }
            return psiElement;
        }

        private final MarkdownListItem findListItemForOffset(MarkdownFile file, int offset, Document document) {
            MarkdownListItem markdownListItem = this.findPossibleListItemForOffset(file, offset, document);
            if (markdownListItem == null) {
                return null;
            }
            MarkdownListItem item = markdownListItem;
            int itemLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item)));
            String string = ListUtils.INSTANCE.getLineIndentSpaces(document, itemLine, (PsiFile)file);
            if (string == null) {
                return null;
            }
            String itemIndent = string;
            int line = document.getLineNumber(offset);
            String string2 = ListUtils.INSTANCE.getLineIndentSpaces(document, line, (PsiFile)file);
            if (string2 == null) {
                return null;
            }
            String currentIndent = string2;
            if (StringsKt.startsWith$default((String)currentIndent, (String)itemIndent, (boolean)false, (int)2, null)) {
                return item;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final MarkdownListItem findPossibleListItemForOffset(MarkdownFile file, int offset, Document document) {
            int minPossibleStartLine;
            int n;
            int currentLine = document.getLineNumber(offset);
            int n2 = currentLine;
            if (n2 >= (n = (minPossibleStartLine = RangesKt.coerceAtLeast((int)(currentLine - 2), (int)0)))) {
                while (true) {
                    void line;
                    int searchOffset;
                    MarkdownListItem listItem;
                    if ((listItem = ListUtils.INSTANCE.getListItemAt(file, searchOffset = document.getLineEndOffset((int)line), document)) != null) {
                        return listItem;
                    }
                    if (line == n) break;
                    --line;
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

