/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.target.PyInterpreterVersionUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import icons.PythonIcons;
import java.awt.Component;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    @NotNull
    @ApiStatus.Internal
    public static final Key<List<String>> MOCK_SYS_PATH_KEY = Key.create((String)"PY_MOCK_SYS_PATH_KEY");
    @NotNull
    @ApiStatus.Internal
    public static final Key<String> MOCK_PY_VERSION_KEY = Key.create((String)"PY_MOCK_PY_VERSION_KEY");
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final int MINUTE = 60000;
    @NonNls
    private static final String SKELETONS_TOPIC = "Skeletons";
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    private static final Pattern CUSTOM_PYTHON_SDK_HOME_PATH_PATTERN = Pattern.compile("^([-a-zA-Z_0-9]{2,}:|\\\\\\\\wsl).+");
    @NotNull
    private static final String LEGACY_TARGET_PREFIX = "target://";

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.python";
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(0);
        }
        String string = PySdkUtil.getBuiltinsFileName(sdk);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Sdk[] existingSdks2 = (Sdk[])ReadAction.compute(() -> ProjectJdkTable.getInstance().getAllJdks());
        List<PyDetectedSdk> sdks = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(existingSdks2));
        PyDetectedSdk latest = StreamEx.of(sdks).findFirst().orElse(null);
        if (latest != null) {
            Set<String> set = Collections.singleton(latest.getHomePath());
            if (set == null) {
                PythonSdkType.$$$reportNull$$$0(2);
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isValidSdkHome(@NotNull String path2) {
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        return PythonSdkFlavor.getFlavor(path2) != null;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        final boolean isWindows = SystemInfo.isWindows;
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !PythonSdkType.this.isValidSdkHome(files[0].getPath())) {
                    throw new Exception(PyBundle.message("python.sdk.error.invalid.interpreter.name", files[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && isWindows) {
                    String path2 = file.getPath();
                    boolean looksExecutable = false;
                    for (String ext : PythonSdkUtil.WINDOWS_EXECUTABLE_SUFFIXES) {
                        if (!path2.endsWith(ext)) continue;
                        looksExecutable = true;
                        break;
                    }
                    return looksExecutable && super.isFileVisible(file, showHiddenFiles);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (SystemInfo.isMac) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        FileChooserDescriptor fileChooserDescriptor = descriptor2;
        if (fileChooserDescriptor == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        return fileChooserDescriptor;
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(6);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, Arrays.asList(sdkModel.getSdks()), sdk -> {
            if (sdk != null) {
                sdk.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk);
            }
        });
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkUtil.isVirtualEnv(sdk)) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            String version = this.getVersionString(sdk);
            if (flavor != null && version != null) {
                for (Sdk baseSdk : PythonSdkUtil.getAllSdks()) {
                    if (PythonSdkUtil.isRemote(baseSdk)) continue;
                    PythonSdkFlavor baseFlavor = PythonSdkFlavor.getFlavor(baseSdk);
                    if (PythonSdkUtil.isVirtualEnv(baseSdk) || !flavor.equals(baseFlavor) || !version.equals(this.getVersionString(baseSdk))) continue;
                    return baseSdk;
                }
            }
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk) {
        if (commandLine == null) {
            PythonSdkType.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        PythonSdkType.patchEnvironmentVariablesForVirtualenv(commandLine.getEnvironment(), sdk);
    }

    public static void patchEnvironmentVariablesForVirtualenv(@NotNull Map<String, String> environment, @NotNull Sdk sdk) {
        Map<String, String> virtualEnv;
        if (environment == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        if (!(virtualEnv = PySdkUtil.activateVirtualEnv(sdk)).isEmpty()) {
            for (Map.Entry<String, String> entry : virtualEnv.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (environment.containsKey(key)) {
                    if (!key.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar(environment.get(key), value, false);
                    continue;
                }
                environment.put(key, value);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(13);
        }
        String name2 = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkUtil.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String path2 = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            String string = name2 + " virtualenv at " + path2;
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + flavor.getLanguageLevel(sdkHome);
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(17);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(20);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        WSLUtil.fixWslPrefix((Sdk)currentSdk);
        String homePath2 = currentSdk.getHomePath();
        if (homePath2 != null) {
            PythonRemoteInterpreterManager manager;
            PyTargetAwareAdditionalData targetAdditionalData;
            if (homePath2.startsWith(LEGACY_TARGET_PREFIX)) {
                ((SdkModificator)currentSdk).setHomePath(homePath2.substring(LEGACY_TARGET_PREFIX.length()));
            }
            if ((targetAdditionalData = PyTargetAwareAdditionalData.loadTargetAwareData(currentSdk, additional)) != null) {
                return targetAdditionalData;
            }
            if (PythonSdkType.isCustomPythonSdkHomePath(homePath2) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
                return manager.loadRemoteSdkData(currentSdk, additional);
            }
        }
        return PySdkProvider.EP_NAME.extensions().map(ext -> ext.loadAdditionalDataForSdk(additional)).filter(data -> data != null).findFirst().orElseGet(() -> PythonSdkAdditionalData.load(currentSdk, additional));
    }

    @Contract(pure=true)
    static boolean isCustomPythonSdkHomePath(@NotNull String homePath2) {
        if (homePath2 == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        return CUSTOM_PYTHON_SDK_HOME_PATH_PATTERN.matcher(homePath2).matches();
    }

    public static boolean isSkeletonsPath(String path2) {
        return path2.contains("python_stubs");
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath2) {
        VirtualFile sdkPath;
        String path2;
        PythonSdkFlavor flavor;
        if (homePath2 == null) {
            PythonSdkType.$$$reportNull$$$0(24);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(path2 = super.sdkPath(homePath2))) != null && (sdkPath = flavor.getSdkPath(homePath2)) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkPath.getPath());
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)path2);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        if (PlatformUtils.isFleetBackend()) {
            return;
        }
        WeakReference ownerComponentRef = (WeakReference)sdk.getUserData(SDK_CREATOR_COMPONENT_KEY);
        Component ownerComponent = (Component)SoftReference.dereference((Reference)ownerComponentRef);
        AtomicReference projectRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (ownerComponent != null) {
                projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)));
            } else {
                projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()));
            }
        });
        PythonSdkUpdater.updateOrShowError(sdk, (Project)projectRef.get(), ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(28);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (e.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, event) -> {
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        VagrantNotStartedException cause = (VagrantNotStartedException)e.getCause();
                        manager.runVagrant(cause.getVagrantFolder(), cause.getMachineName());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = new HtmlBuilder().append(e.getMessage()).appendLink("#", PyBundle.message("python.vagrant.refresh.skeletons", new Object[0])).toString();
        } else if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notification notification3 = new Notification(SKELETONS_TOPIC, PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), notificationMessage, NotificationType.WARNING);
        if (notificationListener != null) {
            notification3.setListener(notificationListener);
        }
        notification3.notify(null);
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path2) {
        VirtualFile jar;
        String suffix;
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(30);
        }
        if ((suffix = path2.getExtension()) != null) {
            suffix = StringUtil.toLowerCase((String)suffix);
        }
        if (!path2.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path2)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(31);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path2;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(32);
        }
        return virtualFile;
    }

    @NotNull
    public static List<String> getSysPath(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        String working_dir = new File(sdk.getHomePath()).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && (!application.isUnitTestMode() || ApplicationManagerEx.isInStressTest())) {
            return PythonSdkType.getSysPathsFromScript(sdk);
        }
        List<String> data = (List<String>)sdk.getUserData(MOCK_SYS_PATH_KEY);
        List<String> list = data != null ? data : Collections.singletonList(working_dir);
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull Sdk sdk) throws InvalidSdkException {
        String binaryPath;
        GeneralCommandLine cmd;
        ProcessOutput runResult;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(35);
        }
        if (!(runResult = PySdkUtil.getProcessOutput(cmd = PythonHelper.SYSPATH.newCommandLine(binaryPath = sdk.getHomePath(), new ArrayList<String>()), new File(binaryPath).getParent(), PySdkUtil.activateVirtualEnv(sdk), 60000)).checkSuccess(LOG)) {
            throw new InvalidSdkException(PySdkBundle.message("python.sdk.failed.to.determine.sys.path", runResult.getStdout(), runResult.getStderr()));
        }
        List list = runResult.getStdoutLines();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        String version;
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof PyTargetAwareAdditionalData) {
            String versionString;
            try {
                versionString = PyInterpreterVersionUtil.getInterpreterVersion((PyTargetAwareAdditionalData)sdkAdditionalData, null, true);
            }
            catch (Exception e) {
                versionString = "undefined";
            }
            return versionString;
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
            assert (data != null);
            String versionString = data.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                try {
                    versionString = PyRemoteInterpreterUtil.getInterpreterVersion(null, data, true);
                }
                catch (Exception e) {
                    LOG.warn("Couldn't get interpreter version:" + e.getMessage(), (Throwable)e);
                    versionString = "undefined";
                }
                data.setVersionString(versionString);
            }
            return versionString;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (version = (String)sdk.getUserData(MOCK_PY_VERSION_KEY)) != null) {
            return version;
        }
        String homePath2 = sdk.getHomePath();
        return homePath2 == null ? null : this.getVersionString(homePath2);
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? flavor.getVersionString(sdkHome) : null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            PythonSdkType.$$$reportNull$$$0(38);
        }
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isIncompleteRemote(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        return sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        return (data = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase && ((PyRemoteSdkAdditionalDataBase)data).isRunAsRootViaSudo();
    }

    public static boolean hasInvalidRemoteCredentials(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        if (sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            final Ref result = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    result.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase[0]));
            return (Boolean)result.get();
        }
        return false;
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        String string = sdk.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        return !PythonSdkUtil.isRemote(sdk);
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk(module);
        if (moduleSDK != null && !PythonSdkUtil.isRemote(moduleSDK) && PythonSdkFlavor.getFlavor(moduleSDK) instanceof CPythonSdkFlavor) {
            return moduleSDK;
        }
        for (Sdk sdk : ContainerUtil.sorted(PythonSdkUtil.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkUtil.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(46);
        }
        return languageLevel;
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk(module);
        if (moduleSDK != null && PythonSdkType.getLanguageLevelForSdk(moduleSDK).isPython2()) {
            return moduleSDK;
        }
        return PythonSdkType.findPython2Sdk(PythonSdkUtil.getAllSdks());
    }

    @Nullable
    public static Sdk findPython2Sdk(@NotNull List<? extends Sdk> sdks) {
        if (sdks == null) {
            PythonSdkType.$$$reportNull$$$0(47);
        }
        for (Sdk sdk : ContainerUtil.sorted(sdks, (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (!PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) continue;
            return sdk;
        }
        return null;
    }

    public boolean allowWslSdkForLocalProject() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPathsFromScript";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchEnvironmentVariablesForVirtualenv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPythonSdkHomePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSysPath";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSysPathsFromScript";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteRemote";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidRemoteCredentials";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findPython2Sdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

