/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallCollector;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.PySdkToInstallViaXCodeSelect;
import com.jetbrains.python.sdk.flavors.MacPythonSdkFlavor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0017J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallViaXCodeSelect;", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "()V", "getInstallationWarning", "", "defaultButtonName", "install", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "module", "Lcom/intellij/openapi/module/Module;", "systemWideSdksDetector", "Lkotlin/Function0;", "", "isInstallCommandLineDeveloperToolsAppRunning", "", "renderInList", "", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "runXCodeSelectInstall", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.community.impl"})
final class PySdkToInstallViaXCodeSelect
extends PySdkToInstall {
    @Override
    public void renderInList(@NotNull SimpleColoredComponent renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(this.getName());
        renderer.append(" ");
        renderer.append(PyBundle.message("python.cldt.installing.suggestion", new Object[0]), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    @Override
    @NlsContexts.DialogMessage
    @NotNull
    public String getInstallationWarning(@NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        GeneralCommandLine generalCommandLine = MacPythonSdkFlavor.getXCodeSelectInstallCommand();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"MacPythonSdkFlavor.getXCodeSelectInstallCommand()");
        HtmlChunk htmlChunk = HtmlChunk.text((String)generalCommandLine.getCommandLineString());
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(MacPythonSdkFlavor.\u2026mand().commandLineString)");
        HtmlChunk commandChunk = htmlChunk;
        String string = new HtmlBuilder().append(PyBundle.message("python.sdk.executable.not.found.header", new Object[0])).append((HtmlChunk)HtmlChunk.tag((String)"ul").children(new HtmlChunk[]{(HtmlChunk)HtmlChunk.tag((String)"li").children(new HtmlChunk[]{HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.specify.path", HtmlChunk.text((String)"...").bold(), "python"))}), (HtmlChunk)HtmlChunk.tag((String)"li").children(new HtmlChunk[]{HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.install.with.cldt", HtmlChunk.text((String)defaultButtonName).bold(), commandChunk.code()))}), (HtmlChunk)HtmlChunk.tag((String)"li").children(new HtmlChunk[]{HtmlChunk.text((String)PyBundle.message("python.sdk.executable.not.found.option.install.or.brew", new Object[0]))})})).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder()\n      .app\u2026w\")))\n      )).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PyDetectedSdk install(@Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        void it;
        Task.WithResult<PyDetectedSdk, Exception> withResult;
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        Module module2 = module;
        Project project = module2 != null ? module2.getProject() : null;
        Task.WithResult<PyDetectedSdk, Exception> withResult2 = withResult = new Task.WithResult<PyDetectedSdk, Exception>(this, project, systemWideSdksDetector, project, PyBundle.message("python.cldt.installing.title", new Object[0]), true){
            final /* synthetic */ PySdkToInstallViaXCodeSelect this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0 $systemWideSdksDetector;

            @Nullable
            protected PyDetectedSdk compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(PyBundle.message("python.cldt.installing.indicator", new Object[0]));
                indicator.setText2(PyBundle.message("python.cldt.installing.skip", new Object[0]));
                PySdkToInstallViaXCodeSelect.access$runXCodeSelectInstall(this.this$0, this.$project);
                while (!MacPythonSdkFlavor.areCommandLineDeveloperToolsAvailable() && PySdkToInstallViaXCodeSelect.access$isInstallCommandLineDeveloperToolsAppRunning(this.this$0)) {
                    if (indicator.isCanceled()) {
                        PySdkToInstallCollector.Companion.logSdkInstallationOnMac$intellij_python_community_impl(this.$project, PySdkToInstallCollector.Companion.InstallationResult.CANCELLED);
                        return null;
                    }
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
                PySdkToInstallCollector.Companion.logSdkInstallationOnMac$intellij_python_community_impl(this.$project, MacPythonSdkFlavor.areCommandLineDeveloperToolsAvailable() ? PySdkToInstallCollector.Companion.InstallationResult.OK : PySdkToInstallCollector.Companion.InstallationResult.EXIT_CODE);
                PySdkToInstallKt.access$getLOGGER$p().debug("Resetting system-wide sdks detectors");
                PySdkExtKt.resetSystemWideSdksDetectors();
                Object object = this.$systemWideSdksDetector.invoke();
                List sdks = (List)object;
                boolean bl = false;
                Logger $this$debug$iv = PySdkToInstallKt.access$getLOGGER$p();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl2 = false;
                    String string = CollectionsKt.joinToString$default((Iterable)sdks, null, (CharSequence)"Detected system-wide sdks: ", null, (int)0, null, (Function1)install.compute.1.1.1.INSTANCE, (int)29, null);
                    logger.debug(string, (Throwable)e$iv);
                }
                List it = (List)object;
                boolean bl3 = false;
                PySdkToInstallCollector.Companion.logSdkLookupOnMac$intellij_python_community_impl(this.$project, it.isEmpty() ? PySdkToInstallCollector.Companion.LookupResult.NOT_FOUND : PySdkToInstallCollector.Companion.LookupResult.FOUND);
                return (PyDetectedSdk)((Object)CollectionsKt.singleOrNull((List)((List)object)));
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$systemWideSdksDetector = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        boolean bl = false;
        it.setCancelText(IdeBundle.message((String)"button.skip", (Object[])new Object[0]));
        it.setCancelTooltipText(IdeBundle.message((String)"button.skip", (Object[])new Object[0]));
        Unit unit = Unit.INSTANCE;
        return (PyDetectedSdk)((Object)progressManager.run((Task.WithResult)withResult));
    }

    private final void runXCodeSelectInstall(Project project) {
        GeneralCommandLine generalCommandLine = MacPythonSdkFlavor.getXCodeSelectInstallCommand();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"MacPythonSdkFlavor.getXCodeSelectInstallCommand()");
        GeneralCommandLine commandLine = generalCommandLine;
        try {
            ProcessOutput processOutput;
            ProcessOutput it = processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            boolean bl = false;
            if (PySdkToInstallKt.access$getLOGGER$p().isDebugEnabled()) {
                PySdkToInstallKt.access$getLOGGER$p().debug("Result of '" + commandLine.getCommandLineString() + "':\n" + it);
            }
        }
        catch (ExecutionException e) {
            PySdkToInstallCollector.Companion.logSdkInstallationOnMac$intellij_python_community_impl(project, PySdkToInstallCollector.Companion.InstallationResult.EXCEPTION);
            PySdkToInstallKt.access$getLOGGER$p().warn("Exception during '" + commandLine.getCommandLineString() + "'", (Throwable)e);
        }
    }

    private final boolean isInstallCommandLineDeveloperToolsAppRunning() {
        boolean bl;
        boolean bl2;
        String appName;
        block2: {
            appName = "Install Command Line Developer Tools.app";
            ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
            Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"OSProcessUtil\n      .getProcessList()");
            ProcessInfo[] $this$any$iv = processInfoArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ProcessInfo element$iv;
                ProcessInfo it = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                ProcessInfo processInfo = it;
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it");
                String string = processInfo.getCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.commandLine");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)appName, (boolean)false, (int)2, null)) continue;
                bl2 = true;
                break block2;
            }
            bl2 = false;
        }
        boolean it = bl = bl2;
        boolean bl4 = false;
        if (PySdkToInstallKt.access$getLOGGER$p().isDebugEnabled()) {
            PySdkToInstallKt.access$getLOGGER$p().debug("'" + appName + "' is" + (it ? "" : " not") + " running");
        }
        return bl;
    }

    public PySdkToInstallViaXCodeSelect() {
        super("Python", "");
    }

    public static final /* synthetic */ void access$runXCodeSelectInstall(PySdkToInstallViaXCodeSelect $this, Project project) {
        $this.runXCodeSelectInstall(project);
    }

    public static final /* synthetic */ boolean access$isInstallCommandLineDeveloperToolsAppRunning(PySdkToInstallViaXCodeSelect $this) {
        return $this.isInstallCommandLineDeveloperToolsAppRunning();
    }
}

