/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.run.PyRemoteProcessStarterManagerUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteInterpreterUtil {
    @Nullable
    public static String getInterpreterVersion(@Nullable Project project, final @NotNull PyRemoteSdkAdditionalDataBase data, final boolean nullForUnparsableVersion) throws RemoteSdkException {
        if (data == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(0);
        }
        final Ref result = Ref.create(null);
        final Ref exception = Ref.create(null);
        Task.Modal task2 = new Task.Modal(project, PyBundle.message("python.sdk.getting.remote.interpreter.version", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                PythonSdkFlavor flavor;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((flavor = data.getFlavor()) != null) {
                    try {
                        try {
                            String version;
                            String[] command = new String[]{data.getInterpreterPath(), flavor.getVersionOption()};
                            ProcessOutput processOutput = PyRemoteProcessStarterManagerUtil.getManager(data).executeRemoteProcess(this.myProject, command, null, data, new PyRemotePathMapper());
                            if (processOutput.getExitCode() == 0 && ((version = flavor.getVersionStringFromOutput(processOutput)) != null || nullForUnparsableVersion)) {
                                result.set((Object)version);
                                return;
                            }
                            exception.set((Object)PyRemoteInterpreterUtil.createException(processOutput, command));
                        }
                        catch (Exception e) {
                            throw RemoteSdkException.cantObtainRemoteCredentials((Throwable)e);
                        }
                    }
                    catch (RemoteSdkException e) {
                        exception.set((Object)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/remote/PyRemoteInterpreterUtil$1", "run"));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task2));
        } else {
            task2.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!exception.isNull()) {
            throw (RemoteSdkException)((Object)exception.get());
        }
        return (String)result.get();
    }

    @NotNull
    private static RemoteSdkException createException(@NotNull ProcessOutput processOutput, String @NotNull [] command) {
        if (processOutput == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(1);
        }
        if (command == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(2);
        }
        RemoteSdkException remoteSdkException = RemoteSdkException.cantObtainRemoteCredentials((Throwable)((Object)new PyExecutionException(PyBundle.message("python.sdk.can.t.obtain.python.version", new Object[0]), command[0], Lists.newArrayList((Object[])command), processOutput)));
        if (remoteSdkException == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(3);
        }
        return remoteSdkException;
    }

    public static void closeOnProcessTermination(@NotNull ProcessHandler processHandler, final @NotNull Closeable closeable) {
        if (processHandler == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(4);
        }
        if (closeable == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(5);
        }
        processHandler.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteInterpreterUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createException";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "closeOnProcessTermination";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

