/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.Multimap;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyCondaManagementService
extends PyPackageManagementService {
    private static final Logger LOG = Logger.getInstance(PyCondaManagementService.class);

    public PyCondaManagementService(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyCondaManagementService.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyCondaManagementService.$$$reportNull$$$0(1);
        }
        super(project, sdk);
    }

    private boolean useConda() {
        return PyPackageManager.getInstance(this.mySdk) instanceof PyCondaPackageManagerImpl && ((PyCondaPackageManagerImpl)PyPackageManager.getInstance(this.mySdk)).useConda();
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        if (this.useConda()) {
            List<RepoPackage> list = Collections.emptyList();
            if (list == null) {
                PyCondaManagementService.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<RepoPackage> list = super.getAllPackagesCached();
        if (list == null) {
            PyCondaManagementService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        if (this.useConda()) {
            List<RepoPackage> list = this.reloadAllPackages();
            if (list == null) {
                PyCondaManagementService.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<RepoPackage> list = super.getAllPackages();
        if (list == null) {
            PyCondaManagementService.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        if (this.useConda()) {
            Multimap<String, String> packages = PyCondaPackageService.listAllPackagesAndVersions();
            if (packages == null) {
                List<RepoPackage> list = Collections.emptyList();
                if (list == null) {
                    PyCondaManagementService.$$$reportNull$$$0(6);
                }
                return list;
            }
            ArrayList<RepoPackage> results = new ArrayList<RepoPackage>();
            for (String pkg : packages.keySet()) {
                results.add(new RepoPackage(pkg, null, (String)ContainerUtil.getFirstItem((Collection)packages.get((Object)pkg))));
            }
            ArrayList<RepoPackage> arrayList = results;
            if (arrayList == null) {
                PyCondaManagementService.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List<RepoPackage> list = super.reloadAllPackages();
        if (list == null) {
            PyCondaManagementService.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void fetchAllRepositories(@NotNull CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        if (consumer == null) {
            PyCondaManagementService.$$$reportNull$$$0(9);
        }
        if (this.useConda()) {
            this.myExecutorService.execute(() -> {
                try {
                    List channels = ContainerUtil.notNullize(PyCondaPackageService.listChannels());
                    consumer.consume((Object)channels);
                }
                catch (ExecutionException e) {
                    consumer.consume((Throwable)e);
                }
            });
        } else {
            super.fetchAllRepositories(consumer);
        }
    }

    @Override
    public void addRepository(final String repositoryUrl) {
        if (this.useConda()) {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), PyBundle.message("python.packaging.adding.conda.channel", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    try {
                        PyCondaRunKt.runConda(PyCondaManagementService.this.mySdk, Arrays.asList("config", "--add", "channels", repositoryUrl, "--force"));
                    }
                    catch (ExecutionException e) {
                        LOG.warn("Failed to add repository. " + e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/ui/PyCondaManagementService$1", "run"));
                }
            });
        } else {
            super.addRepository(repositoryUrl);
        }
    }

    @Override
    public void removeRepository(final String repositoryUrl) {
        if (this.useConda()) {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), PyBundle.message("python.packaging.removing.conda.channel", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    try {
                        PyCondaRunKt.runConda(PyCondaManagementService.this.mySdk, Arrays.asList("config", "--remove", "channels", repositoryUrl, "--force"));
                    }
                    catch (ExecutionException e) {
                        LOG.warn("Failed to remove repository. " + e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/ui/PyCondaManagementService$2", "run"));
                }
            });
        } else {
            super.removeRepository(repositoryUrl);
        }
    }

    @Override
    public boolean canInstallToUser() {
        return !this.useConda() && super.canInstallToUser();
    }

    @Override
    public void fetchPackageVersions(String packageName, CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        if (this.useConda()) {
            this.myExecutorService.execute(() -> {
                try {
                    consumer.consume(PyCondaPackageService.listPackageVersions(packageName));
                }
                catch (ExecutionException e) {
                    consumer.consume((Throwable)e);
                }
            });
        } else {
            super.fetchPackageVersions(packageName, consumer);
        }
    }

    @Override
    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<? super String, ? super Exception> consumer) {
        if (pkg == null) {
            PyCondaManagementService.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            PyCondaManagementService.$$$reportNull$$$0(11);
        }
        String packageName = pkg.getName();
        if (this.useConda()) {
            this.myExecutorService.execute(() -> {
                try {
                    String latestVersion = (String)ContainerUtil.getFirstItem(PyCondaPackageService.listPackageVersions(packageName));
                    consumer.consume((Object)latestVersion);
                }
                catch (ExecutionException e) {
                    consumer.consume((Throwable)e);
                }
            });
        } else {
            super.fetchLatestVersion(pkg, consumer);
        }
    }

    @Override
    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyCondaManagementService";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyCondaManagementService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchAllRepositories";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

