/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.ift.PythonLessonsBundle;
import com.jetbrains.python.ift.PythonLessonsUtil;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.lang.LangSupport;
import training.util.LessonEndInfo;
import training.util.OnboardingFeedbackData;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\n\u0010\u0012\u001a\u00020\b*\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/ift/PythonLessonsUtil;", "", "()V", "isPython3Installed", "", "project", "Lcom/intellij/openapi/project/Project;", "prepareFeedbackDataForOnboardingLesson", "", "configPropertyName", "", "reportTitle", "feedbackReportId", "primaryLanguage", "Ltraining/lang/LangSupport;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "usedInterpreterAtStart", "showWarningIfPython3NotFound", "Ltraining/dsl/LessonContext;", "intellij.python.featuresTrainer"})
public final class PythonLessonsUtil {
    @NotNull
    public static final PythonLessonsUtil INSTANCE;

    public final boolean isPython3Installed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = PySdkExtKt.getPythonSdk(project);
        if (sdk == null) {
            return false;
        }
        Sdk sdk2 = sdk;
        Object object = PythonSdkFlavor.getFlavor(sdk2);
        return object != null && (object = ((PythonSdkFlavor)object).getLanguageLevel(sdk2)) != null && ((LanguageLevel)((Object)object)).isPy3K();
    }

    public final void showWarningIfPython3NotFound(@NotNull LessonContext $this$showWarningIfPython3NotFound) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarningIfPython3NotFound, (String)"$this$showWarningIfPython3NotFound");
        $this$showWarningIfPython3NotFound.task((Function1)showWarningIfPython3NotFound.1.INSTANCE);
    }

    public final void prepareFeedbackDataForOnboardingLesson(@NotNull Project project, @NotNull String configPropertyName, @NotNull String reportTitle, @NotNull String feedbackReportId, @Nullable LangSupport primaryLanguage, @NotNull LessonEndInfo lessonEndInfo, @NotNull String usedInterpreterAtStart) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configPropertyName, (String)"configPropertyName");
        Intrinsics.checkNotNullParameter((Object)reportTitle, (String)"reportTitle");
        Intrinsics.checkNotNullParameter((Object)feedbackReportId, (String)"feedbackReportId");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        Intrinsics.checkNotNullParameter((Object)usedInterpreterAtStart, (String)"usedInterpreterAtStart");
        if (primaryLanguage == null) {
            PythonLessonsUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PythonLessonsUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Onboarding lesson has no language support for some magical reason");
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean(configPropertyName, false)) {
            return;
        }
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        ProjectSdksModel projectSdksModel = pyConfigurableInterpreterList.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectSdksModel, (String)"PyConfigurableInterprete\u2026t.getInstance(null).model");
        Sdk[] sdkArray = projectSdksModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"PyConfigurableInterprete\u2026Instance(null).model.sdks");
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ProjectSpecificSettingsS\u2026thonSdks(allExistingSdks)");
        List<Sdk> existingSdks2 = list;
        CompletableFuture interpreterVersions = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(existingSdks2, interpreterVersions){
            final /* synthetic */ List $existingSdks;
            final /* synthetic */ CompletableFuture $interpreterVersions;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                UserDataHolderBase context2 = new UserDataHolderBase();
                List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(this.$existingSdks, null, (UserDataHolder)context2);
                Iterable iterable = baseSdks;
                CompletableFuture completableFuture = this.$interpreterVersions;
                boolean $i$f$mapNotNull = false;
                void var5_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Sdk it = (Sdk)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getSdkType().getVersionString(it) == null) continue;
                    String it$iv$iv = string;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                completableFuture.complete(CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)list)));
            }
            {
                this.$existingSdks = list;
                this.$interpreterVersions = completableFuture;
            }
        });
        Object object = PySdkExtKt.getPythonSdk(project);
        if (object == null || (object = object.getVersionString()) == null) {
            object = "none";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.pythonSdk?.versionString ?: \"none\"");
        Object usedInterpreter = object;
        String startInterpreter = Intrinsics.areEqual((Object)usedInterpreterAtStart, (Object)usedInterpreter) ? "same" : usedInterpreterAtStart;
        primaryLanguage.setOnboardingFeedbackData(new OnboardingFeedbackData(configPropertyName, feedbackReportId, interpreterVersions, (String)usedInterpreter, startInterpreter, reportTitle, lessonEndInfo, reportTitle, lessonEndInfo){
            @NotNull
            private final String feedbackReportId;
            private final int additionalFeedbackFormatVersion;
            @Nullable
            private final Lazy interpreters$delegate;
            @NotNull
            private final Function1<JsonObjectBuilder, Unit> addAdditionalSystemData;
            @NotNull
            private final Function1<Panel, Unit> addRowsForUserAgreement;
            final /* synthetic */ String $configPropertyName;
            final /* synthetic */ String $feedbackReportId;
            final /* synthetic */ CompletableFuture $interpreterVersions;
            final /* synthetic */ String $usedInterpreter;
            final /* synthetic */ String $startInterpreter;
            final /* synthetic */ String $reportTitle;
            final /* synthetic */ LessonEndInfo $lessonEndInfo;

            @NotNull
            public String getFeedbackReportId() {
                return this.feedbackReportId;
            }

            public int getAdditionalFeedbackFormatVersion() {
                return this.additionalFeedbackFormatVersion;
            }

            @Nullable
            public final List<String> getInterpreters() {
                Lazy lazy = this.interpreters$delegate;
                prepareFeedbackDataForOnboardingLesson.2 var2_2 = this;
                Object var3_3 = null;
                return (List)lazy.getValue();
            }

            @NotNull
            public Function1<JsonObjectBuilder, Unit> getAddAdditionalSystemData() {
                return this.addAdditionalSystemData;
            }

            @NotNull
            public Function1<Panel, Unit> getAddRowsForUserAgreement() {
                return this.addRowsForUserAgreement;
            }

            public void feedbackHasBeenProposed() {
                PropertiesComponent.getInstance().setValue(this.$configPropertyName, true, false);
            }
            {
                this.$configPropertyName = $captured_local_variable$0;
                this.$feedbackReportId = $captured_local_variable$1;
                this.$interpreterVersions = $captured_local_variable$2;
                this.$usedInterpreter = $captured_local_variable$3;
                this.$startInterpreter = $captured_local_variable$4;
                this.$reportTitle = $captured_local_variable$5;
                this.$lessonEndInfo = $captured_local_variable$6;
                super($super_call_param$7, $super_call_param$8);
                this.feedbackReportId = $captured_local_variable$1;
                this.additionalFeedbackFormatVersion = 1;
                this.interpreters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
                    final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;

                    @Nullable
                    public final List<String> invoke() {
                        return this.this$0.$interpreterVersions.isDone() ? (List)this.this$0.$interpreterVersions.get() : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.addAdditionalSystemData = (Function1)new Function1<JsonObjectBuilder, Unit>(this){
                    final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull JsonObjectBuilder $receiver) {
                        JsonArrayBuilder builder$iv;
                        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                        JsonElementBuildersKt.put((JsonObjectBuilder)$receiver, (String)"current_interpreter", (String)this.this$0.$usedInterpreter);
                        JsonElementBuildersKt.put((JsonObjectBuilder)$receiver, (String)"start_interpreter", (String)this.this$0.$startInterpreter);
                        boolean $i$f$buildJsonArray = false;
                        JsonArrayBuilder jsonArrayBuilder = builder$iv = new JsonArrayBuilder();
                        String string = "found_interpreters";
                        JsonObjectBuilder jsonObjectBuilder = $receiver;
                        boolean bl = false;
                        List list = this.this$0.getInterpreters();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        for (String i : list) {
                            void $this$buildJsonArray;
                            $this$buildJsonArray.add((JsonElement)JsonElementKt.JsonPrimitive((String)i));
                        }
                        Unit unit = Unit.INSTANCE;
                        jsonObjectBuilder.put(string, (JsonElement)builder$iv.build());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                this.addRowsForUserAgreement = (Function1)new Function1<Panel, Unit>(this){
                    final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;

                    public final void invoke(@NotNull Panel $receiver) {
                        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                        $receiver.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.found.interpreters", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ prepareFeedbackDataForOnboardingLesson.addRowsForUserAgreement.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                List<String> list = this.this$0.this$0.getInterpreters();
                                String interpreters2 = list != null ? list.toString() : null;
                                String string = interpreters2;
                                if (string == null) {
                                    string = PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.no.interpreters", new Object[0]);
                                }
                                $this$row.label(string);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        $receiver.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.used.interpreter", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ prepareFeedbackDataForOnboardingLesson.addRowsForUserAgreement.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                $this$row.label(this.this$0.this$0.$usedInterpreter);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        $receiver.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.start.interpreter", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ prepareFeedbackDataForOnboardingLesson.addRowsForUserAgreement.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                $this$row.label(this.this$0.this$0.$startInterpreter);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
            }
        });
    }

    private PythonLessonsUtil() {
    }

    static {
        PythonLessonsUtil pythonLessonsUtil;
        INSTANCE = pythonLessonsUtil = new PythonLessonsUtil();
    }
}

