/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStructuredDocstringFormatter {
    private static final Logger LOG = Logger.getInstance(PyStructuredDocstringFormatter.class);

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        Module module;
        if (element == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(1);
        }
        if ((module = DocStringUtil.getModuleForElement(element)) == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        String preparedDocstring = PyIndentUtil.removeCommonIndent(docstring, true).trim();
        DocStringFormat format = DocStringUtil.guessDocStringFormat(preparedDocstring, element);
        if (format == DocStringFormat.PLAIN) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList("Unittest placeholder");
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(format, preparedDocstring);
        String output = null;
        try {
            output = (String)ApplicationUtil.runWithCheckCanceled(() -> PythonRuntimeService.getInstance().formatDocstring(module, format, preparedDocstring), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (output != null) {
            result.add(output);
        } else {
            result.add(structuredDocString.getDescription());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "docstring";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/documentation/PyStructuredDocstringFormatter";
        objectArray[2] = "formatDocstring";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

