/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.util.io.URLUtil;
import com.jetbrains.python.debugger.PyDebuggerException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class ProtocolFrame {
    private final int myCommand;
    private final int mySequence;
    @NotNull
    private final String myPayload;

    public ProtocolFrame(int command, int sequence, @NotNull String payload) {
        if (payload == null) {
            ProtocolFrame.$$$reportNull$$$0(0);
        }
        this.myCommand = command;
        this.mySequence = sequence;
        this.myPayload = payload;
    }

    public ProtocolFrame(String frame) throws PyDebuggerException {
        String[] parts = frame.split("\t", 3);
        if (parts.length < 2) {
            throw new PyDebuggerException("Bad frame: " + frame);
        }
        this.myCommand = Integer.parseInt(parts[0]);
        this.mySequence = Integer.parseInt(parts[1]);
        this.myPayload = (parts.length == 3 && !parts[2].isEmpty() ? URLUtil.decode((String)parts[2]) : "").trim();
    }

    public int getCommand() {
        return this.myCommand;
    }

    public int getSequence() {
        return this.mySequence;
    }

    @NotNull
    public String getPayload() {
        String string = this.myPayload;
        if (string == null) {
            ProtocolFrame.$$$reportNull$$$0(1);
        }
        return string;
    }

    public byte @NotNull [] pack() {
        String s = String.valueOf(this.myCommand) + "\t" + this.mySequence + "\t" + this.myPayload + "\n";
        byte[] byArray = s.getBytes(StandardCharsets.UTF_8);
        if (byArray == null) {
            ProtocolFrame.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    public String toString() {
        return "[" + this.myCommand + ":" + this.mySequence + ":" + this.myPayload + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/ProtocolFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/ProtocolFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPayload";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

