/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.application.options.RegistryManager;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.ShowCommandQueueAction;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDebugLanguageConsoleView
extends DuplexConsoleView<ConsoleView, PythonConsoleView>
implements PyCodeExecutor {
    public static final String DEBUG_CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))";
    private boolean myDebugConsoleInitialized = false;
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

    public PythonDebugLanguageConsoleView(Project project, Sdk sdk, ConsoleView consoleView, boolean testMode) {
        super(consoleView, (ConsoleView)new PythonConsoleView(project, PyBundle.message("python.console", new Object[0]), sdk, testMode));
        if (RegistryManager.getInstance().is("python.console.CommandQueue") && consoleView instanceof ConsoleViewImpl) {
            PythonConsoleView console = this.getPydevConsoleView();
            ShowCommandQueueAction action = new ShowCommandQueueAction(console);
            ((ConsoleViewImpl)consoleView).addCustomConsoleAction((AnAction)action);
        }
        this.enableConsole(!PyConsoleOptions.getInstance(project).isShowDebugConsoleByDefault());
        this.getSwitchConsoleActionPresentation().setIcon(PythonIcons.Python.PythonConsole);
        this.getSwitchConsoleActionPresentation().setText(PyBundle.messagePointer("run.configuration.show.command.line.action.name", new Object[0]));
        ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{PyConsoleUtil.createTabCompletionAction(this.getPydevConsoleView())});
        actions.add(PyConsoleUtil.createInterruptAction(this.getPydevConsoleView()));
        AbstractConsoleRunnerWithHistory.registerActionShortcuts((List)actions, (JComponent)this.getPydevConsoleView().getEditor().getComponent());
        boolean isUseSoftWraps = EditorSettingsExternalizable.getInstance().isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE);
        this.getPydevConsoleView().getEditor().getSettings().setUseSoftWraps(isUseSoftWraps);
    }

    public PythonDebugLanguageConsoleView(Project project, Sdk sdk) {
        this(project, sdk, TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole(), false);
    }

    @Override
    public void executeCode(@Nullable String code, @Nullable Editor e) {
        this.enableConsole(false);
        if (code != null) {
            this.getPydevConsoleView().executeInConsole(code);
        } else {
            IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> this.getPydevConsoleView().requestFocus());
        }
    }

    @NotNull
    public PythonConsoleView getPydevConsoleView() {
        PythonConsoleView pythonConsoleView = (PythonConsoleView)this.getSecondaryConsoleView();
        if (pythonConsoleView == null) {
            PythonDebugLanguageConsoleView.$$$reportNull$$$0(0);
        }
        return pythonConsoleView;
    }

    @Nullable
    public ConsoleViewImpl getTextConsole() {
        ConsoleView consoleView = this.getPrimaryConsoleView();
        if (consoleView instanceof ConsoleViewImpl) {
            return (ConsoleViewImpl)consoleView;
        }
        return null;
    }

    public void showStartMessageForFirstExecution(String startCommand, PythonConsoleView console) {
        console.setPrompt("");
        console.executeStatement(startCommand + "\n", ProcessOutputTypes.SYSTEM);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            PythonDebugLanguageConsoleView.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            PythonDebugLanguageConsoleView.$$$reportNull$$$0(2);
        }
        Key outputType = contentType.equals(ConsoleViewContentType.ERROR_OUTPUT) ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        this.myAnsiEscapeDecoder.escapeText(text2, outputType, (chunk, attributes) -> this.getPydevConsoleView().print(chunk, attributes));
    }

    public void enableConsole(boolean primary) {
        super.enableConsole(primary);
        if (!primary && !this.isPrimaryConsoleEnabled()) {
            PythonConsoleView console = this.getPydevConsoleView();
            if (!this.myDebugConsoleInitialized && console.getExecuteActionHandler() != null) {
                if (!console.getExecuteActionHandler().getConsoleCommunication().isWaitingForInput()) {
                    this.showStartMessageForFirstExecution(DEBUG_CONSOLE_START_COMMAND, console);
                }
                this.myDebugConsoleInitialized = true;
                console.initialized();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> console.requestFocus());
            }
        }
    }

    public void initialized() {
        this.myDebugConsoleInitialized = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonDebugLanguageConsoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPydevConsoleView";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonDebugLanguageConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

