/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.application.options.RegistryManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.console.PyConsoleEnterHandler;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandlerKt;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0004H\u0002J\u000e\u0010)\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u001dJ\u0010\u0010*\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010#\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020%H\u0016J\b\u0010/\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u00100\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u000bH\u0016J\u0010\u00103\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/python/console/PydevConsoleExecuteActionHandler;", "Lcom/jetbrains/python/console/PythonConsoleExecuteActionHandler;", "Lcom/jetbrains/python/console/pydev/ConsoleCommunicationListener;", "myConsoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "consoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "(Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/execution/process/ProcessHandler;Lcom/jetbrains/python/console/pydev/ConsoleCommunication;)V", "cantExecuteMessage", "", "getCantExecuteMessage", "()Ljava/lang/String;", "getConsoleCommunication", "()Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "consoleIsNotEnabledMessage", "getConsoleIsNotEnabledMessage", "ipythonEnabled", "", "getIpythonEnabled", "()Z", "value", "isEnabled", "setEnabled", "(Z)V", "myEnterHandler", "Lcom/jetbrains/python/console/PyConsoleEnterHandler;", "myIpythonInputPromptCount", "", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "canExecuteNow", "checkSingleLine", "text", "commandExecuted", "", "more", "copyToHistoryAndExecute", "console", "decreaseInputPromptCount", "doRunExecuteAction", "executeMultiLine", "executingPrompt", "inPrompt", "inputRequested", "ipythonInPrompt", "ordinaryPrompt", "processLine", "line", "runExecuteAction", "sendLineToConsole", "code", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication$ConsoleCodeFragment;", "updateConsoleState", "waitingForInputPrompt", "Companion", "intellij.python.community.impl"})
public class PydevConsoleExecuteActionHandler
extends PythonConsoleExecuteActionHandler
implements ConsoleCommunicationListener {
    private final Project project;
    private final PyConsoleEnterHandler myEnterHandler;
    private int myIpythonInputPromptCount;
    private boolean isEnabled;
    private final LanguageConsoleView myConsoleView;
    @NotNull
    private final ConsoleCommunication consoleCommunication;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void decreaseInputPromptCount(int value) {
        this.myIpythonInputPromptCount -= value;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.isEnabled = value;
        this.updateConsoleState();
    }

    @Override
    public void processLine(@NotNull String line2) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        this.executeMultiLine(line2);
    }

    private final void executeMultiLine(String text2) {
        Object commandText = !StringsKt.endsWith$default((String)text2, (String)"\n", (boolean)false, (int)2, null) ? text2 + "\n" : text2;
        this.sendLineToConsole(new ConsoleCommunication.ConsoleCodeFragment((String)commandText, this.checkSingleLine(text2)));
    }

    @Override
    public boolean checkSingleLine(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForVirtualFile(this.project, this.myConsoleView.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"PythonLanguageLevelPushe\u2026yConsoleView.virtualFile)");
        LanguageLevel languageLevel2 = languageLevel;
        PsiFile psiFile = PyElementGenerator.getInstance(this.project).createDummyFile(languageLevel2, text2);
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyFile");
        }
        PyFile pyFile = (PyFile)psiFile;
        return PsiTreeUtil.findChildOfAnyType((PsiElement)((PsiElement)pyFile), (Class[])new Class[]{PyStatementList.class}) == null && pyFile.getStatements().size() < 2;
    }

    private final void sendLineToConsole(ConsoleCommunication.ConsoleCodeFragment code) {
        ConsoleCommunication consoleComm = this.consoleCommunication;
        if (!consoleComm.isWaitingForInput()) {
            this.executingPrompt();
        }
        if (this.getIpythonEnabled() && !consoleComm.isWaitingForInput()) {
            String string = code.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code.getText()");
            if (!StringsKt.isBlank((CharSequence)string)) {
                PydevConsoleExecuteActionHandler pydevConsoleExecuteActionHandler = this;
                ++pydevConsoleExecuteActionHandler.myIpythonInputPromptCount;
                int cfr_ignored_0 = pydevConsoleExecuteActionHandler.myIpythonInputPromptCount;
            }
        }
        if (RegistryManager.getInstance().is("python.console.CommandQueue")) {
            boolean $i$f$service = false;
            Class<CommandQueueForPythonConsoleService> serviceClass$iv = CommandQueueForPythonConsoleService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            ((CommandQueueForPythonConsoleService)object).addNewCommand(this, code);
        } else {
            consoleComm.execInterpreter(code, (Function<InterpreterResponse, Object>)((Function)sendLineToConsole.1.INSTANCE));
        }
    }

    @Override
    public void updateConsoleState() {
        if (!this.isEnabled()) {
            this.executingPrompt();
        } else if (this.consoleCommunication.isWaitingForInput()) {
            this.waitingForInputPrompt();
        } else if (this.canExecuteNow()) {
            if (this.consoleCommunication.needsMore()) {
                this.more();
            } else {
                this.inPrompt();
            }
        } else if (RegistryManager.getInstance().is("python.console.CommandQueue")) {
            this.inPrompt();
        } else {
            this.executingPrompt();
        }
    }

    private final void inPrompt() {
        if (this.getIpythonEnabled()) {
            this.ipythonInPrompt();
        } else {
            this.ordinaryPrompt();
        }
    }

    private final void ordinaryPrompt() {
        if (Intrinsics.areEqual((Object)">>>", (Object)this.myConsoleView.getPrompt()) ^ true) {
            this.myConsoleView.setPrompt(">>>");
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt$p(this.myConsoleView, "...");
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    private final boolean getIpythonEnabled() {
        PythonConsoleData pythonConsoleData = PyConsoleUtil.getOrCreateIPythonData(this.myConsoleView.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)pythonConsoleData, (String)"PyConsoleUtil.getOrCreat\u2026yConsoleView.virtualFile)");
        return pythonConsoleData.isIPythonEnabled();
    }

    private final void ipythonInPrompt() {
        this.myConsoleView.setPromptAttributes(new ConsoleViewContentType("", new TextAttributes()){

            @NotNull
            public TextAttributes getAttributes() {
                TextAttributes attrs;
                EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                TextAttributes textAttributes = attrs = editorColorsManager.getGlobalScheme().getAttributes(ConsoleViewContentType.USER_INPUT_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"attrs");
                textAttributes.setFontType(0);
                return attrs;
            }
        });
        String prompt = "In [" + this.myIpythonInputPromptCount + "]:";
        String indentPrompt = StringsKt.padStart$default((String)"...:", (int)prompt.length(), (char)'\u0000', (int)2, null);
        this.myConsoleView.setPrompt(prompt);
        PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt$p(this.myConsoleView, indentPrompt);
        PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
    }

    private final void executingPrompt() {
        this.myConsoleView.setPrompt("");
        PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt$p(this.myConsoleView, "");
    }

    private final void waitingForInputPrompt() {
        if (Intrinsics.areEqual((Object)">?", (Object)this.myConsoleView.getPrompt()) ^ true && Intrinsics.areEqual((Object)"help>", (Object)this.myConsoleView.getPrompt()) ^ true) {
            this.myConsoleView.setPrompt(">?");
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt$p(this.myConsoleView, ">?");
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    private final void more() {
        String prompt;
        String string = prompt = this.getIpythonEnabled() ? "...:" : "...";
        if (Intrinsics.areEqual((Object)prompt, (Object)this.myConsoleView.getPrompt()) ^ true) {
            this.myConsoleView.setPrompt(prompt);
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt$p(this.myConsoleView, prompt);
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    @Override
    public void commandExecuted(boolean more) {
        this.updateConsoleState();
    }

    @Override
    public void inputRequested() {
        this.setEnabled(true);
    }

    @Override
    @NotNull
    public String getCantExecuteMessage() {
        if (!this.isEnabled()) {
            return this.getConsoleIsNotEnabledMessage();
        }
        if (!this.canExecuteNow()) {
            return Companion.getPrevCommandRunningMessage();
        }
        return "Can't execute the command";
    }

    public void runExecuteAction(@NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        if (this.isEnabled()) {
            if (RegistryManager.getInstance().is("python.console.CommandQueue")) {
                this.doRunExecuteAction(console);
            } else if (!this.canExecuteNow()) {
                HintManager.getInstance().showErrorHint((Editor)console.getConsoleEditor(), Companion.getPrevCommandRunningMessage());
            } else {
                this.doRunExecuteAction(console);
            }
        } else {
            HintManager.getInstance().showErrorHint((Editor)console.getConsoleEditor(), this.getConsoleIsNotEnabledMessage());
        }
    }

    private final void doRunExecuteAction(LanguageConsoleView console) {
        Document document = this.myConsoleView.getEditorDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"myConsoleView.editorDocument");
        Document doc = document;
        RangeMarker rangeMarker = doc.createRangeMarker(doc.getTextLength(), doc.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"doc.createRangeMarker(do\u2026xtLength, doc.textLength)");
        RangeMarker endMarker = rangeMarker;
        endMarker.setGreedyToLeft(false);
        endMarker.setGreedyToRight(true);
        EditorEx editorEx = console.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"console.consoleEditor");
        boolean isComplete = this.myEnterHandler.handleEnterPressed(editorEx);
        if (isComplete || this.consoleCommunication.isWaitingForInput()) {
            Companion.deleteString(doc, endMarker);
            if (PydevConsoleExecuteActionHandler.Companion.shouldCopyToHistory(console)) {
                LanguageConsoleView languageConsoleView = console;
                if (!(languageConsoleView instanceof PythonConsoleView)) {
                    languageConsoleView = null;
                }
                PythonConsoleView pythonConsoleView = (PythonConsoleView)languageConsoleView;
                if (pythonConsoleView != null) {
                    PythonConsoleView pythonConsoleView2;
                    PythonConsoleView pythonConsole = pythonConsoleView2 = pythonConsoleView;
                    boolean bl = false;
                    pythonConsole.flushDeferredText();
                    EditorEx editorEx2 = pythonConsole.getHistoryViewer();
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"pythonConsole.historyViewer");
                    DocumentEx documentEx = editorEx2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"pythonConsole.historyViewer.document");
                    int n = documentEx.getLineCount();
                    EditorEx editorEx3 = ((PythonConsoleView)console).getConsoleEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx3, (String)"console.consoleEditor");
                    DocumentEx documentEx2 = editorEx3.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"console.consoleEditor.document");
                    pythonConsole.storeExecutionCounterLineNumber(this.myIpythonInputPromptCount, n + documentEx2.getLineCount());
                }
                this.copyToHistoryAndExecute(console);
            } else {
                EditorEx editorEx4 = this.myConsoleView.getConsoleEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx4, (String)"myConsoleView.consoleEditor");
                DocumentEx documentEx = editorEx4.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"myConsoleView.consoleEditor.document");
                String string = documentEx.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myConsoleView.consoleEditor.document.text");
                this.processLine(string);
            }
        }
    }

    private final void copyToHistoryAndExecute(LanguageConsoleView console) {
        super.runExecuteAction(console);
    }

    @Override
    public boolean canExecuteNow() {
        return !this.consoleCommunication.isExecuting() || this.consoleCommunication.isWaitingForInput();
    }

    @NotNull
    protected String getConsoleIsNotEnabledMessage() {
        return Companion.getNotEnabledMessage();
    }

    @Override
    @NotNull
    public final ConsoleCommunication getConsoleCommunication() {
        return this.consoleCommunication;
    }

    public PydevConsoleExecuteActionHandler(@NotNull LanguageConsoleView myConsoleView, @NotNull ProcessHandler processHandler, @NotNull ConsoleCommunication consoleCommunication) {
        Intrinsics.checkNotNullParameter((Object)myConsoleView, (String)"myConsoleView");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)consoleCommunication, (String)"consoleCommunication");
        super(processHandler, false);
        this.myConsoleView = myConsoleView;
        this.consoleCommunication = consoleCommunication;
        Project project = this.myConsoleView.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myConsoleView.project");
        this.project = project;
        this.myEnterHandler = new PyConsoleEnterHandler();
        this.myIpythonInputPromptCount = 2;
        this.consoleCommunication.addCommunicationListener(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/console/PydevConsoleExecuteActionHandler$Companion;", "", "()V", "notEnabledMessage", "", "getNotEnabledMessage", "()Ljava/lang/String;", "prevCommandRunningMessage", "getPrevCommandRunningMessage", "deleteString", "", "document", "Lcom/intellij/openapi/editor/Document;", "endMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "shouldCopyToHistory", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final String getPrevCommandRunningMessage() {
            return "Previous command is still running. Please wait or press Ctrl+C in console to interrupt.";
        }

        @NotNull
        public final String getNotEnabledMessage() {
            return "Console is not enabled.";
        }

        private final boolean shouldCopyToHistory(LanguageConsoleView console) {
            return !PyConsoleUtil.isPagingPrompt(console.getPrompt());
        }

        public final void deleteString(@NotNull Document document, @NotNull RangeMarker endMarker) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)endMarker, (String)"endMarker");
            if (endMarker.getEndOffset() - endMarker.getStartOffset() > 0) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(document, endMarker){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ RangeMarker $endMarker;

                    public final void run() {
                        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this){
                            final /* synthetic */ deleteString.1 this$0;

                            public final void run() {
                                this.this$0.$document.deleteString(this.this$0.$endMarker.getStartOffset(), this.this$0.$endMarker.getEndOffset());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$document = document;
                        this.$endMarker = rangeMarker;
                    }
                });
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

