/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.PyInjectorBase;
import com.jetbrains.python.codeInsight.functionTypeComments.PyFunctionTypeAnnotationDialect;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintDialect;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingAnnotationInjector
extends PyInjectorBase {
    public static final Pattern RE_TYPING_ANNOTATION = Pattern.compile("\\s*\\S+(\\[.*\\])?\\s*");
    private static final Pattern TYPE_IGNORE_PATTERN = Pattern.compile("#\\s*type:\\s*ignore(\\[[^]#]*])?\\s*($|(#.*))", 2);

    @Override
    protected PyInjectionUtil.InjectionResult registerInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context2) {
        PyInjectionUtil.InjectionResult result;
        if (registrar == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(1);
        }
        if ((result = super.registerInjection(registrar, context2)) == PyInjectionUtil.InjectionResult.EMPTY && context2 instanceof PsiComment && context2 instanceof PsiLanguageInjectionHost && context2.getContainingFile() instanceof PyFile) {
            return PyTypingAnnotationInjector.registerCommentInjection(registrar, (PsiLanguageInjectionHost)context2);
        }
        return result;
    }

    @Override
    @Nullable
    public Language getInjectedLanguage(@NotNull PsiElement context2) {
        if (context2 == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(2);
        }
        if (context2 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)context2;
            TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(expr.getProject(), expr.getContainingFile());
            if (PyTypingAnnotationInjector.isTypingLiteralArgument(expr, typeEvalContext) || PyTypingAnnotationInjector.isTypingAnnotatedMetadataArgument(expr, typeEvalContext)) {
                return null;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)context2, PyAnnotation.class, (boolean)true, (Class[])new Class[]{PyCallExpression.class}) != null && PyTypingAnnotationInjector.isTypingAnnotation(expr.getStringValue())) {
                return PyTypeHintDialect.INSTANCE;
            }
            if (PyTypingAnnotationInjector.isInsideValueOfExplicitTypeAnnotation(expr)) {
                return PyTypeHintDialect.INSTANCE;
            }
        }
        return null;
    }

    private static boolean isInsideValueOfExplicitTypeAnnotation(@NotNull PyStringLiteralExpression expr) {
        PyAssignmentStatement assignment;
        if (expr == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(3);
        }
        if ((assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyAssignmentStatement.class)) == null || !PsiTreeUtil.isAncestor((PsiElement)assignment.getAssignedValue(), (PsiElement)expr, (boolean)false)) {
            return false;
        }
        return PyTypingTypeProvider.isExplicitTypeAlias(assignment, TypeEvalContext.codeAnalysis(expr.getProject(), expr.getContainingFile()));
    }

    @NotNull
    private static PyInjectionUtil.InjectionResult registerCommentInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiLanguageInjectionHost host) {
        Language language;
        String text2;
        String annotationText;
        if (registrar == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(4);
        }
        if (host == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(5);
        }
        if ((annotationText = PyTypingTypeProvider.getTypeCommentValue(text2 = host.getText())) != null && (language = PyTypingTypeProvider.TYPE_IGNORE_PATTERN.matcher(text2).matches() ? null : (PyTypingAnnotationInjector.isFunctionTypeComment((PsiElement)host) ? PyFunctionTypeAnnotationDialect.INSTANCE : PyTypeHintDialect.INSTANCE)) != null) {
            registrar.startInjecting(language);
            registrar.addPlace("", "", host, PyTypingTypeProvider.getTypeCommentValueRange(text2));
            registrar.doneInjecting();
            return new PyInjectionUtil.InjectionResult(true, true);
        }
        PyInjectionUtil.InjectionResult injectionResult = PyInjectionUtil.InjectionResult.EMPTY;
        if (injectionResult == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(6);
        }
        return injectionResult;
    }

    private static boolean isTypingLiteralArgument(@NotNull PsiElement element, @NotNull TypeEvalContext context2) {
        PySubscriptionExpression subscription;
        PsiElement parent;
        if (element == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(8);
        }
        if ((parent = element.getParent()) instanceof PyTupleExpression) {
            parent = parent.getParent();
        }
        if ((subscription = (PySubscriptionExpression)ObjectUtils.tryCast((Object)parent, PySubscriptionExpression.class)) == null) {
            return false;
        }
        PyReferenceExpression operand = (PyReferenceExpression)ObjectUtils.tryCast((Object)subscription.getOperand(), PyReferenceExpression.class);
        if (operand == null) {
            return false;
        }
        Collection<String> resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context2);
        return ContainerUtil.exists(resolvedNames, name2 -> "typing.Literal".equals(name2) || "typing_extensions.Literal".equals(name2));
    }

    private static boolean isTypingAnnotatedMetadataArgument(@NotNull PsiElement element, @NotNull TypeEvalContext context2) {
        PyTupleExpression tuple;
        if (element == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(10);
        }
        if ((tuple = PyUtil.as(element.getParent(), PyTupleExpression.class)) == null) {
            return false;
        }
        PySubscriptionExpression parent = PyUtil.as(tuple.getParent(), PySubscriptionExpression.class);
        if (parent == null) {
            return false;
        }
        PyExpression operand = parent.getOperand();
        Collection<String> resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context2);
        if (resolvedNames.stream().anyMatch(name2 -> "typing.Annotated".equals(name2) || "typing_extensions.Annotated".equals(name2))) {
            return tuple.getElements()[0] != element;
        }
        return false;
    }

    private static boolean isFunctionTypeComment(@NotNull PsiElement comment) {
        PyFunction function;
        if (comment == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(11);
        }
        return (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)comment, PyFunction.class)) != null && function.getTypeComment() == comment;
    }

    private static boolean isTypingAnnotation(@NotNull String s) {
        if (s == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(12);
        }
        return RE_TYPING_ANNOTATION.matcher(s).matches();
    }

    public static boolean isTypeIgnoreComment(@NotNull PsiElement comment) {
        if (comment == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(13);
        }
        if (!(comment instanceof PsiComment)) {
            return false;
        }
        String text2 = comment.getText();
        if (text2 == null) {
            return false;
        }
        return TYPE_IGNORE_PATTERN.matcher(text2).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerCommentInjection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInsideValueOfExplicitTypeAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerCommentInjection";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTypingLiteralArgument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTypingAnnotatedMetadataArgument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionTypeComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTypingAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTypeIgnoreComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

