/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyLineMarkerNavigator;
import com.jetbrains.python.codeInsight.PyLineSeparatorUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineMarkerProvider
implements LineMarkerProvider,
PyLineSeparatorUtil.Provider {
    private static final int INHERITORS_LIMIT = 10;
    private static final Function<PsiElement, @NlsContexts.Tooltip String> ourSubclassTooltipProvider = identifier -> {
        PsiElement parent = identifier.getParent();
        if (!(parent instanceof PyClass)) {
            return null;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(PyBundle.message("line.markers.tooltip.header.is.subclassed.by", new Object[0]));
        AtomicInteger count = new AtomicInteger();
        PyClass pyClass = (PyClass)parent;
        PyClassInheritorsSearch.search(pyClass, true).forEach(inheritor -> {
            String className = inheritor.getName();
            if (className == null) {
                return true;
            }
            if (count.incrementAndGet() >= 10) {
                return false;
            }
            builder.br().nbsp(2).append(className);
            return true;
        });
        boolean tooManySubclasses = count.get() >= 10;
        return tooManySubclasses ? PyBundle.message("line.markers.tooltip.has.subclasses", new Object[0]) : builder.wrapWithHtmlBody().toString();
    };
    private static final Function<PsiElement, @NlsContexts.Tooltip String> ourOverridingMethodTooltipProvider = element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PyFunction)) {
            return "";
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(PyBundle.message("line.markers.tooltip.header.is.overridden.in", new Object[0]));
        AtomicInteger count = new AtomicInteger();
        PyFunction pyFunction = (PyFunction)parent;
        PyClassInheritorsSearch.search(pyFunction.getContainingClass(), true).forEach(pyClass -> {
            String className = pyClass.getName();
            if (className == null) {
                return true;
            }
            if (count.incrementAndGet() >= 10) {
                return false;
            }
            if (pyClass.findMethodByName(pyFunction.getName(), false, null) != null) {
                builder.br().nbsp(2).append(className);
            }
            return true;
        });
        boolean tooManyOverrides = count.get() >= 10;
        return tooManyOverrides ? PyBundle.message("line.markers.tooltip.has.overridden.methods", new Object[0]) : builder.wrapWithHtmlBody().toString();
    };
    private static final PyLineMarkerNavigator<PsiElement> SUPER_METHOD_NAVIGATOR = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        @NlsContexts.PopupTitle
        protected String getTitle(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                1.$$$reportNull$$$0(0);
            }
            return PyBundle.message("line.markers.popup.title.choose.super.method", ((PyFunction)nameIdentifier.getParent()).getName());
        }

        @Override
        @Nullable
        protected Query<PsiElement> search(@NotNull PsiElement nameIdentifier, @NotNull TypeEvalContext context2) {
            if (nameIdentifier == null) {
                1.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                1.$$$reportNull$$$0(2);
            }
            if (!(nameIdentifier.getParent() instanceof PyFunction)) {
                return null;
            }
            return PySuperMethodsSearch.search((PyFunction)nameIdentifier.getParent(), context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/codeInsight/PyLineMarkerProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTitle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "search";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final PyLineMarkerNavigator<PsiElement> SUPER_ATTRIBUTE_NAVIGATOR = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        @NlsContexts.PopupTitle
        protected String getTitle(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                2.$$$reportNull$$$0(0);
            }
            return PyBundle.message("line.markers.popup.title.choose.super.attribute", ((PyTargetExpression)nameIdentifier.getParent()).getName());
        }

        @Override
        @Nullable
        protected Query<PsiElement> search(@NotNull PsiElement nameIdentifier, @NotNull TypeEvalContext context2) {
            if (nameIdentifier == null) {
                2.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                2.$$$reportNull$$$0(2);
            }
            if (!(nameIdentifier.getParent() instanceof PyTargetExpression)) {
                return null;
            }
            ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, PyClass.class);
            if (containingClass != null) {
                for (PyClass ancestor : containingClass.getAncestorClasses(context2)) {
                    PyTargetExpression attribute = ancestor.findClassAttribute(nameIdentifier.getText(), false, context2);
                    if (attribute == null) continue;
                    result.add(attribute);
                }
            }
            return new CollectionQuery(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/codeInsight/PyLineMarkerProvider$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTitle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "search";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final PyLineMarkerNavigator<PsiElement> ourSubclassNavigator = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        @NlsContexts.PopupTitle
        protected String getTitle(PsiElement elt) {
            PsiElement parent = elt.getParent();
            return parent instanceof PyClass ? PyBundle.message("line.markers.popup.title.choose.subclass", ((PyClass)parent).getName()) : "";
        }

        @Override
        @Nullable
        protected Query<? extends PsiElement> search(PsiElement elt, @NotNull TypeEvalContext context2) {
            PsiElement parent;
            if (context2 == null) {
                3.$$$reportNull$$$0(0);
            }
            return (parent = elt.getParent()) instanceof PyClass ? PyClassInheritorsSearch.search((PyClass)parent, true) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyLineMarkerProvider$3", "search"));
        }
    };
    private static final PyLineMarkerNavigator<PsiElement> ourOverridingMethodNavigator = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        @NlsContexts.PopupTitle
        protected String getTitle(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PyFunction) {
                return PyBundle.message("line.markers.popup.title.choose.overriding.method", ((PyFunction)parent).getName());
            }
            return "";
        }

        @Override
        protected Query<? extends PsiElement> search(PsiElement element, @NotNull TypeEvalContext context2) {
            PsiElement parent;
            if (context2 == null) {
                4.$$$reportNull$$$0(0);
            }
            return (parent = element.getParent()) instanceof PyFunction ? PyOverridingMethodsSearch.search((PyFunction)parent, true) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyLineMarkerProvider$4", "search"));
        }
    };

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            PyLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((elementType = element.getNode().getElementType()) == PyTokenTypes.IDENTIFIER && element.getParent() instanceof PyFunction) {
            PyFunction function = (PyFunction)element.getParent();
            return PyLineMarkerProvider.getMethodMarker(element, function);
        }
        if (element instanceof PyTargetExpression && PyUtil.isClassAttribute(element)) {
            return PyLineMarkerProvider.getAttributeMarker((PyTargetExpression)element);
        }
        if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS || element.getFirstChild() != null) {
            return null;
        }
        PyElement parentDeclaration = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFunction.class, PyClass.class});
        if (parentDeclaration == null || element != PsiTreeUtil.getDeepestFirst((PsiElement)parentDeclaration)) {
            return null;
        }
        if (this.isSeparatorAllowed((PsiElement)parentDeclaration)) {
            return PyLineSeparatorUtil.addLineSeparatorIfNeeded(this, (PsiElement)parentDeclaration);
        }
        return null;
    }

    @Override
    public boolean isSeparatorAllowed(@Nullable PsiElement element) {
        if (element == null || element.getContainingFile().getVirtualFile() instanceof BackedVirtualFile) {
            return false;
        }
        if (element instanceof PyClass) {
            return PyUtil.isTopLevel(element);
        }
        if (element instanceof PyFunction) {
            if (PyUtil.isTopLevel(element)) {
                return true;
            }
            PyClass containingClass = ((PyFunction)element).getContainingClass();
            if (containingClass != null && PyUtil.isTopLevel((PsiElement)containingClass)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> getMethodMarker(PsiElement identifier, PyFunction function) {
        if (PyUtil.isInitMethod(function)) {
            return null;
        }
        TypeEvalContext context2 = TypeEvalContext.codeAnalysis(identifier.getProject(), function.getContainingFile());
        PsiElement superMethod = (PsiElement)PySuperMethodsSearch.search(function, context2).findFirst();
        if (superMethod != null) {
            PyClass superClass = null;
            if (superMethod instanceof PyFunction) {
                superClass = ((PyFunction)superMethod).getContainingClass();
            }
            return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.OverridingMethod, (Function)(superClass == null ? null : new TooltipProvider(PyBundle.message("line.markers.tooltip.overrides.method.in.class", superClass.getName()))), SUPER_METHOD_NAVIGATOR, GutterIconRenderer.Alignment.RIGHT);
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> getAttributeMarker(PyTargetExpression element) {
        String name2 = element.getReferencedName();
        if (name2 == null) {
            return null;
        }
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (containingClass == null) {
            return null;
        }
        for (PyClass ancestor : containingClass.getAncestorClasses(TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile()))) {
            PsiElement identifier;
            PyTargetExpression ancestorAttr = ancestor.findClassAttribute(name2, false, null);
            if (ancestorAttr == null || (identifier = element.getNameIdentifier()) == null) continue;
            return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.OverridingMethod, (Function)new TooltipProvider(PyBundle.message("line.markers.tooltip.overrides.attribute.in.class", ancestor.getName())), SUPER_ATTRIBUTE_NAVIGATOR, GutterIconRenderer.Alignment.RIGHT);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            PyLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PyLineMarkerProvider.$$$reportNull$$$0(2);
        }
        HashSet<PyFunction> functions = new HashSet<PyFunction>();
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PyClass) {
                PyLineMarkerProvider.collectInheritingClasses((PyClass)psiElement, result);
                continue;
            }
            if (!(psiElement instanceof PyFunction)) continue;
            functions.add((PyFunction)psiElement);
        }
        PyLineMarkerProvider.collectOverridingMethods(functions, result);
    }

    private static void collectInheritingClasses(PyClass element, Collection<? super LineMarkerInfo<?>> result) {
        PsiElement identifier;
        if (PyClassInheritorsSearch.search(element, false).findFirst() != null && (identifier = element.getNameIdentifier()) != null) {
            result.add(new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.OverridenMethod, ourSubclassTooltipProvider, ourSubclassNavigator, GutterIconRenderer.Alignment.RIGHT));
        }
    }

    private static void collectOverridingMethods(Set<? extends PyFunction> functions, Collection<? super LineMarkerInfo<?>> result) {
        HashSet<PyClass> classes = new HashSet<PyClass>();
        MultiMap candidates = new MultiMap();
        for (PyFunction pyFunction : functions) {
            PyClass pyClass = pyFunction.getContainingClass();
            if (pyClass == null || pyFunction.getName() == null) continue;
            classes.add(pyClass);
            candidates.putValue((Object)pyClass, (Object)pyFunction);
        }
        HashSet overridden = new HashSet();
        for (PyClass pyClass : classes) {
            PyClassInheritorsSearch.search(pyClass, true).forEach(inheritor -> {
                Iterator it = candidates.get((Object)pyClass).iterator();
                while (it.hasNext()) {
                    PyFunction func = (PyFunction)it.next();
                    if (inheritor.findMethodByName(func.getName(), false, null) == null) continue;
                    overridden.add(func);
                    it.remove();
                }
                return !candidates.isEmpty();
            });
            if (!candidates.isEmpty()) continue;
            break;
        }
        for (PyFunction func : overridden) {
            PsiElement identifier = func.getNameIdentifier();
            if (identifier == null) continue;
            result.add(new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.OverridenMethod, ourOverridingMethodTooltipProvider, ourOverridingMethodNavigator, GutterIconRenderer.Alignment.RIGHT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/PyLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TooltipProvider
    implements Function<PsiElement, String> {
        private final String myText;

        private TooltipProvider(@NlsContexts.Tooltip String text2) {
            this.myText = text2;
        }

        public String fun(PsiElement psiElement) {
            return this.myText;
        }
    }
}

