/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSdkUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(JavaSdkUtil.getJdkClassesRoots(home.toPath(), isJre), Path::toFile);
        if (list == null) {
            JavaSdkUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<Path> getJdkClassesRoots(@NotNull Path home, boolean isJre) {
        Path classesDir;
        Path path;
        Path[] jarDirs;
        Path libDir;
        Path fileName;
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(2);
        }
        if ((fileName = home.getFileName()) != null && "Home".equals(fileName.toString()) && Files.exists(home.resolve("../Classes/classes.jar"), new LinkOption[0])) {
            libDir = home.resolve("lib");
            Path classesDir2 = home.resolveSibling("Classes");
            Path path2 = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, classesDir2, path2};
        } else if (Files.exists(home.resolve("lib/jrt-fs.jar"), new LinkOption[0])) {
            jarDirs = new Path[]{};
        } else {
            libDir = home.resolve(isJre ? "lib" : "jre/lib");
            Path libExtDir = libDir.resolve("ext");
            Path path3 = libDir.resolve("endorsed");
            jarDirs = new Path[]{path3, libDir, libExtDir};
        }
        Set pathFilter = CollectionFactory.createFilePathSet();
        ArrayList<Path> rootFiles = new ArrayList<Path>();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk", (boolean)false) && Files.isRegularFile(path = home.resolve("lib/tools.jar"), new LinkOption[0])) {
            rootFiles.add(path);
        }
        for (Path jarDir : jarDirs) {
            if (jarDir == null || !Files.isDirectory(jarDir, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jarDir, "*.jar");){
                for (Path jarFile : stream) {
                    String canonicalPath;
                    String jarFileName = jarFile.getFileName().toString();
                    if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                    rootFiles.add(jarFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(home.resolve(isJre ? "bin" : "jre/bin"));
        try (DirectoryStream<Path> stream22 = Files.newDirectoryStream(home.resolve(isJre ? "lib" : "jre/lib"), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            Iterator iterator = stream22.iterator();
            while (iterator.hasNext()) {
                Path path4 = (Path)iterator.next();
                arrayList.add(path4);
            }
        }
        catch (IOException stream22) {
            // empty catch block
        }
        for (Path candidate : arrayList) {
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(candidate, p -> p.getFileName().toString().startsWith("jclSC") && Files.isDirectory(p, new LinkOption[0]));
                try {
                    for (Path dir : stream) {
                        Path vmJar = dir.resolve("vm.jar");
                        if (!Files.isRegularFile(vmJar, new LinkOption[0])) continue;
                        rootFiles.add(vmJar);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        Path classesZip = home.resolve("lib/classes.zip");
        if (Files.isRegularFile(classesZip, new LinkOption[0])) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && Files.isDirectory(classesDir = home.resolve("classes"), new LinkOption[0])) {
            rootFiles.add(classesDir);
        }
        ArrayList<Path> arrayList2 = rootFiles;
        if (arrayList2 == null) {
            JavaSdkUtil.$$$reportNull$$$0(3);
        }
        return arrayList2;
    }

    @Nullable
    private static String getCanonicalPath(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

