/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0015\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/completion/ml/personalization/session/PeriodTracker;", "", "()V", "durations", "", "", "addDuration", "", "duration", "average", "", "currentPeriod", "(Ljava/lang/Long;)D", "count", "", "(Ljava/lang/Long;)I", "maxDuration", "(Ljava/lang/Long;)Ljava/lang/Long;", "minDuration", "totalTime", "(Ljava/lang/Long;)J", "intellij.completionMlRanking"})
public final class PeriodTracker {
    private final List<Long> durations = new ArrayList();

    @Nullable
    public final Long minDuration(@Nullable Long currentPeriod) {
        Long pastMin = (Long)CollectionsKt.minOrNull((Iterable)this.durations);
        if (pastMin == null) {
            return currentPeriod;
        }
        if (currentPeriod != null) {
            long l = pastMin;
            long l2 = currentPeriod;
            return Math.min(l, l2);
        }
        return pastMin;
    }

    @Nullable
    public final Long maxDuration(@Nullable Long currentPeriod) {
        Long pastMax = (Long)CollectionsKt.maxOrNull((Iterable)this.durations);
        if (pastMax == null) {
            return currentPeriod;
        }
        if (currentPeriod != null) {
            long l = pastMax;
            long l2 = currentPeriod;
            return Math.max(l, l2);
        }
        return pastMax;
    }

    public final double average(@Nullable Long currentPeriod) {
        if (this.durations.isEmpty()) {
            Long l = currentPeriod;
            return l != null ? (double)l.longValue() : 0.0;
        }
        double pastAvg = CollectionsKt.averageOfLong((Iterable)this.durations);
        if (currentPeriod == null) {
            return pastAvg;
        }
        int n = this.durations.size();
        return pastAvg * (double)n / (double)(n + 1) + (double)(currentPeriod / (long)(n + 1));
    }

    public final int count(@Nullable Long currentPeriod) {
        return this.durations.size() + (currentPeriod != null ? 1 : 0);
    }

    public final long totalTime(@Nullable Long currentPeriod) {
        Long l = currentPeriod;
        return CollectionsKt.sumOfLong((Iterable)this.durations) + (l != null ? l : 0L);
    }

    public final void addDuration(long duration) {
        this.durations.add(duration);
    }
}

