/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.completion.ml.personalization.session.CompletionSelectionTracker;
import com.intellij.completion.ml.personalization.session.PeriodTracker;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000f\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl;", "Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTracker;", "()V", "periodTracker", "Lcom/intellij/completion/ml/personalization/session/PeriodTracker;", "selectionStartedTimestamp", "", "currentSelectionTime", "()Ljava/lang/Long;", "getAverageTimeInSelection", "", "getMaxTimeInSelection", "getMinTimeInSelection", "getTimesInSelection", "", "getTotalTimeInSelection", "itemSelected", "", "itemUnselected", "Companion", "intellij.completionMlRanking"})
public final class CompletionSelectionTrackerImpl
implements CompletionSelectionTracker {
    private final PeriodTracker periodTracker = new PeriodTracker();
    private long selectionStartedTimestamp = -1L;
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Companion Companion;

    @Override
    public long getTotalTimeInSelection() {
        return this.periodTracker.totalTime(this.currentSelectionTime());
    }

    @Override
    public int getTimesInSelection() {
        return this.periodTracker.count(this.currentSelectionTime());
    }

    @Override
    public double getAverageTimeInSelection() {
        return this.periodTracker.average(this.currentSelectionTime());
    }

    @Override
    @Nullable
    public Long getMaxTimeInSelection() {
        return this.periodTracker.maxDuration(this.currentSelectionTime());
    }

    @Override
    @Nullable
    public Long getMinTimeInSelection() {
        return this.periodTracker.minDuration(this.currentSelectionTime());
    }

    public final void itemSelected() {
        LOG.assertTrue(this.selectionStartedTimestamp == -1L, (Object)"Element already selected");
        this.selectionStartedTimestamp = System.currentTimeMillis();
    }

    public final void itemUnselected() {
        long timestamp = this.selectionStartedTimestamp;
        if (timestamp != -1L) {
            this.periodTracker.addDuration(System.currentTimeMillis() - timestamp);
            this.selectionStartedTimestamp = -1L;
        } else {
            LOG.error("Element should be selected");
        }
    }

    private final Long currentSelectionTime() {
        long selectionStarted = this.selectionStartedTimestamp;
        if (selectionStarted != -1L) {
            return System.currentTimeMillis() - selectionStarted;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompletionSelectionTrackerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.completionMlRanking"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

