/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.TaskTextProperties;
import training.dsl.impl.LessonExecutor;
import training.dsl.impl.OpenPassedContext;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiHighlightingManager;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.MessagePart;
import training.ui.views.LearnPanel;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 O2\u00020\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 JA\u0010!\u001a\u00020\u001b2\b\b\u0001\u0010\"\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010%\u001a\u00020$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010(J\r\u0010)\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b*J\u0012\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020\u001bJ'\u00100\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b3J\u001a\u00104\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00101\u001a\u00020\u0004H\u0002J\u0006\u00105\u001a\u00020$J\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\u0004J\u0006\u00108\u001a\u00020\u001fJ\u001d\u00109\u001a\u00020\u001b2\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0000\u00a2\u0006\u0002\b=J\u0006\u0010>\u001a\u00020\u001bJ\u000e\u0010?\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001fJ\u000e\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001fJ\u000e\u0010D\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001fJ\u000e\u0010E\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001fJ\u0016\u0010F\u001a\u00020\u001b2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002J\u000e\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u0010J\u000e\u0010L\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u0010J\u0006\u0010M\u001a\u00020\u001bJ\u0010\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020$H\u0002R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006P"}, d2={"Ltraining/learn/lesson/LessonManager;", "", "()V", "<set-?>", "Ltraining/learn/course/Lesson;", "currentLesson", "getCurrentLesson", "()Ltraining/learn/course/Lesson;", "Ltraining/dsl/impl/LessonExecutor;", "currentLessonExecutor", "getCurrentLessonExecutor$intellij_featuresTrainer", "()Ltraining/dsl/impl/LessonExecutor;", "learnPanel", "Ltraining/ui/views/LearnPanel;", "getLearnPanel", "()Ltraining/ui/views/LearnPanel;", "Ltraining/dsl/TaskContext$RestoreNotification;", "shownRestoreNotification", "getShownRestoreNotification", "()Ltraining/dsl/TaskContext$RestoreNotification;", "testActionsExecutor", "Ljava/util/concurrent/Executor;", "getTestActionsExecutor", "()Ljava/util/concurrent/Executor;", "testActionsExecutor$delegate", "Lkotlin/Lazy;", "addInactiveMessage", "", "message", "", "visualNumber", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "addMessage", "text", "isInformer", "", "useInternalParagraphStyle", "textProperties", "Ltraining/dsl/TaskTextProperties;", "(Ljava/lang/String;ZLjava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)V", "clearCurrentLesson", "clearCurrentLesson$intellij_featuresTrainer", "clearEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearRestoreMessage", "focusTask", "initDslLesson", "cLesson", "lessonExecutor", "initDslLesson$intellij_featuresTrainer", "initLesson", "lessonIsRunning", "lessonShouldBeOpenedCompleted", "lesson", "messagesNumber", "openLessonPassed", "Ltraining/learn/course/KLesson;", "project", "Lcom/intellij/openapi/project/Project;", "openLessonPassed$intellij_featuresTrainer", "passExercise", "passLesson", "removeInactiveMessages", "number", "removeMessage", "index", "removeMessageAndRepaint", "resetMessagesNumber", "setNotification", "messages", "", "Ltraining/ui/MessagePart;", "setRestoreNotification", "notification", "setWarningNotification", "stopLesson", "lessonPassed", "Companion", "intellij.featuresTrainer"})
public final class LessonManager {
    @Nullable
    private Lesson currentLesson;
    @Nullable
    private LessonExecutor currentLessonExecutor;
    @Nullable
    private TaskContext.RestoreNotification shownRestoreNotification;
    @NotNull
    private final Lazy testActionsExecutor$delegate = LazyKt.lazy((Function0)testActionsExecutor.2.INSTANCE);
    @Nullable
    private static volatile Executor externalTestActionsExecutor;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Lesson getCurrentLesson() {
        return this.currentLesson;
    }

    private final LearnPanel getLearnPanel() {
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        return learnToolWindow != null ? learnToolWindow.getLearnPanel$intellij_featuresTrainer() : null;
    }

    @Nullable
    public final LessonExecutor getCurrentLessonExecutor$intellij_featuresTrainer() {
        return this.currentLessonExecutor;
    }

    @Nullable
    public final TaskContext.RestoreNotification getShownRestoreNotification() {
        return this.shownRestoreNotification;
    }

    @NotNull
    public final Executor getTestActionsExecutor() {
        Lazy lazy = this.testActionsExecutor$delegate;
        LessonManager lessonManager = this;
        Object var3_3 = null;
        return (Executor)lazy.getValue();
    }

    public final void clearCurrentLesson$intellij_featuresTrainer() {
        this.currentLesson = null;
    }

    public final void openLessonPassed$intellij_featuresTrainer(@NotNull KLesson lesson, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            String string = "No learn panel";
            throw new IllegalStateException(string.toString());
        }
        LearnPanel learnPanel2 = learnPanel;
        this.initLesson(null, lesson);
        learnPanel2.setScrollToNewMessages$intellij_featuresTrainer(false);
        OpenPassedContext openPassedContext = new OpenPassedContext(project, lesson);
        Function1<LessonContext, Unit> function1 = lesson.getFullLessonContent();
        function1.invoke((Object)openPassedContext);
        learnPanel2.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        learnPanel2.makeNextButtonSelected();
        learnPanel2.getLearnToolWindow().showGotItAboutRestart$intellij_featuresTrainer();
    }

    public final void initDslLesson$intellij_featuresTrainer(@Nullable Editor editor, @NotNull Lesson cLesson, @NotNull LessonExecutor lessonExecutor) {
        Intrinsics.checkNotNullParameter((Object)cLesson, (String)"cLesson");
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        this.initLesson(editor, cLesson);
        this.currentLessonExecutor = lessonExecutor;
    }

    public final boolean lessonIsRunning() {
        LessonExecutor lessonExecutor = this.currentLessonExecutor;
        return lessonExecutor != null ? !lessonExecutor.getHasBeenStopped() : false;
    }

    public final void stopLesson() {
        this.stopLesson(false);
    }

    private final void stopLesson(boolean lessonPassed) {
        this.shownRestoreNotification = null;
        LessonExecutor lessonExecutor = this.currentLessonExecutor;
        if (lessonExecutor != null) {
            LessonExecutor lessonExecutor2;
            LessonExecutor it = lessonExecutor2 = lessonExecutor;
            boolean bl = false;
            lessonExecutor = !it.getHasBeenStopped() ? lessonExecutor2 : null;
            if (lessonExecutor != null) {
                it = lessonExecutor2 = lessonExecutor;
                boolean bl2 = false;
                it.stopLesson();
                this.currentLessonExecutor = null;
            }
        }
        if (!lessonPassed) {
            LearningUiHighlightingManager.INSTANCE.clearHighlights();
        }
    }

    private final void initLesson(Editor editor, Lesson cLesson) {
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            return;
        }
        LearnPanel learnPanel2 = learnPanel;
        this.stopLesson();
        this.currentLesson = cLesson;
        learnPanel2.reinitMe(cLesson);
        if (cLesson.getSampleFilePath() == null) {
            this.clearEditor(editor);
        }
        learnPanel2.scrollToTheStart();
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text2, boolean isInformer, @Nullable Integer visualNumber, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            LessonMessagePane.MessageState state = isInformer ? LessonMessagePane.MessageState.INFORMER : LessonMessagePane.MessageState.NORMAL;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessage(text2, new LessonMessagePane.MessageProperties(state, visualNumber, useInternalParagraphStyle, textProperties));
        }
    }

    public static /* synthetic */ void addMessage$default(LessonManager lessonManager, String string, boolean bl, Integer n, boolean bl2, TaskTextProperties taskTextProperties, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            taskTextProperties = null;
        }
        lessonManager.addMessage(string, bl, n, bl2, taskTextProperties);
    }

    public final void addInactiveMessage(@NotNull String message2, @Nullable Integer visualNumber) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessage(message2, new LessonMessagePane.MessageProperties(LessonMessagePane.MessageState.INACTIVE, visualNumber, false, null, 12, null));
        }
    }

    public final void removeInactiveMessages(int number) {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.removeInactiveMessages(number);
        }
    }

    public final void resetMessagesNumber(int number) {
        block0: {
            this.shownRestoreNotification = null;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.resetMessagesNumber(number);
        }
    }

    public final void removeMessage(int index) {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.removeMessage(index);
        }
    }

    public final void removeMessageAndRepaint(int index) {
        block0: {
            LearnPanel learnPanel;
            LearnPanel learnPanel2 = this.getLearnPanel();
            if (learnPanel2 == null) break block0;
            LearnPanel it = learnPanel = learnPanel2;
            boolean bl = false;
            it.removeMessage(index);
            it.getLessonMessagePane().redrawMessages();
            it.adjustMessagesArea();
        }
    }

    public final int messagesNumber() {
        LearnPanel learnPanel = this.getLearnPanel();
        return learnPanel != null ? learnPanel.messagesNumber() : 0;
    }

    public final void passExercise() {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.setPreviousMessagesPassed();
        }
    }

    public final void passLesson(@NotNull Lesson cLesson) {
        Intrinsics.checkNotNullParameter((Object)cLesson, (String)"cLesson");
        cLesson.pass$intellij_featuresTrainer();
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            return;
        }
        LearnPanel learnPanel2 = learnPanel;
        learnPanel2.makeNextButtonSelected();
        this.stopLesson(true);
    }

    private final void clearEditor(Editor editor) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(editor){
            final /* synthetic */ Editor $editor;

            public final void run() {
                if (this.$editor != null) {
                    Document document = this.$editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    Document document2 = document;
                    try {
                        document2.setText((CharSequence)"");
                    }
                    catch (Exception e) {
                        LessonManager.access$getLOG$cp().error((Throwable)e);
                        System.err.println("Unable to update text in editor!");
                    }
                }
            }
            {
                this.$editor = editor;
            }
        });
    }

    public final void clearRestoreMessage() {
        if (this.shownRestoreNotification != null) {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel != null) {
                learnPanel.clearRestoreMessage();
            }
            this.shownRestoreNotification = null;
        }
    }

    public final void setRestoreNotification(@NotNull TaskContext.RestoreNotification notification2) {
        MessagePart messagePart;
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Runnable callback2 = new Runnable(this, notification2){
            final /* synthetic */ LessonManager this$0;
            final /* synthetic */ TaskContext.RestoreNotification $notification;

            public final void run() {
                block0: {
                    this.$notification.getCallback().invoke();
                    LessonExecutor lessonExecutor = this.this$0.getCurrentLessonExecutor$intellij_featuresTrainer();
                    if (lessonExecutor == null) break block0;
                    LessonExecutor this_$iv = lessonExecutor;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$taskInvokeLater = false;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this_$iv, this){
                        final /* synthetic */ LessonExecutor this$0$inline_fun;
                        final /* synthetic */ setRestoreNotification.callback.1 this$0;
                        {
                            this.this$0$inline_fun = lessonExecutor;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            boolean bl = false;
                            try {
                                boolean bl2 = false;
                                this.this$0.this$0.clearRestoreMessage();
                            }
                            catch (Throwable e) {
                                LessonExecutor $this$thisLogger$iv = this.this$0$inline_fun;
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(LessonExecutor.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                                logger.error(this.this$0$inline_fun.getLessonInfoString(), e);
                            }
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
            }
            {
                this.this$0 = lessonManager;
                this.$notification = restoreNotification;
            }
        };
        MessagePart message2 = new MessagePart(" " + notification2.getMessage() + " ", MessagePart.MessageType.TEXT_BOLD);
        MessagePart it = messagePart = new MessagePart(notification2.getRestoreLinkText(), MessagePart.MessageType.LINK);
        boolean bl = false;
        it.setRunnable(callback2);
        MessagePart restoreLink = messagePart;
        this.setNotification(CollectionsKt.listOf((Object[])new MessagePart[]{message2, restoreLink}));
        this.shownRestoreNotification = notification2;
    }

    public final void setWarningNotification(@NotNull TaskContext.RestoreNotification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        List<MessagePart> messages = MessageFactory.INSTANCE.convert(notification2.getMessage());
        this.setNotification(messages);
        this.shownRestoreNotification = notification2;
    }

    private final void setNotification(List<MessagePart> messages) {
        block0: {
            List list2;
            this.clearRestoreMessage();
            Icon icon = AllIcons.General.NotificationWarning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.General.NotificationWarning");
            String warningIconIndex = LearningUiManager.INSTANCE.getIconIndex(icon);
            MessagePart warningIconMessage = new MessagePart(warningIconIndex, MessagePart.MessageType.ICON_IDX);
            List it = list2 = CollectionsKt.mutableListOf((Object[])new MessagePart[]{warningIconMessage});
            boolean bl = false;
            it.addAll((Collection)messages);
            List allMessages = list2;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessages(allMessages, new LessonMessagePane.MessageProperties(LessonMessagePane.MessageState.RESTORE, null, false, null, 14, null));
        }
    }

    public final boolean lessonShouldBeOpenedCompleted(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        return lesson.getPassed$intellij_featuresTrainer() && Intrinsics.areEqual((Object)this.currentLesson, (Object)lesson) ^ true;
    }

    public final void focusTask() {
        block1: {
            if (!this.lessonIsRunning()) break block1;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel != null) {
                learnPanel.focusCurrentMessage();
            }
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LessonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ LessonExecutor access$getCurrentLessonExecutor$p(LessonManager $this) {
        return $this.currentLessonExecutor;
    }

    public static final /* synthetic */ void access$setCurrentLessonExecutor$p(LessonManager $this, LessonExecutor lessonExecutor) {
        $this.currentLessonExecutor = lessonExecutor;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ltraining/learn/lesson/LessonManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "externalTestActionsExecutor", "Ljava/util/concurrent/Executor;", "getExternalTestActionsExecutor", "()Ljava/util/concurrent/Executor;", "setExternalTestActionsExecutor", "(Ljava/util/concurrent/Executor;)V", "instance", "Ltraining/learn/lesson/LessonManager;", "getInstance", "()Ltraining/learn/lesson/LessonManager;", "intellij.featuresTrainer"})
    public static final class Companion {
        @Nullable
        public final Executor getExternalTestActionsExecutor() {
            return externalTestActionsExecutor;
        }

        public final void setExternalTestActionsExecutor(@Nullable Executor executor2) {
            externalTestActionsExecutor = executor2;
        }

        @NotNull
        public final LessonManager getInstance() {
            boolean $i$f$service = false;
            Class<LessonManager> serviceClass$iv = LessonManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LessonManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

