/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.launcher;

import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.UnexpectedException;
import org.assertj.swing.util.Arrays;

public class ApplicationLauncher {
    private final Class<?> applicationType;
    private String[] args = new String[0];

    @Nonnull
    public static ApplicationLauncher application(@Nonnull String applicationTypeName) {
        try {
            Class<?> applicationType = Thread.currentThread().getContextClassLoader().loadClass(applicationTypeName);
            return ApplicationLauncher.application(applicationType);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(Strings.concat("Unable to load class ", Strings.quote(applicationTypeName)), e);
        }
    }

    @Nonnull
    public static ApplicationLauncher application(@Nonnull Class<?> applicationType) {
        return new ApplicationLauncher(applicationType);
    }

    private ApplicationLauncher(@Nonnull Class<?> applicationType) {
        this.applicationType = applicationType;
    }

    @Nonnull
    public ApplicationLauncher withArgs(String ... newArgs) {
        this.args = (String[])Arrays.copyOf((Object[])Preconditions.checkNotNull(newArgs));
        return this;
    }

    public void start() {
        Reflection.method("main").withParameterTypes(String[].class).in(this.applicationType).invoke(new Object[]{this.args});
    }
}

