/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.core.api.Fail;
import org.assertj.core.description.Description;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JTreeMatchingPathQuery;
import org.assertj.swing.driver.JTreePathFinder;
import org.assertj.swing.edt.GuiActionRunner;

final class JTreeVerifySelectionTask {
    @RunsInEDT
    static void checkHasSelection(@Nonnull JTree tree2, @Nonnull int[] selection, @Nonnull Description errMsg) {
        GuiActionRunner.execute(() -> JTreeVerifySelectionTask.checkSelection(tree2, selection, errMsg));
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree2, @Nonnull int[] selection, @Nonnull Description errMsg) {
        int[] selectionRows = tree2.getSelectionRows();
        if (selectionRows == null || selectionRows.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        Arrays.sort(selection);
        if (Arrays.equals(selectionRows, selection)) {
            return;
        }
        JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionRows);
    }

    private static void failNotEqualSelection(@Nonnull Description errMsg, @Nonnull int[] expected, @Nonnull int[] actual) {
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), org.assertj.swing.util.Arrays.format(expected), org.assertj.swing.util.Arrays.format(actual));
        Fail.fail(msg);
    }

    @RunsInEDT
    static void checkHasSelection(@Nonnull JTree tree2, @Nonnull String[] selection, @Nonnull JTreePathFinder pathFinder, @Nonnull Description errMsg) {
        GuiActionRunner.execute(() -> JTreeVerifySelectionTask.checkSelection(tree2, selection, pathFinder, errMsg));
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree2, @Nonnull String[] selection, @Nonnull JTreePathFinder pathFinder, @Nonnull Description errMsg) {
        TreePath[] selectionPaths = tree2.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        int selectionCount = selection.length;
        if (selectionCount != selectionPaths.length) {
            JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
        for (int i = 0; i < selectionCount; ++i) {
            TreePath actual;
            TreePath expected = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree2, Preconditions.checkNotNull(selection[i]), pathFinder);
            if (Objects.areEqual(expected, actual = selectionPaths[i])) continue;
            JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
    }

    private static void failNotEqualSelection(@Nonnull Description errMsg, @Nonnull String[] expected, @Nonnull TreePath[] actual) {
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), org.assertj.swing.util.Arrays.format(expected), org.assertj.swing.util.Arrays.format(actual));
        Fail.fail(msg);
    }

    private static void failNoSelection(@Nonnull Description errMessage) {
        Fail.fail(String.format("[%s] No selection", errMessage.value()));
    }

    @RunsInEDT
    static void checkNoSelection(@Nonnull JTree tree2, @Nonnull Description errMsg) {
        GuiActionRunner.execute(() -> {
            if (tree2.getSelectionCount() == 0) {
                return;
            }
            String format = "[%s] expected no selection but was:<%s>";
            String message2 = String.format(format, errMsg.value(), org.assertj.swing.util.Arrays.format(tree2.getSelectionPaths()));
            Fail.fail(message2);
        });
    }

    private JTreeVerifySelectionTask() {
    }
}

