/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicCellRendererReader;
import org.assertj.swing.driver.CellRendererReader;
import org.assertj.swing.driver.ModelValueToString;

public class BasicJListCellReader
implements JListCellReader {
    private final CellRendererReader rendererReader;

    public BasicJListCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJListCellReader(@Nonnull CellRendererReader rendererReader) {
        this.rendererReader = Preconditions.checkNotNull(rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JList list2, int index) {
        String value;
        Object element = list2.getModel().getElementAt(index);
        ListSelectionModel lsm = list2.getSelectionModel();
        boolean isSelected = lsm.isSelectedIndex(index);
        boolean cellHasFocus = list2.hasFocus() && lsm.getLeadSelectionIndex() == index;
        Component c = list2.getCellRenderer().getListCellRendererComponent(list2, element, index, isSelected, cellHasFocus);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(element);
    }
}

