/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import javax.swing.JLabel;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.AbstractComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public class LabelMatcher
extends AbstractComponentMatcher {
    private final String label;
    private final Class<? extends Component> type;

    public LabelMatcher(@Nullable String label) {
        this(label, false);
    }

    public LabelMatcher(@Nullable String label, boolean requireShowing) {
        this(label, Component.class, requireShowing);
    }

    public LabelMatcher(@Nullable String label, @Nonnull Class<? extends Component> type2) {
        this(label, type2, false);
    }

    public LabelMatcher(@Nullable String label, @Nonnull Class<? extends Component> type2, boolean requireShowing) {
        super(requireShowing);
        this.label = Preconditions.checkNotNullOrEmpty(label).toString();
        this.type = Preconditions.checkNotNull(type2);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (!(c instanceof JLabel)) {
            return false;
        }
        JLabel labelForComponent = (JLabel)c;
        if (!Objects.areEqual(labelForComponent.getText(), this.label)) {
            return false;
        }
        Component labeled = labelForComponent.getLabelFor();
        return this.type.isInstance(labeled) && this.requireShowingMatches(Preconditions.checkNotNull(labeled));
    }

    public String toString() {
        String format = "%s[label=%s, type=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), Strings.quote(this.label), this.type.getName(), this.requireShowing());
    }
}

