/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;

public class Files {
    private Files() {
    }

    public static List<String> fileNamesIn(String dirName, boolean recurse) {
        File dir = new File(dirName);
        Preconditions.checkArgument(dir.isDirectory(), "%s is not a directory", Strings.quote(dirName));
        return Files.fileNamesIn(dir, recurse);
    }

    private static List<String> fileNamesIn(File dir, boolean recurse) {
        ArrayList<String> scriptNames = new ArrayList<String>();
        File[] existingFiles = dir.listFiles();
        if (Arrays.isNullOrEmpty(existingFiles)) {
            return scriptNames;
        }
        for (File existingFile : existingFiles) {
            if (existingFile.isDirectory()) {
                if (!recurse) continue;
                scriptNames.addAll(Files.fileNamesIn(existingFile, recurse));
                continue;
            }
            String filename = existingFile.getAbsolutePath();
            if (scriptNames.contains(filename)) continue;
            scriptNames.add(filename);
        }
        return scriptNames;
    }

    @Deprecated
    public static File temporaryFolder() {
        File temp = new File(Files.temporaryFolderPath());
        if (!temp.isDirectory()) {
            throw new RuntimeException("Unable to find temporary directory");
        }
        return temp;
    }

    public static String temporaryFolderPath() {
        return Strings.append(File.separator).to(System.getProperty("java.io.tmpdir"));
    }

    public static File newTemporaryFile() {
        String tempFileName = Strings.concat(UUID.randomUUID().toString(), ".txt");
        return Files.newFile(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newTemporaryFolder() {
        String tempFileName = UUID.randomUUID().toString();
        return Files.newFolder(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newFile(String path) {
        File file = Files.createFileIfPathIsNotANonEmptyDirectory(path);
        try {
            if (!file.createNewFile()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (IOException e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    public static File newFolder(String path) {
        File file = Files.createFileIfPathIsNotANonEmptyDirectory(path);
        try {
            if (!file.mkdir()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (Exception e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    private static File createFileIfPathIsNotANonEmptyDirectory(String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isNullOrEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        return file;
    }

    private static UncheckedIOException cannotCreateNewFile(String path, String reason) {
        throw Files.cannotCreateNewFile(path, reason, null);
    }

    private static UncheckedIOException cannotCreateNewFile(String path, Exception cause) {
        throw Files.cannotCreateNewFile(path, null, cause);
    }

    private static UncheckedIOException cannotCreateNewFile(String path, String reason, Exception cause) {
        String message2 = String.format("Unable to create the new file %s", Strings.quote(path));
        if (!Strings.isNullOrEmpty(reason)) {
            message2 = Strings.concat(message2, ": ", reason);
        }
        if (cause == null) {
            throw new RuntimeException(message2);
        }
        if (cause instanceof IOException) {
            throw new UncheckedIOException(message2, (IOException)cause);
        }
        throw new RuntimeException(message2, cause);
    }

    public static File currentFolder() {
        try {
            return new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to get current directory", e);
        }
    }

    @Deprecated
    public static void delete(File file) {
        if (file.isFile()) {
            if (!file.delete()) {
                System.out.println("Fail to delete " + file);
            }
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] existingFiles = file.listFiles();
        if (!Arrays.isNullOrEmpty(existingFiles)) {
            for (File f : existingFiles) {
                Files.delete(f);
            }
        }
        if (!file.delete()) {
            System.out.println("Fail to delete " + file);
        }
    }

    public static String contentOf(File file, String charsetName) {
        Files.checkArgumentCharsetIsSupported(charsetName);
        return Files.contentOf(file, Charset.forName(charsetName));
    }

    public static String contentOf(File file, Charset charset) {
        Objects.requireNonNull(charset, "The charset should not be null");
        try {
            return new String(java.nio.file.Files.readAllBytes(file.toPath()), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + file.getAbsolutePath(), e);
        }
    }

    public static List<String> linesOf(File file, Charset charset) {
        Objects.requireNonNull(charset, "The charset should not be null");
        try {
            return java.nio.file.Files.readAllLines(file.toPath(), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + file.getAbsolutePath(), e);
        }
    }

    public static List<String> linesOf(File file, String charsetName) {
        Files.checkArgumentCharsetIsSupported(charsetName);
        return Files.linesOf(file, Charset.forName(charsetName));
    }

    private static void checkArgumentCharsetIsSupported(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
    }

    public static Optional<String> getFileNameExtension(String fileName) {
        int dotAt = fileName.lastIndexOf(46);
        if (dotAt == -1) {
            return Optional.empty();
        }
        String extension = fileName.substring(dotAt + 1);
        return extension.equals("") ? Optional.empty() : Optional.of(extension);
    }
}

