/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFileSizeAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FileSizeAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.internal.Files;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFileAssert<SELF extends AbstractFileAssert<SELF>>
extends AbstractAssert<SELF, File> {
    @VisibleForTesting
    Files files = Files.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    protected AbstractFileAssert(File actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF exists() {
        this.files.assertExists(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF doesNotExist() {
        this.files.assertDoesNotExist(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isFile() {
        this.files.assertIsFile(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectory() {
        this.files.assertIsDirectory(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isAbsolute() {
        this.files.assertIsAbsolute(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isRelative() {
        this.files.assertIsRelative(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isReadable() {
        return this.canRead();
    }

    @Deprecated
    public SELF hasContentEqualTo(File expected) {
        return this.hasSameContentAs(expected);
    }

    @Deprecated
    public SELF hasSameContentAs(File expected) {
        return this.hasSameTextualContentAs(expected);
    }

    public SELF hasSameTextualContentAs(File expected) {
        this.files.assertSameContentAs(this.info, (File)this.actual, this.charset, expected, Charset.defaultCharset());
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasSameBinaryContentAs(File expected) {
        this.files.assertSameBinaryContentAs(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    @Deprecated
    public SELF hasSameContentAs(File expected, Charset expectedCharset) {
        return this.hasSameTextualContentAs(expected, expectedCharset);
    }

    public SELF hasSameTextualContentAs(File expected, Charset expectedCharset) {
        this.files.assertSameContentAs(this.info, (File)this.actual, this.charset, expected, expectedCharset);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasBinaryContent(byte[] expected) {
        this.files.assertHasBinaryContent(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasSize(long expectedSizeInBytes) {
        this.files.assertHasSizeInBytes(this.info, (File)this.actual, expectedSizeInBytes);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingCharset(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
        return this.usingCharset(Charset.forName(charsetName));
    }

    @CheckReturnValue
    public SELF usingCharset(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "The charset should not be null");
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasContent(String expected) {
        this.files.assertHasContent(this.info, (File)this.actual, expected, this.charset);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF canWrite() {
        this.files.assertCanWrite(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isWritable() {
        return this.canWrite();
    }

    public SELF canRead() {
        this.files.assertCanRead(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasParent(File expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasParent(String expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected != null ? new File(expected) : null);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasExtension(String expected) {
        this.files.assertHasExtension(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasName(String expected) {
        this.files.assertHasName(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasFileName(String expected) {
        return this.hasName(expected);
    }

    public SELF hasNoParent() {
        this.files.assertHasNoParent(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, byte[] expected) {
        this.files.assertHasDigest((AssertionInfo)this.info, (File)this.actual, digest, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, String expected) {
        this.files.assertHasDigest((AssertionInfo)this.info, (File)this.actual, digest, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, byte[] expected) {
        this.files.assertHasDigest((AssertionInfo)this.info, (File)this.actual, algorithm, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, String expected) {
        this.files.assertHasDigest((AssertionInfo)this.info, (File)this.actual, algorithm, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryContaining(Predicate<File> filter) {
        this.files.assertIsDirectoryContaining((AssertionInfo)this.info, (File)this.actual, filter);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryContaining(String syntaxAndPattern) {
        this.files.assertIsDirectoryContaining((AssertionInfo)this.info, (File)this.actual, syntaxAndPattern);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryRecursivelyContaining(String syntaxAndPattern) {
        this.files.assertIsDirectoryRecursivelyContaining((AssertionInfo)this.info, (File)this.actual, syntaxAndPattern);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryRecursivelyContaining(Predicate<File> filter) {
        this.files.assertIsDirectoryRecursivelyContaining((AssertionInfo)this.info, (File)this.actual, filter);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryNotContaining(Predicate<File> filter) {
        this.files.assertIsDirectoryNotContaining((AssertionInfo)this.info, (File)this.actual, filter);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectoryNotContaining(String syntaxAndPattern) {
        this.files.assertIsDirectoryNotContaining((AssertionInfo)this.info, (File)this.actual, syntaxAndPattern);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isEmptyDirectory() {
        this.files.assertIsEmptyDirectory(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isNotEmptyDirectory() {
        this.files.assertIsNotEmptyDirectory(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isEmpty() {
        this.files.assertIsEmptyFile(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isNotEmpty() {
        this.files.assertIsNotEmptyFile(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public AbstractStringAssert<?> content() {
        return this.internalContent(Charset.defaultCharset());
    }

    public AbstractStringAssert<?> content(Charset charset) {
        return this.internalContent(charset);
    }

    public SELF hasNoExtension() {
        this.files.assertHasNoExtension(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractFileSizeAssert<SELF> size() {
        Objects.requireNonNull((File)this.actual, "Can not perform assertions on the size of a null file.");
        return new FileSizeAssert(this);
    }

    private AbstractStringAssert<?> internalContent(Charset charset) {
        this.files.assertCanRead(this.info, (File)this.actual);
        String fileContent = this.readFile(charset);
        return new StringAssert(fileContent);
    }

    private String readFile(Charset charset) {
        try {
            return new String(java.nio.file.Files.readAllBytes(((File)this.actual).toPath()), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read %s content with %s charset", this.actual, charset), e);
        }
    }
}

