/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SwitchRevisionsProviderException;

public final class LoadedRevisionsCache
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LoadedRevisionsCache.class);
    private final Project myProject;
    private final Map<String, Bunch> myMap;
    private final Object refreshLock = new Object();
    private long myRefreshTime;
    private final MessageBusConnection myConnection;

    public static LoadedRevisionsCache getInstance(Project project) {
        return (LoadedRevisionsCache)project.getService(LoadedRevisionsCache.class);
    }

    private LoadedRevisionsCache(Project project) {
        this.myProject = project;
        this.myMap = ApplicationManager.getApplication().isUnitTestMode() ? new HashMap() : ContainerUtil.createSoftMap();
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesListener(){

            public void changesLoaded(@NotNull RepositoryLocation location, @NotNull List<CommittedChangeList> changes) {
                if (location == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changes == null) {
                    1.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    LoadedRevisionsCache.this.myMap.clear();
                    LoadedRevisionsCache.this.setRefreshTime(System.currentTimeMillis());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changes";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/svn/history/LoadedRevisionsCache$1";
                objectArray[2] = "changesLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.setRefreshTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRefreshTime() {
        Object object = this.refreshLock;
        synchronized (object) {
            return this.myRefreshTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRefreshTime(long refreshTime) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.myRefreshTime = refreshTime;
        }
    }

    private static void debugInfo(@NotNull List<CommittedChangeList> data, boolean consistentWithPrevious, Bunch bindTo) {
        if (data == null) {
            LoadedRevisionsCache.$$$reportNull$$$0(0);
        }
        LOG.debug(">>> cache internal >>> consistent: " + consistentWithPrevious + " bindTo: " + bindTo + " oldest list: " + data.get(data.size() - 1).getNumber() + ", youngest list: " + data.get(0).getNumber());
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myMap.clear();
    }

    @NotNull
    private static List<List<CommittedChangeList>> split(List<CommittedChangeList> list, int size) {
        int listSize = list.size();
        if (listSize < size) {
            List<List<CommittedChangeList>> list2 = Collections.singletonList(list);
            if (list2 == null) {
                LoadedRevisionsCache.$$$reportNull$$$0(1);
            }
            return list2;
        }
        int first = listSize % size;
        int start = 0;
        int end = first == 0 ? Math.min(listSize, size) : first;
        ArrayList<List<CommittedChangeList>> result = new ArrayList<List<CommittedChangeList>>(listSize / size + 1);
        while (start < listSize) {
            result.add(list.subList(start, end));
            start = end;
            end += size;
        }
        ArrayList<List<CommittedChangeList>> arrayList = result;
        if (arrayList == null) {
            LoadedRevisionsCache.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public Bunch put(List<CommittedChangeList> data, boolean consistentWithPrevious, Bunch bindTo) {
        Bunch fromCache;
        if (data.isEmpty()) {
            return null;
        }
        SvnRepositoryLocation repositoryLocation = ((SvnChangeList)data.get(0)).getLocation();
        String location = repositoryLocation.getURL();
        List<List<CommittedChangeList>> list = LoadedRevisionsCache.split(data, 50);
        Bunch bindToBunch = bindTo;
        if (bindToBunch == null && (fromCache = this.myMap.get(location)) != null) {
            long passedSmallestNumber = data.get(data.size() - 1).getNumber();
            List cachedList = fromCache.getList();
            long greatestNumber = ((CommittedChangeList)cachedList.get(0)).getNumber();
            if (greatestNumber < passedSmallestNumber) {
                bindToBunch = fromCache;
            }
        }
        boolean consistent = consistentWithPrevious;
        for (int i = list.size() - 1; i >= 0; --i) {
            List<CommittedChangeList> changeLists = list.get(i);
            LoadedRevisionsCache.debugInfo(changeLists, consistent, bindToBunch);
            bindToBunch = new Bunch(changeLists, consistent, bindToBunch);
            consistent = true;
        }
        if (bindToBunch != null) {
            this.myMap.put(location, bindToBunch);
        }
        return bindToBunch;
    }

    @Nullable
    public Iterator<ChangesBunch> iterator(String location) {
        Bunch bunch = this.myMap.get(location);
        if (bunch == null) {
            return null;
        }
        return new BunchIterator(bunch);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/LoadedRevisionsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/LoadedRevisionsCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "debugInfo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Bunch
    extends ChangesBunch {
        private final Bunch myNext;

        private Bunch(List<CommittedChangeList> list, boolean consistent, Bunch next) {
            super(list, consistent);
            this.myNext = next;
        }

        public Bunch getNext() {
            return this.myNext;
        }
    }

    private final class BunchIterator
    implements Iterator<ChangesBunch> {
        private final long myCreationTime;
        private Bunch myBunch;

        private BunchIterator(Bunch bunch) {
            this.myBunch = bunch;
            this.myCreationTime = System.currentTimeMillis();
        }

        private void checkValidity() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myCreationTime <= LoadedRevisionsCache.this.getRefreshTime()) {
                throw new SwitchRevisionsProviderException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkValidity();
            return this.myBunch != null;
        }

        @Override
        public ChangesBunch next() {
            this.checkValidity();
            Bunch current = this.myBunch;
            this.myBunch = this.myBunch.myNext;
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

