/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.DelegatingPointer;
import com.intellij.model.DelegatingPointerEq;
import com.intellij.model.HardPointerEq;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface Pointer<T> {
    @Nullable
    public T dereference();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> hardPointer(@NotNull T value) {
        if (value == null) {
            Pointer.$$$reportNull$$$0(0);
        }
        Pointer<Object> pointer = () -> value;
        if (pointer == null) {
            Pointer.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Function<? super U, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(2);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(3);
        }
        return new DelegatingPointer.ByValue<T, U>(underlyingPointer, restoration);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> uroborosPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(4);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(5);
        }
        return new DelegatingPointer.ByValueAndPointer<T, U>(underlyingPointer, restoration);
    }

    @Deprecated
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> hardPointerWithEquality(@NotNull T value) {
        if (value == null) {
            Pointer.$$$reportNull$$$0(6);
        }
        return new HardPointerEq<T>(value);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Object key, @NotNull Function<? super U, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(7);
        }
        if (key == null) {
            Pointer.$$$reportNull$$$0(8);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(9);
        }
        return new DelegatingPointerEq.ByValue<T, U>(underlyingPointer, key, restoration);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> uroborosPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Object key, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(10);
        }
        if (key == null) {
            Pointer.$$$reportNull$$$0(11);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(12);
        }
        return new DelegatingPointerEq.ByValueAndPointer<T, U>(underlyingPointer, key, restoration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/Pointer";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingPointer";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoration";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/Pointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hardPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hardPointer";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "delegatingPointer";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "uroborosPointer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hardPointerWithEquality";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

