/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertiesComponent {
    public abstract void unsetValue(@NonNls @NotNull String var1);

    public abstract boolean isValueSet(@NonNls @NotNull String var1);

    @Nullable
    @NonNls
    public abstract String getValue(@NonNls @NotNull String var1);

    public abstract void setValue(@NonNls @NotNull String var1, @NonNls @Nullable String var2);

    public abstract void setValue(@NonNls @NotNull String var1, @NonNls @Nullable String var2, @Nullable String var3);

    public abstract void setValue(@NonNls @NotNull String var1, float var2, float var3);

    public abstract void setValue(@NonNls @NotNull String var1, int var2, int var3);

    public final void setValue(@NonNls @NotNull String name, boolean value) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(0);
        }
        this.setValue(name, value, false);
    }

    public abstract void setValue(@NonNls @NotNull String var1, boolean var2, boolean var3);

    @Deprecated
    public abstract String @Nullable [] getValues(@NonNls @NotNull String var1);

    @Deprecated
    public abstract void setValues(@NonNls @NotNull String var1, String[] var2);

    @Nullable
    public abstract List<String> getList(@NonNls @NotNull String var1);

    public abstract void setList(@NonNls @NotNull String var1, @Nullable Collection<String> var2);

    public static PropertiesComponent getInstance(@NotNull Project project) {
        if (project == null) {
            PropertiesComponent.$$$reportNull$$$0(1);
        }
        return project.getService(PropertiesComponent.class);
    }

    public static PropertiesComponent getInstance() {
        return ApplicationManager.getApplication().getService(PropertiesComponent.class);
    }

    public final boolean isTrueValue(@NonNls String name) {
        return Boolean.parseBoolean(this.getValue(name));
    }

    public final boolean getBoolean(@NonNls @NotNull String name, boolean defaultValue) {
        String value;
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(2);
        }
        return (value = this.getValue(name)) == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public final boolean getBoolean(@NonNls @NotNull String name) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(3);
        }
        return this.getBoolean(name, false);
    }

    @NotNull
    @NlsSafe
    public String getValue(@NonNls @NotNull String name, @NotNull String defaultValue) {
        String value;
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(4);
        }
        if (defaultValue == null) {
            PropertiesComponent.$$$reportNull$$$0(5);
        }
        String string2 = (value = this.getValue(name)) == null ? defaultValue : value;
        if (string2 == null) {
            PropertiesComponent.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public final int getOrInitInt(@NonNls @NotNull String name, int defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(7);
        }
        return this.getInt(name, defaultValue);
    }

    public int getInt(@NonNls @NotNull String name, int defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(8);
        }
        return StringUtilRt.parseInt((String)this.getValue(name), (int)defaultValue);
    }

    public long getLong(@NonNls @NotNull String name, long defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(9);
        }
        return StringUtilRt.parseLong((String)this.getValue(name), (long)defaultValue);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public final long getOrInitLong(@NonNls @NotNull String name, long defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(10);
        }
        return this.getLong(name, defaultValue);
    }

    public final boolean saveFields(@NotNull Object object) {
        if (object == null) {
            PropertiesComponent.$$$reportNull$$$0(11);
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation = field.getAnnotation(PropertyName.class);
                if (annotation == null) continue;
                String name = annotation.value();
                this.setValue(name, String.valueOf(field.get(object)));
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public final boolean loadFields(@NotNull Object object) {
        if (object == null) {
            PropertiesComponent.$$$reportNull$$$0(12);
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation = field.getAnnotation(PropertyName.class);
                if (annotation == null) continue;
                Class<?> type = field.getType();
                String defaultValue = annotation.defaultValue();
                if ("".equals(defaultValue)) {
                    if (type.equals(Boolean.TYPE)) {
                        defaultValue = String.valueOf(field.getBoolean(object));
                    } else if (type.equals(Long.TYPE)) {
                        defaultValue = String.valueOf(field.getLong(object));
                    } else if (type.equals(Integer.TYPE)) {
                        defaultValue = String.valueOf(field.getInt(object));
                    } else if (type.equals(Short.TYPE)) {
                        defaultValue = String.valueOf(field.getShort(object));
                    } else if (type.equals(Byte.TYPE)) {
                        defaultValue = String.valueOf(field.getByte(object));
                    } else if (type.equals(Double.TYPE)) {
                        defaultValue = String.valueOf(field.getDouble(object));
                    } else if (type.equals(Float.TYPE)) {
                        defaultValue = String.valueOf(field.getFloat(object));
                    } else if (type.equals(String.class)) {
                        defaultValue = String.valueOf(field.get(object));
                    }
                }
                String stringValue = this.getValue(annotation.value(), defaultValue);
                Object value = null;
                if (type.equals(Boolean.TYPE)) {
                    value = Boolean.valueOf(stringValue);
                } else if (type.equals(Long.TYPE)) {
                    value = Long.parseLong(stringValue);
                } else if (type.equals(Integer.TYPE)) {
                    value = Integer.parseInt(stringValue);
                } else if (type.equals(Short.TYPE)) {
                    value = Short.parseShort(stringValue);
                } else if (type.equals(Byte.TYPE)) {
                    value = Byte.parseByte(stringValue);
                } else if (type.equals(Double.TYPE)) {
                    value = Double.parseDouble(stringValue);
                } else if (type.equals(Float.TYPE)) {
                    value = Float.valueOf(Float.parseFloat(stringValue));
                } else if (type.equals(String.class)) {
                    value = stringValue;
                }
                if (value == null) continue;
                field.set(object, value);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public float getFloat(@NonNls @NotNull String name, float defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(13);
        }
        if (this.isValueSet(name)) {
            try {
                String value = this.getValue(name);
                if (value != null) {
                    return Float.parseFloat(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PropertiesComponent";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PropertiesComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitInt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLong";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitLong";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveFields";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFloat";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

