/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

abstract class ChangeDiffIterableBase
implements DiffIterable {
    private final int myLength1;
    private final int myLength2;

    ChangeDiffIterableBase(int length1, int length2) {
        this.myLength1 = length1;
        this.myLength2 = length2;
    }

    @Override
    public int getLength1() {
        return this.myLength1;
    }

    @Override
    public int getLength2() {
        return this.myLength2;
    }

    @Override
    @NotNull
    public Iterator<Range> changes() {
        return new ChangedIterator(this.createChangeIterable());
    }

    @Override
    @NotNull
    public Iterator<Range> unchanged() {
        return new UnchangedIterator(this.createChangeIterable(), this.myLength1, this.myLength2);
    }

    @NotNull
    protected abstract ChangeIterable createChangeIterable();

    protected static interface ChangeIterable {
        public boolean valid();

        public void next();

        public int getStart1();

        public int getStart2();

        public int getEnd1();

        public int getEnd2();
    }

    private static final class UnchangedIterator
    implements Iterator<Range> {
        @NotNull
        private final ChangeIterable myIterable;
        private final int myLength1;
        private final int myLength2;
        private int lastIndex1;
        private int lastIndex2;

        private UnchangedIterator(@NotNull ChangeIterable iterable, int length1, int length2) {
            if (iterable == null) {
                UnchangedIterator.$$$reportNull$$$0(0);
            }
            this.lastIndex1 = 0;
            this.lastIndex2 = 0;
            this.myIterable = iterable;
            this.myLength1 = length1;
            this.myLength2 = length2;
            if (this.myIterable.valid() && this.myIterable.getStart1() == 0 && this.myIterable.getStart2() == 0) {
                this.lastIndex1 = this.myIterable.getEnd1();
                this.lastIndex2 = this.myIterable.getEnd2();
                this.myIterable.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.myIterable.valid() || this.lastIndex1 != this.myLength1 || this.lastIndex2 != this.myLength2;
        }

        @Override
        public Range next() {
            if (this.myIterable.valid()) {
                assert (this.myIterable.getStart1() - this.lastIndex1 != 0 || this.myIterable.getStart2() - this.lastIndex2 != 0);
                Range chunk = new Range(this.lastIndex1, this.myIterable.getStart1(), this.lastIndex2, this.myIterable.getStart2());
                this.lastIndex1 = this.myIterable.getEnd1();
                this.lastIndex2 = this.myIterable.getEnd2();
                this.myIterable.next();
                return chunk;
            }
            assert (this.myLength1 - this.lastIndex1 != 0 || this.myLength2 - this.lastIndex2 != 0);
            Range chunk = new Range(this.lastIndex1, this.myLength1, this.lastIndex2, this.myLength2);
            this.lastIndex1 = this.myLength1;
            this.lastIndex2 = this.myLength2;
            return chunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/ChangeDiffIterableBase$UnchangedIterator", "<init>"));
        }
    }

    private static final class ChangedIterator
    implements Iterator<Range> {
        @NotNull
        private final ChangeIterable myIterable;

        private ChangedIterator(@NotNull ChangeIterable iterable) {
            if (iterable == null) {
                ChangedIterator.$$$reportNull$$$0(0);
            }
            this.myIterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.myIterable.valid();
        }

        @Override
        public Range next() {
            Range range = new Range(this.myIterable.getStart1(), this.myIterable.getEnd1(), this.myIterable.getStart2(), this.myIterable.getEnd2());
            this.myIterable.next();
            return range;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangedIterator", "<init>"));
        }
    }
}

