/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogUtil;
import git4idea.ui.StashInfo;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a2\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createStashHandler", "Lgit4idea/commands/GitLineHandler;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "keepIndex", "", "message", "", "createUnstashHandler", "stash", "Lgit4idea/ui/StashInfo;", "branch", "popStash", "reinstateIndex", "loadStashStack", "", "", "consumer", "Lcom/intellij/util/Consumer;", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
public final class GitStashUtils {
    private static final Logger LOG;

    @Deprecated(message="use the simpler overloading method which returns a list")
    @ApiStatus.ScheduledForRemoval
    public static final void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<StashInfo> consumer2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        for (StashInfo stash : GitStashUtils.loadStashStack(project, root)) {
            consumer2.consume((Object)stash);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StashInfo> loadStashStack(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR, GitLogParser.GitLogOption.SUBJECT};
        Iterable $this$associate$iv = ArraysKt.withIndex((Object[])options);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = new Pair(it.getValue(), (Object)it.getIndex());
            map2.put(it.getFirst(), it.getSecond());
        }
        Map indexedOptions = destination$iv$iv;
        Charset charset = Charset.forName(GitConfigUtil.getLogEncoding(project, root));
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h2.setSilent(true);
        h2.addParameters("list", "--pretty=format:" + GitLogParser.makeFormatFromOptions(options, ":"));
        h2.setCharset(charset);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(h2);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().runCommand(h)");
        GitCommandResult output = gitCommandResult;
        output.throwOnError(new int[0]);
        List result2 = new ArrayList();
        Iterator<String> iterator = output.getOutput().iterator();
        while (iterator.hasNext()) {
            Hash hash;
            String string;
            void $this$mapTo$iv$iv;
            String line;
            String string2 = line = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"line");
            List parts = StringsKt.split$default((CharSequence)string2, (char[])new char[]{':'}, (boolean)false, (int)(options.length + 1), (int)2, null);
            if (parts.size() < options.length) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Can't parse stash record: " + line);
                continue;
            }
            List parents = StringsKt.split$default((CharSequence)((CharSequence)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.PARENTS))).intValue())), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
            if (parents.isEmpty()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Can't parse stash record parents: " + line);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)((String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.HASH))).intValue()))), (String)"HashImpl.build(parts[ind\u2026alue(GitLogOption.HASH)])");
            Iterable $this$map$iv = parents.subList(1, parents.size());
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Hash hash2 = HashImpl.build((String)it);
                collection.add(hash2);
            }
            List parentHashes = (List)destination$iv$iv2;
            long authorTime = GitLogUtil.parseTime((String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.AUTHOR_TIME))).intValue()));
            String stash = (String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR))).intValue());
            if (parts.size() == options.length) {
                string = null;
            } else {
                String $i$f$mapTo2 = (String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.SUBJECT))).intValue());
                string = ((Object)StringsKt.trim((CharSequence)$i$f$mapTo2)).toString();
            }
            String branch = string;
            String string4 = (String)CollectionsKt.last((List)parts);
            String message = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            result2.add(new StashInfo(root, hash, parentHashes, authorTime, stash, branch, message));
        }
        return result2;
    }

    @NotNull
    public static final GitLineHandler createStashHandler(@NotNull Project project, @NotNull VirtualFile root, boolean keepIndex, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.STASH);
        handler.addParameters("save");
        if (keepIndex) {
            handler.addParameters("--keep-index");
        }
        CharSequence charSequence = message;
        String msg = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        if ((charSequence = (CharSequence)msg).length() > 0) {
            handler.addParameters(msg);
        }
        return handler;
    }

    public static /* synthetic */ GitLineHandler createStashHandler$default(Project project, VirtualFile virtualFile, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        return GitStashUtils.createStashHandler(project, virtualFile, bl, string);
    }

    private static final GitLineHandler createUnstashHandler(Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        GitLineHandler h2 = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        CharSequence charSequence = branch;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            h2.addParameters(popStash ? "pop" : "apply");
            if (reinstateIndex) {
                h2.addParameters("--index");
            }
        } else {
            h2.addParameters("branch", branch);
        }
        h2.addParameters(stash.getStash());
        return h2;
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.stash.GitStashUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#git\u2026dea.stash.GitStashUtils\")");
        LOG = logger;
    }

    public static final /* synthetic */ GitLineHandler access$createUnstashHandler(Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        return GitStashUtils.createUnstashHandler(project, stash, branch, popStash, reinstateIndex);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

