/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitAbortRebaseProcess;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRebaseUtils {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUtils.class.getName());

    private GitRebaseUtils() {
    }

    public static void rebase(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitRebaseParams params, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitRebaseUtils.$$$reportNull$$$0(1);
        }
        if (params == null) {
            GitRebaseUtils.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(3);
        }
        if (!GitRebaseUtils.isRebaseAllowed(project, repositories)) {
            return;
        }
        new GitRebaseProcess(project, GitRebaseSpec.forNewRebase(project, params, repositories, indicator), null).rebase();
    }

    public static void continueRebase(@NotNull Project project) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(4);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            GitRebaseUtils.notifyContinueFailed(project, "continue");
        }
    }

    public static void continueRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(7);
        }
        if ((spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator)) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            GitRebaseUtils.notifyContinueFailed(project, "continue");
        }
    }

    public static void skipRebase(@NotNull Project project) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(8);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            GitRebaseUtils.notifyContinueFailed(project, "skip");
        }
    }

    public static void skipRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(11);
        }
        if ((spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator)) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            GitRebaseUtils.notifyContinueFailed(project, "skip");
        }
    }

    private static void notifyContinueFailed(@NotNull Project project, @NotNull @NonNls String action) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(12);
        }
        if (action == null) {
            GitRebaseUtils.$$$reportNull$$$0(13);
        }
        LOG.warn(String.format("Refusing to %s: no rebase spec", action));
        VcsNotifier.getInstance((Project)project).notifyError("git.rebase.cannot.continue", GitBundle.message("rebase.notification.no.rebase.in.progress.continue.title", new Object[0]), GitBundle.message("rebase.notification.no.rebase.in.progress.message", new Object[0]), true);
    }

    public static void abort(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(15);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitAbortRebaseProcess(project, spec.getOngoingRebase(), spec.getHeadPositionsToRollback(), spec.getInitialBranchNames(), indicator, spec.getSaver(), true).abortWithConfirmation();
        } else {
            LOG.warn("Refusing to abort: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("git.rebase.cannot.abort", GitBundle.message("rebase.notification.no.rebase.in.progress.abort.title", new Object[0]), GitBundle.message("rebase.notification.no.rebase.in.progress.message", new Object[0]), true);
        }
    }

    public static void abort(@NotNull Project project, @Nullable GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(17);
        }
        new GitAbortRebaseProcess(project, repository, Collections.emptyMap(), Collections.emptyMap(), indicator, null, true).abortWithConfirmation();
    }

    private static boolean isRebaseAllowed(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(18);
        }
        if (repositories == null) {
            GitRebaseUtils.$$$reportNull$$$0(19);
        }
        for (GitRepository gitRepository : repositories) {
            Repository.State state = gitRepository.getState();
            String repositoryName = DvcsUtil.getShortRepositoryName((Repository)gitRepository);
            String message = null;
            switch (state) {
                case NORMAL: {
                    if (!gitRepository.isFresh()) break;
                    message = GitBundle.message("rebase.notification.not.allowed.empty.repository.message", repositoryName);
                    break;
                }
                case MERGING: {
                    message = new HtmlBuilder().append(GitBundle.message("rebase.notification.not.allowed.merging.message.first", repositoryName)).br().append(GitBundle.message("rebase.notification.not.allowed.merging.message.second", new Object[0])).toString();
                    break;
                }
                case REBASING: {
                    message = new HtmlBuilder().append(GitBundle.message("rebase.notification.not.allowed.rebasing.message.first", repositoryName)).br().append(GitBundle.message("rebase.notification.not.allowed.rebasing.message.second", new Object[0])).toString();
                    break;
                }
                case GRAFTING: {
                    message = new HtmlBuilder().append(GitBundle.message("rebase.notification.not.allowed.grafting.message.first", repositoryName)).br().append(GitBundle.message("rebase.notification.not.allowed.grafting.message.second", new Object[0])).toString();
                    break;
                }
                case REVERTING: {
                    message = new HtmlBuilder().append(GitBundle.message("rebase.notification.not.allowed.reverting.message.first", repositoryName)).br().append(GitBundle.message("rebase.notification.not.allowed.reverting.message.second", new Object[0])).toString();
                    break;
                }
                case DETACHED: {
                    message = new HtmlBuilder().append(GitBundle.message("rebase.notification.not.allowed.detached.message.first", repositoryName)).br().append(GitBundle.message("rebase.notification.not.allowed.detached.message.second", new Object[0])).toString();
                    break;
                }
                default: {
                    LOG.error("Unknown state [" + state.name() + "]");
                    message = GitBundle.message("rebase.notification.not.allowed.message", repositoryName);
                }
            }
            if (message == null) continue;
            VcsNotifier.getInstance((Project)project).notifyError("git.rebase.not.allowed", GitBundle.message("rebase.notification.not.allowed.title", new Object[0]), message);
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public static boolean isRebaseInTheProgress(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(21);
        }
        return GitRebaseUtils.getRebaseDir(project, root) != null;
    }

    @Nullable
    public static File getRebaseDir(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(22);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(23);
        }
        if ((repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRootQuick(root)) == null) {
            return null;
        }
        File f = repository.getRepositoryFiles().getRebaseApplyDir();
        if (f.exists()) {
            return f;
        }
        f = repository.getRepositoryFiles().getRebaseMergeDir();
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static boolean isInteractiveRebaseInProgress(@NotNull GitRepository repository) {
        File rebaseDir;
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(24);
        }
        return (rebaseDir = GitRebaseUtils.getRebaseDir(repository.getProject(), repository.getRoot())) != null && new File(rebaseDir, "interactive").exists();
    }

    @Nullable
    public static CommitInfo getCurrentRebaseCommit(@NotNull Project project, @NotNull VirtualFile root) {
        int next;
        File rebaseDir;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(25);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(26);
        }
        if ((rebaseDir = GitRebaseUtils.getRebaseDir(project, root)) == null) {
            LOG.warn("No rebase dir found for " + root.getPath());
            return null;
        }
        File nextFile = new File(rebaseDir, "next");
        try {
            next = Integer.parseInt(FileUtil.loadFile((File)nextFile, (Charset)StandardCharsets.UTF_8).trim());
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + nextFile.getPath(), (Throwable)e);
            return null;
        }
        File commitFile = new File(rebaseDir, String.format("%04d", next));
        String hash = null;
        String subject = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commitFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("From ")) {
                    hash = line.substring(5, 45);
                }
                if (line.startsWith("Subject: ")) {
                    subject = line.substring("Subject: ".length());
                }
                if (hash == null || subject == null) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + commitFile, (Throwable)e);
            return null;
        }
        if (subject == null || hash == null) {
            LOG.info("Unable to extract information from " + commitFile + " " + hash + ": " + subject);
            return null;
        }
        return new CommitInfo(new GitRevisionNumber(hash), subject);
    }

    @NotNull
    @Nls
    static String mentionLocalChangesRemainingInStash(@Nullable GitChangesSaver saver) {
        if (saver == null || !saver.wereChangesSaved()) {
            return "";
        }
        String string = new HtmlBuilder().br().append(saver.getSaveMethod().selectBundleMessage(GitBundle.message("rebase.notification.saved.local.changes.part.stash.text", new Object[0]), GitBundle.message("rebase.notification.saved.local.changes.part.shelf.text", new Object[0]))).toString();
        if (string == null) {
            GitRebaseUtils.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static Collection<GitRepository> getRebasingRepositories(@NotNull Project project) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(28);
        }
        Collection<GitRepository> collection = GitUtil.getRepositoriesInState(project, Repository.State.REBASING);
        if (collection == null) {
            GitRebaseUtils.$$$reportNull$$$0(29);
        }
        return collection;
    }

    public static int getNumberOfCommitsToRebase(@NotNull GitRepository repository, @Nullable String upstream, @Nullable String branch) throws VcsException {
        String rebasingBranch;
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(30);
        }
        if ((rebasingBranch = branch) == null) {
            rebasingBranch = repository.isRebaseInProgress() ? GitRebaseUtils.getRebasingBranchHash(repository).asString() : "HEAD";
        }
        return GitHistoryUtils.collectTimedCommits(repository.getProject(), repository.getRoot(), GitRebaseUtils.getCommitsRangeToRebase(upstream, rebasingBranch)).size();
    }

    @NotNull
    private static Hash getRebasingBranchHash(@NotNull GitRepository repository) throws VcsException {
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(31);
        }
        return GitRebaseUtils.readHashFromFile(repository.getProject(), repository.getRoot(), "orig-head");
    }

    @Nullable
    public static Hash getOntoHash(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(32);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(33);
        }
        try {
            return GitRebaseUtils.readHashFromFile(project, root, "onto");
        }
        catch (VcsException e) {
            return null;
        }
    }

    @NotNull
    public static String getCommitsRangeToRebase(@Nullable String baseBranch, @NotNull String rebasingBranch) {
        if (rebasingBranch == null) {
            GitRebaseUtils.$$$reportNull$$$0(34);
        }
        if (baseBranch == null) {
            String string = rebasingBranch;
            if (string == null) {
                GitRebaseUtils.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = baseBranch + ".." + rebasingBranch;
        if (string == null) {
            GitRebaseUtils.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static Hash readHashFromFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String fileName) throws VcsException {
        Hash hash;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(37);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(38);
        }
        if (fileName == null) {
            GitRebaseUtils.$$$reportNull$$$0(39);
        }
        try {
            hash = HashImpl.build((String)FileUtil.loadFile((File)new File(GitRebaseUtils.getRebaseDir(project, root), fileName)).trim());
        }
        catch (IOException e) {
            throw new VcsException(GitBundle.message("rebase.couldnt.resolve.file", fileName), (Throwable)e);
        }
        if (hash == null) {
            GitRebaseUtils.$$$reportNull$$$0(40);
        }
        return hash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 10: 
            case 24: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseUtils";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebasingBranch";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseUtils";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "mentionLocalChangesRemainingInStash";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebasingRepositories";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsRangeToRebase";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "continueRebase";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipRebase";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notifyContinueFailed";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "abort";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseAllowed";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseInTheProgress";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRebaseDir";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveRebaseInProgress";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRebaseCommit";
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 40: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRebasingRepositories";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNumberOfCommitsToRebase";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRebasingBranchHash";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOntoHash";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsRangeToRebase";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readHashFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommitInfo {
        public final GitRevisionNumber revision;
        public final String subject;

        public CommitInfo(GitRevisionNumber revision, String subject) {
            this.revision = revision;
            this.subject = subject;
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

