/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.OpenSourceUtil;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageLineStatusTracker;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/index/actions/GitStageShowVersionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "showStaged", "", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getTargetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetFile", "caret", "Lcom/intellij/openapi/editor/Caret;", "update", "intellij.vcs.git"})
public abstract class GitStageShowVersionAction
extends DumbAwareAction {
    private final boolean showStaged;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file == null || file instanceof GitIndexVirtualFile == this.showStaged) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(status != null);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        GitFileStatus gitFileStatus = status;
        presentation2.setEnabled(gitFileStatus != null && GitFileStatusKt.has(gitFileStatus, this.showStaged ? ContentVersion.STAGED : ContentVersion.LOCAL));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
        Project project2 = project;
        Object object = e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.VIRTUAL_FILE)");
        VirtualFile sourceFile = (VirtualFile)object;
        VirtualFile virtualFile = GitStageTrackerKt.getRoot(project2, sourceFile);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = this.showStaged ? (VirtualFile)GitIndexFileSystemRefresher.Companion.getInstance(project2).getFile(root, GitIndexVirtualFileKt.filePath(sourceFile)) : GitIndexVirtualFileKt.filePath(sourceFile).getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"if (showStaged) {\n      \u2026rtualFile\n    } ?: return");
        VirtualFile targetFile = virtualFile2;
        Caret caret = (Caret)e.getData(CommonDataKeys.CARET);
        if (caret == null) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)new OpenFileDescriptor(project2, targetFile)});
            return;
        }
        LogicalPosition targetPosition = this.getTargetPosition(project2, sourceFile, targetFile, caret);
        OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)new OpenFileDescriptor(project2, targetFile, targetPosition.line, targetPosition.column)});
    }

    private final LogicalPosition getTargetPosition(Project project, VirtualFile sourceFile, VirtualFile targetFile, Caret caret) {
        LineStatusTracker lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(this.showStaged ? sourceFile : targetFile);
        if (lineStatusTracker == null) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"caret.logicalPosition");
            return logicalPosition;
        }
        Intrinsics.checkNotNullExpressionValue((Object)lineStatusTracker, (String)"LineStatusTrackerManager\u2026urn caret.logicalPosition");
        LineStatusTracker lst = lineStatusTracker;
        if (!(lst instanceof GitStageLineStatusTracker)) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"caret.logicalPosition");
            return logicalPosition;
        }
        int line = this.showStaged ? ((GitStageLineStatusTracker)lst).transferLineFromLocalToStaged(caret.getLogicalPosition().line, true) : ((GitStageLineStatusTracker)lst).transferLineFromStagedToLocal(caret.getLogicalPosition().line, true);
        return new LogicalPosition(line, caret.getLogicalPosition().column);
    }

    public GitStageShowVersionAction(boolean showStaged) {
        this.showStaged = showStaged;
    }
}

