/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.i18n.GitBundle;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitFileStatusNodeProducerBase;
import git4idea.index.GitIndexUtil;
import git4idea.index.GitStageDiffUtilKt$WhenMappings;
import git4idea.index.HeadContentRevision;
import git4idea.index.KindTag;
import git4idea.index.MergedProducer;
import git4idea.index.StagedContentRevision;
import git4idea.index.StagedDiffRequest;
import git4idea.index.StagedProducer;
import git4idea.index.ThreeSidesProducer;
import git4idea.index.UnStagedProducer;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.NodeKind;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0003\u001a \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010 \u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010!\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\"\u001a\u00020#*\u00020\u00152\u0006\u0010$\u001a\u00020\rH\u0002\u00a8\u0006%"}, d2={"compareHeadWithStaged", "Lcom/intellij/diff/requests/DiffRequest;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lgit4idea/index/GitFileStatus;", "compareStagedWithLocal", "compareThreeVersions", "createChange", "Lcom/intellij/openapi/vcs/changes/Change;", "beforeVersion", "Lgit4idea/index/ContentVersion;", "afterVersion", "createContentRevision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "version", "createThreeSidesDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "statusNode", "Lgit4idea/index/ui/GitFileStatusNode;", "createTwoSidesDiffRequestProducer", "getTitle", "", "kind", "Lgit4idea/index/ui/NodeKind;", "headContentBytes", "", "headDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "localDiffContent", "stagedContentFile", "stagedDiffContent", "has", "", "contentVersion", "intellij.vcs.git"})
public final class GitStageDiffUtilKt {
    @Nullable
    public static final ChangeDiffRequestChain.Producer createTwoSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$0[statusNode.getKind().ordinal()]) {
            case 1: {
                producer2 = new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer2 = new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer2 = new MergedProducer(project, statusNode);
                break;
            }
            case 4: {
                producer2 = (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (ChangesBrowserNode.Tag)((ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED)));
                break;
            }
            case 5: {
                producer2 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer2;
    }

    @Nullable
    public static final ChangeDiffRequestChain.Producer createThreeSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        boolean hasThreeSides = GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD) && GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED) && GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL);
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$1[statusNode.getKind().ordinal()]) {
            case 1: {
                producer2 = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer2 = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer2 = new MergedProducer(project, statusNode);
                break;
            }
            case 4: {
                producer2 = (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (ChangesBrowserNode.Tag)((ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED)));
                break;
            }
            case 5: {
                producer2 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer2;
    }

    @Nullable
    public static final Change createChange(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status, @NotNull ContentVersion beforeVersion, @NotNull ContentVersion afterVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)((Object)beforeVersion), (String)"beforeVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)afterVersion), (String)"afterVersion");
        ContentRevision bRev = GitStageDiffUtilKt.createContentRevision(project, root, status, beforeVersion);
        ContentRevision aRev = GitStageDiffUtilKt.createContentRevision(project, root, status, afterVersion);
        return bRev != null || aRev != null ? new Change(bRev, aRev) : null;
    }

    private static final ContentRevision createContentRevision(Project project, VirtualFile root, GitFileStatus status, ContentVersion version) {
        ContentRevision contentRevision;
        if (!GitFileStatusKt.has(status, version)) {
            return null;
        }
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$2[version.ordinal()]) {
            case 1: {
                contentRevision = (ContentRevision)new HeadContentRevision(project, root, status);
                break;
            }
            case 2: {
                contentRevision = (ContentRevision)new StagedContentRevision(project, root, status);
                break;
            }
            case 3: {
                contentRevision = (ContentRevision)new CurrentContentRevision(GitFileStatusKt.path(status, version));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return contentRevision;
    }

    private static final DiffContent headDiffContent(Project project, VirtualFile root, GitFileStatus status) throws VcsException, IOException {
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadSubmoduleHashAt(submodule.getRepository(), submodule.getParent(), (VcsRevisionNumber)GitRevisionNumber.HEAD);
            if (hash == null) {
                throw (Throwable)new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.loadSubmodu\u2026.load.revision.content\"))");
            Hash hash2 = hash;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, hash2.asString());
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026project, hash.asString())");
            return (DiffContent)documentContent;
        }
        byte[] headContent = GitStageDiffUtilKt.headContentBytes(project, root, status);
        DiffContent diffContent = DiffContentFactoryEx.getInstanceEx().createFromBytes(project, headContent, status.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactoryEx.get\u2026headContent, status.path)");
        return diffContent;
    }

    private static final DiffContent stagedDiffContent(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        if (!GitFileStatusKt.has(status, ContentVersion.STAGED)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadStagedSubmoduleHash(submodule.getRepository(), submodule.getParent());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.loadStagedS\u2026sitory, submodule.parent)");
            Hash hash2 = hash;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, hash2.asString());
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026project, hash.asString())");
            return (DiffContent)documentContent;
        }
        VirtualFile indexFile = GitStageDiffUtilKt.stagedContentFile(project, root, status);
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, indexFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, indexFile)");
        return diffContent;
    }

    private static final DiffContent localDiffContent(Project project, GitFileStatus status) throws VcsException {
        if (!GitFileStatusKt.has(status, ContentVersion.LOCAL)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            String string = submodule.getRepository().getCurrentRevision();
            if (string == null) {
                throw (Throwable)new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"submodule.repository.cur\u2026.load.revision.content\"))");
            String revision = string;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, revision);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026create(project, revision)");
            return (DiffContent)documentContent;
        }
        VirtualFile virtualFile = GitFileStatusKt.path(status, ContentVersion.LOCAL).getVirtualFile();
        if (virtualFile == null) {
            throw (Throwable)new VcsException(GitBundle.message("stage.diff.local.content.exception.message", status.getPath()));
        }
        VirtualFile localFile = virtualFile;
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, localFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, localFile)");
        return diffContent;
    }

    private static final byte[] headContentBytes(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        byte[] byArray = GitFileUtils.getFileContent(project, root, "HEAD", VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"GitFileUtils.getFileCont\u2026tivePath(root, filePath))");
        return byArray;
    }

    private static final VirtualFile stagedContentFile(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(status, ContentVersion.STAGED);
        GitIndexVirtualFile gitIndexVirtualFile = GitIndexFileSystemRefresher.Companion.getInstance(project).getFile(root, filePath);
        if (gitIndexVirtualFile == null) {
            throw (Throwable)new VcsException(GitBundle.message("stage.diff.staged.content.exception.message", status.getPath()));
        }
        return gitIndexVirtualFile;
    }

    @NotNull
    public static final DiffRequest compareHeadWithStaged(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status) {
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        DiffContent diffContent = GitStageDiffUtilKt.headDiffContent(project, root, status);
        DiffContent diffContent2 = GitStageDiffUtilKt.stagedDiffContent(project, root, status);
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage.content.staged\")");
        StagedDiffRequest $this$apply = stagedDiffRequest = new StagedDiffRequest(diffContent, diffContent2, "HEAD", string, GitStageDiffUtilKt.getTitle(status, NodeKind.STAGED));
        boolean bl = false;
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, GitBundle.message("action.label.reset.staged.range", new Object[0]));
        return (DiffRequest)stagedDiffRequest;
    }

    @NotNull
    public static final DiffRequest compareStagedWithLocal(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status) {
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        DiffContent diffContent = GitStageDiffUtilKt.stagedDiffContent(project, root, status);
        DiffContent diffContent2 = GitStageDiffUtilKt.localDiffContent(project, status);
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage.content.staged\")");
        String string2 = GitBundle.message("stage.content.local", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"stage.content.local\")");
        StagedDiffRequest $this$apply = stagedDiffRequest = new StagedDiffRequest(diffContent, diffContent2, string, string2, GitStageDiffUtilKt.getTitle(status, NodeKind.UNSTAGED));
        boolean bl = false;
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_ACTION_TEXT, GitBundle.message("action.label.add.unstaged.range", new Object[0]));
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]));
        return (DiffRequest)stagedDiffRequest;
    }

    @NotNull
    public static final DiffRequest compareThreeVersions(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status) {
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String title = GitStageDiffUtilKt.getTitle(status);
        DiffContent diffContent = GitStageDiffUtilKt.headDiffContent(project, root, status);
        DiffContent diffContent2 = GitStageDiffUtilKt.stagedDiffContent(project, root, status);
        DiffContent diffContent3 = GitStageDiffUtilKt.localDiffContent(project, status);
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage.content.staged\")");
        String string2 = GitBundle.message("stage.content.local", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"stage.content.local\")");
        StagedDiffRequest $this$apply = stagedDiffRequest = new StagedDiffRequest(diffContent, diffContent2, diffContent3, "HEAD", string, string2, title);
        boolean bl = false;
        $this$apply.putUserData(DiffUserDataKeys.THREESIDE_DIFF_COLORS_MODE, DiffUserDataKeys.ThreeSideDiffColors.LEFT_TO_RIGHT);
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_TO_BASE_ACTION_TEXT, GitBundle.message("action.label.add.unstaged.range", new Object[0]));
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_RIGHT_ACTION_TEXT, DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]));
        $this$apply.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_TO_BASE_ACTION_TEXT, GitBundle.message("action.label.reset.staged.range", new Object[0]));
        return (DiffRequest)stagedDiffRequest;
    }

    private static final boolean has(GitFileStatusNode $this$has, ContentVersion contentVersion) {
        return GitFileStatusKt.has($this$has.getStatus(), contentVersion);
    }

    @Nls
    private static final String getTitle(GitFileStatus status, NodeKind kind) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)status.getPath(), (FilePath)kind.origPath(status), (String)" -> ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    @Nls
    private static final String getTitle(GitFileStatus status) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)status.getPath(), (FilePath)status.getOrigPath(), (String)" -> ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatus status, NodeKind kind) {
        return GitStageDiffUtilKt.getTitle(status, kind);
    }

    public static final /* synthetic */ byte[] access$headContentBytes(Project project, VirtualFile root, GitFileStatus status) {
        return GitStageDiffUtilKt.headContentBytes(project, root, status);
    }

    public static final /* synthetic */ VirtualFile access$stagedContentFile(Project project, VirtualFile root, GitFileStatus status) {
        return GitStageDiffUtilKt.stagedContentFile(project, root, status);
    }
}

