/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import git4idea.GitFormatException;
import git4idea.GitUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.DefaultGitLogRecordBuilder;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordBuilder;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GitLogParser<R extends GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogParser.class);
    static final String RECORD_START = "\u0001\u0001";
    static final String ITEMS_SEPARATOR = "\u0002\u0002";
    static final String RECORD_END = "\u0003\u0003";
    private static final int MAX_SEPARATOR_LENGTH = 10;
    private static final char[] CONTROL_CHARS = new char[]{'\u0001', '\u0002', '\u0003'};
    private static final int INPUT_ERROR_MESSAGE_HEAD_LIMIT = 1000000;
    private static final int INPUT_ERROR_MESSAGE_TAIL_LIMIT = 100;
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger();
    private final boolean mySupportsRawBody;
    @NotNull
    private final String myPretty;
    @NotNull
    private final OptionsParser myOptionsParser;
    @NotNull
    private final PathsParser<R> myPathsParser;
    @NotNull
    private final GitLogRecordBuilder<R> myRecordBuilder;
    private final String myRecordStart;
    private final String myRecordEnd;
    private final String myItemsSeparator;
    private boolean myIsInBody;

    private GitLogParser(@NotNull GitLogRecordBuilder<R> recordBuilder, boolean supportsRawBody, @NotNull NameStatus nameStatusOption, GitLogOption ... options) {
        if (recordBuilder == null) {
            GitLogParser.$$$reportNull$$$0(0);
        }
        if (nameStatusOption == null) {
            GitLogParser.$$$reportNull$$$0(1);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(2);
        }
        this.myIsInBody = true;
        this.mySupportsRawBody = supportsRawBody;
        this.myRecordBuilder = recordBuilder;
        this.myRecordStart = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", RECORD_START}, (String)GitLogParser.generateRandomSequence());
        this.myRecordEnd = RECORD_END + GitLogParser.generateRandomSequence();
        this.myItemsSeparator = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", ITEMS_SEPARATOR}, (String)GitLogParser.generateRandomSequence());
        this.myPretty = "--pretty=format:" + this.makeFormatFromOptions(options);
        this.myOptionsParser = new OptionsParser(options);
        this.myPathsParser = new MyPathsParser(nameStatusOption);
    }

    public GitLogParser(@NotNull Project project, @NotNull GitLogRecordBuilder<R> recordBuilder, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        if (project == null) {
            GitLogParser.$$$reportNull$$$0(3);
        }
        if (recordBuilder == null) {
            GitLogParser.$$$reportNull$$$0(4);
        }
        if (nameStatus == null) {
            GitLogParser.$$$reportNull$$$0(5);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(6);
        }
        this(recordBuilder, GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(project), nameStatus, options);
    }

    @NotNull
    public static GitLogParser<GitLogFullRecord> createDefaultParser(@NotNull Project project, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        if (project == null) {
            GitLogParser.$$$reportNull$$$0(7);
        }
        if (nameStatus == null) {
            GitLogParser.$$$reportNull$$$0(8);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(9);
        }
        return new GitLogParser<GitLogFullRecord>(project, new DefaultGitLogFullRecordBuilder(), nameStatus, options);
    }

    @NotNull
    public static GitLogParser<GitLogRecord> createDefaultParser(@NotNull Project project, GitLogOption ... options) {
        if (project == null) {
            GitLogParser.$$$reportNull$$$0(10);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(11);
        }
        return new GitLogParser<GitLogRecord>(project, new DefaultGitLogRecordBuilder(), NameStatus.NONE, options);
    }

    @NotNull
    public List<R> parse(@NotNull CharSequence output) {
        if (output == null) {
            GitLogParser.$$$reportNull$$$0(12);
        }
        ArrayList<R> result2 = new ArrayList<R>();
        List lines = StringUtil.split((CharSequence)output, (CharSequence)"\n", (boolean)true, (boolean)false);
        for (CharSequence line : lines) {
            try {
                R record = this.parseLine(line);
                if (record == null) continue;
                result2.add(record);
            }
            catch (GitFormatException e) {
                this.clear();
                LOG.error((Throwable)e);
            }
        }
        R record = this.finish();
        if (record != null) {
            result2.add(record);
        }
        ArrayList<R> arrayList = result2;
        if (arrayList == null) {
            GitLogParser.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public R parseOneRecord(@NotNull CharSequence output) {
        if (output == null) {
            GitLogParser.$$$reportNull$$$0(14);
        }
        List<R> records = this.parse(output);
        this.clear();
        if (records.isEmpty()) {
            return null;
        }
        return (R)((GitLogRecord)ContainerUtil.getFirstItem(records));
    }

    @Nullable
    public R parseLine(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(15);
        }
        if (this.myPathsParser.expectsPaths()) {
            return this.parseLineWithPaths(line);
        }
        return this.parseLineWithoutPaths(line);
    }

    @Nullable
    private R parseLineWithPaths(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(16);
        }
        if (this.myIsInBody) {
            this.myIsInBody = !this.myOptionsParser.parseLine(line);
        } else {
            if (CharArrayUtil.regionMatches((CharSequence)line, (int)0, (CharSequence)this.myRecordStart)) {
                R record = this.createRecord();
                this.myIsInBody = !this.myOptionsParser.parseLine(line);
                return record;
            }
            this.myPathsParser.parseLine(line);
        }
        return null;
    }

    @Nullable
    private R parseLineWithoutPaths(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(17);
        }
        if (this.myOptionsParser.parseLine(line)) {
            return this.createRecord();
        }
        return null;
    }

    @Nullable
    public R finish() {
        if (this.myOptionsParser.isEmpty()) {
            return null;
        }
        return this.createRecord();
    }

    @Nullable
    private R createRecord() {
        if (this.myPathsParser.getErrorText() != null || !this.myOptionsParser.hasCompleteOptionsList()) {
            if (this.myPathsParser.getErrorText() != null) {
                LOG.debug("Creating record was skipped: " + this.myPathsParser.getErrorText());
            }
            if (!this.myOptionsParser.hasCompleteOptionsList()) {
                LOG.debug("Parsed incomplete options " + this.myOptionsParser.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptionsParser.myOptions));
            }
            this.myOptionsParser.clear();
            this.myRecordBuilder.clear();
            this.myPathsParser.clear();
            return null;
        }
        Map<GitLogOption, String> options = this.myOptionsParser.getResult();
        this.myOptionsParser.clear();
        R record = this.myRecordBuilder.build(options, this.mySupportsRawBody);
        this.myRecordBuilder.clear();
        this.myPathsParser.clear();
        this.myIsInBody = true;
        return record;
    }

    public void clear() {
        this.myOptionsParser.clear();
        this.myRecordBuilder.clear();
        this.myIsInBody = true;
    }

    @NotNull
    public String getPretty() {
        String string = this.myPretty;
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private String makeFormatFromOptions(GitLogOption @NotNull [] options) {
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(19);
        }
        String string = GitLogParser.encodeForGit(this.myRecordStart) + GitLogParser.makeFormatFromOptions(options, GitLogParser.encodeForGit(this.myItemsSeparator)) + GitLogParser.encodeForGit(this.myRecordEnd);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String makeFormatFromOptions(GitLogOption @NotNull [] options, @NotNull String separator) {
        if (separator == null) {
            GitLogParser.$$$reportNull$$$0(21);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(22);
        }
        String string = StringUtil.join((Object[])options, option -> "%" + option.getPlaceholder(), (String)separator);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String encodeForGit(@NotNull String line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(24);
        }
        StringBuilder encoded = new StringBuilder();
        line.chars().forEachOrdered(c -> encoded.append("%x").append(String.format("%02x", c)));
        String string = encoded.toString();
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String generateRandomSequence() {
        int length = ERROR_COUNT.get() % (10 - RECORD_START.length());
        StringBuilder tail = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomIndex = ThreadLocalRandom.current().nextInt(0, CONTROL_CHARS.length);
            tail.append(CONTROL_CHARS[randomIndex]);
        }
        String string = tail.toString();
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static void throwGFE(@NotNull String message, @NotNull CharSequence line) {
        if (message == null) {
            GitLogParser.$$$reportNull$$$0(27);
        }
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(28);
        }
        ERROR_COUNT.incrementAndGet();
        throw new GitFormatException(message + " [" + GitLogParser.getTruncatedEscapedOutput(line) + "]");
    }

    @NotNull
    private static String getTruncatedEscapedOutput(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(29);
        }
        String formatString = "%s...(%d more characters)...%s";
        String lineString = line.length() > 1000100 + formatString.length() ? String.format(formatString, line.subSequence(0, 1000000), line.length() - 1000000 - 100, line.subSequence(line.length() - 100, line.length())) : line.toString();
        String string = StringUtil.escapeStringCharacters((String)lineString);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStatusOption";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStatus";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogParser";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogParser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPretty";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFormatFromOptions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeForGit";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomSequence";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTruncatedEscapedOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultParser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 30: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseOneRecord";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseLineWithPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseLineWithoutPaths";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatFromOptions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "encodeForGit";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "throwGFE";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTruncatedEscapedOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PartialResult {
        @NotNull
        private List<String> myResult = new ArrayList<String>();
        @NotNull
        private final StringBuilder myCurrentItem = new StringBuilder();

        private PartialResult() {
        }

        public void append(char c) {
            this.myCurrentItem.append(c);
        }

        public void finishItem() {
            this.myResult.add(this.myCurrentItem.toString());
            this.myCurrentItem.setLength(0);
        }

        @NotNull
        public List<String> getResult() {
            List<String> list2 = this.myResult;
            if (list2 == null) {
                PartialResult.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void clear() {
            this.myCurrentItem.setLength(0);
            this.myResult = new ArrayList<String>();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty() && this.myCurrentItem.length() == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogParser$PartialResult", "getResult"));
        }
    }

    private class MyPathsParser
    extends PathsParser<R> {
        MyPathsParser(NameStatus nameStatusOption) {
            if (nameStatusOption == null) {
                MyPathsParser.$$$reportNull$$$0(0);
            }
            super(nameStatusOption, GitLogParser.this.myRecordBuilder);
        }

        @Override
        @NotNull
        protected String getErrorText(@NotNull CharSequence line) {
            if (line == null) {
                MyPathsParser.$$$reportNull$$$0(1);
            }
            String string = super.getErrorText(line) + " for record " + GitLogParser.this.myOptionsParser.myResult.getResult();
            if (string == null) {
                MyPathsParser.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameStatusOption";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitLogParser$MyPathsParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitLogParser$MyPathsParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorText";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PathsParser<R extends GitLogRecord> {
        @NotNull
        private final NameStatus myNameStatusOption;
        @NotNull
        private final GitLogRecordBuilder<R> myRecordBuilder;
        @Nullable
        private String myErrorText;

        PathsParser(@NotNull NameStatus nameStatusOption, @NotNull GitLogRecordBuilder<R> recordBuilder) {
            if (nameStatusOption == null) {
                PathsParser.$$$reportNull$$$0(0);
            }
            if (recordBuilder == null) {
                PathsParser.$$$reportNull$$$0(1);
            }
            this.myErrorText = null;
            this.myNameStatusOption = nameStatusOption;
            this.myRecordBuilder = recordBuilder;
        }

        public void parseLine(@NotNull CharSequence line) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(2);
            }
            if (line.length() == 0) {
                return;
            }
            List<String> match2 = PathsParser.parsePathsLine(line);
            if (!match2.isEmpty()) {
                if (this.myNameStatusOption != NameStatus.STATUS) {
                    GitLogParser.throwGFE("Status list not expected", line);
                }
                if (match2.size() < 2) {
                    this.myErrorText = this.getErrorText(line);
                } else if (match2.size() == 2) {
                    this.addPath(match2.get(0), match2.get(1), null);
                } else {
                    this.addPath(match2.get(0), match2.get(1), match2.get(2));
                }
            }
        }

        @NotNull
        protected String getErrorText(@NotNull CharSequence line) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(3);
            }
            String string = "Could not parse status line [" + line + "]";
            if (string == null) {
                PathsParser.$$$reportNull$$$0(4);
            }
            return string;
        }

        private void addPath(@NotNull String type, @NotNull String firstPath, @Nullable String secondPath) {
            if (type == null) {
                PathsParser.$$$reportNull$$$0(5);
            }
            if (firstPath == null) {
                PathsParser.$$$reportNull$$$0(6);
            }
            this.myRecordBuilder.addPath(GitChangesParser.getChangeType(GitChangeType.fromString(type)), PathsParser.tryUnescapePath(firstPath), PathsParser.tryUnescapePath(secondPath));
        }

        @Nullable
        @Contract(value="!null -> !null")
        private static String tryUnescapePath(@Nullable String path) {
            if (path == null) {
                return null;
            }
            try {
                return GitUtil.unescapePath(path);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return path;
            }
        }

        @NotNull
        private static List<String> parsePathsLine(@NotNull CharSequence line) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(7);
            }
            int offset = 0;
            ArrayList<String> result2 = new ArrayList<String>();
            while (offset < line.length()) {
                int tokenEnd = StringUtil.indexOf((CharSequence)line, (char)'\t', (int)offset);
                if (tokenEnd == -1) {
                    tokenEnd = line.length();
                }
                result2.add(line.subSequence(offset, tokenEnd).toString());
                offset = tokenEnd + 1;
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                PathsParser.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        public boolean expectsPaths() {
            return this.myNameStatusOption == NameStatus.STATUS;
        }

        public void clear() {
            this.myErrorText = null;
        }

        @Nullable
        public String getErrorText() {
            return this.myErrorText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameStatusOption";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordBuilder";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitLogParser$PathsParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitLogParser$PathsParser";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorText";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parsePathsLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorText";
                    break;
                }
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parsePathsLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsParser {
        private final GitLogOption @NotNull [] myOptions;
        @NotNull
        private final PartialResult myResult;

        OptionsParser(GitLogOption[] options) {
            if (options == null) {
                OptionsParser.$$$reportNull$$$0(0);
            }
            this.myResult = new PartialResult();
            this.myOptions = options;
        }

        public boolean parseLine(@NotNull CharSequence line) {
            if (line == null) {
                OptionsParser.$$$reportNull$$$0(1);
            }
            int offset = 0;
            if (this.myResult.isEmpty()) {
                if (!CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordStart)) {
                    return false;
                }
                offset += GitLogParser.this.myRecordStart.length();
            }
            while (offset < line.length()) {
                if (this.atRecordEnd(line, offset)) {
                    this.myResult.finishItem();
                    if (!this.hasCompleteOptionsList()) {
                        GitLogParser.throwGFE("Parsed incomplete options " + this.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptions), line);
                    }
                    return true;
                }
                if (CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myItemsSeparator)) {
                    this.myResult.finishItem();
                    offset += GitLogParser.this.myItemsSeparator.length();
                    continue;
                }
                char c = line.charAt(offset);
                this.myResult.append(c);
                ++offset;
            }
            this.myResult.append('\n');
            return false;
        }

        public boolean hasCompleteOptionsList() {
            return this.myResult.getResult().size() == this.myOptions.length;
        }

        private boolean atRecordEnd(@NotNull CharSequence line, int offset) {
            if (line == null) {
                OptionsParser.$$$reportNull$$$0(2);
            }
            return offset == line.length() - GitLogParser.this.myRecordEnd.length() && CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordEnd);
        }

        @NotNull
        public Map<GitLogOption, String> getResult() {
            return this.createOptions(this.myResult.getResult());
        }

        @NotNull
        private Map<GitLogOption, String> createOptions(@NotNull List<String> options) {
            if (options == null) {
                OptionsParser.$$$reportNull$$$0(3);
            }
            HashMap<GitLogOption, String> optionsMap = new HashMap<GitLogOption, String>(options.size());
            for (int index = 0; index < options.size(); ++index) {
                optionsMap.put(this.myOptions[index], options.get(index));
            }
            HashMap<GitLogOption, String> hashMap = optionsMap;
            if (hashMap == null) {
                OptionsParser.$$$reportNull$$$0(4);
            }
            return hashMap;
        }

        public void clear() {
            this.myResult.clear();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitLogParser$OptionsParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitLogParser$OptionsParser";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parseLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "atRecordEnd";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createOptions";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static enum GitLogOption {
        HASH("H"),
        TREE("T"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private final String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        @NonNls
        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        STATUS;

    }
}

