/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitLineHandlerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMessageWithFilesDetector
implements GitLineHandlerListener {
    private static final Logger LOG = Logger.getInstance(GitMessageWithFilesDetector.class);
    @NotNull
    private final Event myEvent;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    protected final Set<String> myAffectedFiles;
    protected boolean myMessageDetected;
    @Nullable
    private Key myMessageOutputType;

    public GitMessageWithFilesDetector(@NotNull Event event, @NotNull VirtualFile root) {
        if (event == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(1);
        }
        this.myAffectedFiles = new HashSet<String>();
        this.myEvent = event;
        this.myRoot = root;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(3);
        }
        if (line.contains(this.myEvent.messageStartMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message start marker detected in [" + line + "]of type " + outputType);
            this.myMessageDetected = true;
            this.myMessageOutputType = outputType;
        } else if (line.contains(this.myEvent.messageEndMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message end marker detected in [" + line + "]of type " + outputType);
            this.myMessageOutputType = null;
        } else if (outputType.equals((Object)this.myMessageOutputType)) {
            LOG.debug("|" + this.myEvent.name + "| Treating as a file: [" + line + "]of type " + outputType);
            this.myAffectedFiles.add(line.trim());
        } else {
            LOG.debug("|" + this.myEvent.name + "| Plain message: [" + line + "]of type " + outputType);
        }
    }

    public boolean wasMessageDetected() {
        return this.myMessageDetected;
    }

    @NotNull
    public Set<String> getRelativeFilePaths() {
        Set<String> set = this.myAffectedFiles;
        if (set == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myAffectedFiles.size());
        for (String affectedFile : this.myAffectedFiles) {
            VirtualFile file = this.myRoot.findFileByRelativePath(FileUtil.toSystemIndependentName((String)affectedFile));
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            GitMessageWithFilesDetector.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitMessageWithFilesDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitMessageWithFilesDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFilePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onLineAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Event {
        @NotNull
        @NonNls
        private final String name;
        @NotNull
        @NonNls
        private final String messageStartMarker;
        @NotNull
        @NonNls
        private final String messageEndMarker;

        Event(@NotNull @NonNls String eventName, @NotNull @NonNls String messageStartMarker, @NotNull @NonNls String messageEndMarker) {
            if (eventName == null) {
                Event.$$$reportNull$$$0(0);
            }
            if (messageStartMarker == null) {
                Event.$$$reportNull$$$0(1);
            }
            if (messageEndMarker == null) {
                Event.$$$reportNull$$$0(2);
            }
            this.name = eventName;
            this.messageStartMarker = messageStartMarker;
            this.messageEndMarker = messageEndMarker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "eventName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageStartMarker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageEndMarker";
                    break;
                }
            }
            objectArray[1] = "git4idea/commands/GitMessageWithFilesDetector$Event";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

