/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.branch.GitCompareUtilKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0003>?@B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J0\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0002J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0007J4\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010/\u001a\u00020 2\b\b\u0001\u00100\u001a\u00020\u000e2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H.02H\u0082\b\u00a2\u0006\u0002\u00103J\u0012\u00104\u001a\u00020\u001d2\b\u00105\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002J\u0018\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\u0006\u0010\"\u001a\u00020\u000eH\u0007J\b\u00109\u001a\u00020\u001dH\u0002J\b\u0010:\u001a\u00020\u001dH\u0007J\b\u0010;\u001a\u00020\u001dH\u0002J\u0018\u0010<\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\u0006\u0010=\u001a\u00020+H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lgit4idea/branch/DeepComparator;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "comparedBranch", "", "nonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "Lorg/jetbrains/annotations/NotNull;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "dispose", "", "getRepositories", "providers", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "branchToCompare", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "column", "isSelected", "", "hasHighlightingOrInProgress", "measureTimeMillis", "R", "root", "actionName", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "notifyUnhighlight", "branch", "startTask", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "stopTask", "stopTaskAndUnhighlight", "unhighlight", "update", "refreshHappened", "Companion", "Factory", "MyTask", "intellij.vcs.git"})
public final class DeepComparator
implements VcsLogHighlighter,
Disposable {
    private ProgressIndicator progressIndicator;
    private String comparedBranch;
    private Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches;
    private IntOpenHashSet nonPickedCommits;
    private final Project project;
    private final GitRepositoryManager repositoryManager;
    private final VcsLogData vcsLogData;
    private final VcsLogUi ui;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final VcsLogStorage getStorage() {
        VcsLogStorage vcsLogStorage = this.vcsLogData.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"vcsLogData.storage");
        return vcsLogStorage;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, int column, boolean isSelected) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)commitDetails, (String)"commitDetails");
                if (this.nonPickedCommits == null) break block2;
                IntOpenHashSet intOpenHashSet = this.nonPickedCommits;
                Intrinsics.checkNotNull((Object)intOpenHashSet);
                if (!intOpenHashSet.contains(commitId)) break block3;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"VcsLogHighlighter.VcsCommitStyle.DEFAULT");
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"VcsCommitStyleFactory.fo\u2026.MERGE_COMMIT_FOREGROUND)");
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        if (this.comparedBranch == null) {
            return;
        }
        VcsLogFilterCollection vcsLogFilterCollection = dataPack.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"dataPack.filters");
        VcsLogRefs vcsLogRefs = dataPack.getRefs();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefs, (String)"dataPack.refs");
        String singleFilteredBranch = Companion.getComparedBranchFromFilters(vcsLogFilterCollection, vcsLogRefs);
        if (Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch) ^ true) {
            String oldComparedBranch = this.comparedBranch;
            LOG.debug("Branch filter changed. Compared branch: " + oldComparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight(oldComparedBranch);
            return;
        }
        if (refreshHappened) {
            this.stopTask();
            Map map2 = dataPack.getLogProviders();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"dataPack.logProviders");
            String string = this.comparedBranch;
            Intrinsics.checkNotNull((Object)string);
            Map<GitRepository, GitBranch> repositories = this.getRepositories(map2, string);
            if (Intrinsics.areEqual(repositories, this.repositoriesWithCurrentBranches)) {
                this.startTask(dataPack);
            } else {
                LOG.debug("Repositories with current branches changed. Actual:\n" + repositories + "\nExpected:\n" + this.repositoriesWithCurrentBranches);
                this.unhighlight();
            }
        }
    }

    @RequiresEdt
    public final void startTask(@NotNull VcsLogDataPack dataPack, @NotNull String branchToCompare) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)branchToCompare, (String)"branchToCompare");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        VcsLogDataPack vcsLogDataPack = this.ui.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogDataPack, (String)"ui.dataPack");
        Map map2 = vcsLogDataPack.getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"ui.dataPack.logProviders");
        Map<GitRepository, GitBranch> repositories = this.getRepositories(map2, branchToCompare);
        if (repositories.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithCurrentBranches = repositories;
        this.startTask(dataPack);
    }

    @RequiresEdt
    public final void stopTaskAndUnhighlight() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    @RequiresEdt
    public final boolean hasHighlightingOrInProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask(VcsLogDataPack dataPack) {
        LOG.debug("Highlighting requested for " + this.repositoriesWithCurrentBranches);
        Map<GitRepository, ? extends GitBranch> map2 = this.repositoriesWithCurrentBranches;
        Intrinsics.checkNotNull(map2);
        String string = this.comparedBranch;
        Intrinsics.checkNotNull((Object)string);
        MyTask task2 = new MyTask(map2, dataPack, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task2;
        ProgressIndicator progressIndicator = this.progressIndicator;
        Intrinsics.checkNotNull((Object)progressIndicator);
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithCurrentBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, GitBranch> getRepositories(Map<VirtualFile, ? extends VcsLogProvider> providers, String branchToCompare) {
        GitRepository repository;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = providers.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitRepository gitRepository;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((GitRepository)this.repositoryManager.getRepositoryForRootQuick(it) == null) continue;
            GitRepository it$iv$iv = gitRepository;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            repository = (GitRepository)element$iv$iv;
            boolean bl = false;
            GitRepository gitRepository = repository;
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repository");
            if (!(gitRepository.getCurrentBranch() != null && repository.getBranches().findBranchByName(branchToCompare) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GitLocalBranch gitLocalBranch;
            void it;
            repository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getCurrentBranch());
            map2.put(t, gitLocalBranch);
        }
        return result$iv;
    }

    private final void notifyUnhighlight(String branch) {
        if (this.ui instanceof VcsLogUiEx) {
            String string = GitBundle.message("git.log.cherry.picked.highlighter.cancelled.message", branch);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.l\u2026ncelled.message\", branch)");
            String message = string;
            JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.INFO");
            Balloon balloon = jBPopupFactory.createHtmlTextBalloonBuilder(message, null, messageType.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026\n        .createBalloon()");
            Balloon balloon2 = balloon;
            VcsLogGraphTable vcsLogGraphTable = ((VcsLogUiEx)this.ui).getTable();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"ui.table");
            VcsLogGraphTable component2 = vcsLogGraphTable;
            balloon2.show(new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon2));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    private final <R> R measureTimeMillis(VirtualFile root, @NonNls String actionName, Function0<? extends R> block) {
        int $i$f$measureTimeMillis = 0;
        long start = System.currentTimeMillis();
        Object result2 = block.invoke();
        if (result2 != null) {
            DeepComparator.LOG.debug(actionName + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start)) + " for " + root.getName());
        }
        return (R)result2;
    }

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogData vcsLogData, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.vcsLogData = vcsLogData;
        this.ui = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DeepComparator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DeepComparator::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ProgressIndicator access$getProgressIndicator$p(DeepComparator $this) {
        return $this.progressIndicator;
    }

    public static final /* synthetic */ IntOpenHashSet access$getNonPickedCommits$p(DeepComparator $this) {
        return $this.nonPickedCommits;
    }

    public static final /* synthetic */ Object access$measureTimeMillis(DeepComparator $this, VirtualFile root, String actionName, Function0 block) {
        return $this.measureTimeMillis(root, actionName, block);
    }

    @JvmStatic
    @NotNull
    public static final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi2) {
        return Companion.getInstance(project, dataProvider, logUi2);
    }

    @JvmStatic
    @Nullable
    public static final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        return Companion.getComparedBranchFromFilters(filters, refs);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J<\u0010\u001b\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/branch/DeepComparator$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "vcsLogDataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "comparedBranch", "", "(Lgit4idea/branch/DeepComparator;Ljava/util/Map;Lcom/intellij/vcs/log/VcsLogDataPack;Ljava/lang/String;)V", "collectedNonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "getCommitsByIndexFast", "Lit/unimi/dsi/fastutil/ints/IntSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceBranch", "getCommitsByIndexReliable", "targetBranch", "getCommitsByPatch", "getCommitsFromGit", "currentBranch", "getCommitsFromIndex", "sourceBranchRef", "Lcom/intellij/vcs/log/VcsRef;", "targetBranchRef", "sourceBranchCommits", "reliable", "", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.vcs.git"})
    private final class MyTask
    extends Task.Backgroundable {
        private final DataPack dataPack;
        private final IntOpenHashSet collectedNonPickedCommits;
        private VcsException exception;
        private final Map<GitRepository, GitBranch> repositoriesWithCurrentBranches;
        private final String comparedBranch;

        /*
         * WARNING - void declaration
         */
        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                Map<GitRepository, GitBranch> $this$forEach$iv = this.repositoriesWithCurrentBranches;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<GitRepository, GitBranch>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    IntSet intSet;
                    void repo;
                    Map.Entry<GitRepository, GitBranch> element$iv;
                    Map.Entry<GitRepository, GitBranch> $dstr$repo$currentBranch = element$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry<GitRepository, GitBranch> entry = $dstr$repo$currentBranch;
                    GitRepository gitRepository = entry.getKey();
                    entry = $dstr$repo$currentBranch;
                    GitBranch currentBranch = entry.getValue();
                    if (Registry.is((String)"git.log.use.index.for.picked.commits.highlighting")) {
                        if (Registry.is((String)"git.log.fast.picked.commits.highlighting")) {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                            intSet = this.getCommitsByIndexFast(virtualFile, this.comparedBranch);
                            if (intSet == null) {
                                VirtualFile virtualFile2 = repo.getRoot();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"repo.root");
                                String string = currentBranch.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                                intSet = this.getCommitsByIndexReliable(virtualFile2, this.comparedBranch, string);
                            }
                        } else {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                            String string = currentBranch.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                            intSet = this.getCommitsByIndexReliable(virtualFile, this.comparedBranch, string);
                        }
                    } else {
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                        String string = currentBranch.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                        intSet = this.getCommitsByPatch(virtualFile, this.comparedBranch, string);
                    }
                    IntSet commits2 = intSet;
                    this.collectedNonPickedCommits.addAll((IntCollection)commits2);
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.exception = e;
            }
        }

        public void onFinished() {
            DeepComparator.this.progressIndicator = null;
        }

        public void onSuccess() {
            if (this.exception != null) {
                DeepComparator.this.nonPickedCommits = null;
                VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
                String string = GitBundle.message("git.log.cherry.picked.highlighter.error.message", this.comparedBranch);
                VcsException vcsException = this.exception;
                Intrinsics.checkNotNull((Object)((Object)vcsException));
                vcsNotifier.notifyError("git.could.not.compare.with.branch", string, vcsException.getMessage());
                return;
            }
            DeepComparator.this.nonPickedCommits = this.collectedNonPickedCommits;
        }

        private final IntSet getCommitsByPatch(VirtualFile root, String targetBranch, String sourceBranch) throws VcsException {
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with git";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            IntSet result$iv = this.getCommitsFromGit(root, targetBranch, sourceBranch);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            return result$iv;
        }

        private final IntSet getCommitsByIndexReliable(VirtualFile root, String sourceBranch, String targetBranch) throws VcsException {
            IntSet resultFromIndex;
            IntSet intSet;
            IntSet resultFromGit = this.getCommitsByPatch(root, targetBranch, sourceBranch);
            if (this.dataPack == null || !this.dataPack.isFull()) {
                return resultFromGit;
            }
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with index reliable";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            RefsModel refsModel = this.dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root);
            if (vcsRef == null) {
                return resultFromGit;
            }
            VcsRef sourceBranchRef = vcsRef;
            RefsModel refsModel2 = this.dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"dataPack.refsModel");
            VcsRef vcsRef2 = DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)"HEAD", (VirtualFile)root);
            if (vcsRef2 == null) {
                return resultFromGit;
            }
            VcsRef targetBranchRef = vcsRef2;
            IntSet result$iv = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, resultFromGit, true);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            if ((intSet = (resultFromIndex = result$iv)) == null) {
                intSet = resultFromGit;
            }
            return intSet;
        }

        private final IntSet getCommitsByIndexFast(VirtualFile root, String sourceBranch) {
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root) || this.dataPack == null || !this.dataPack.isFull()) {
                return null;
            }
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with index fast";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            RefsModel refsModel = this.dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root);
            if (vcsRef == null) {
                return null;
            }
            VcsRef sourceBranchRef = vcsRef;
            RefsModel refsModel2 = this.dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"dataPack.refsModel");
            VcsRef vcsRef2 = DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)"HEAD", (VirtualFile)root);
            if (vcsRef2 == null) {
                return null;
            }
            VcsRef targetBranchRef = vcsRef2;
            IntSet intSet = DataPackUtilKt.subgraphDifference((DataPack)this.dataPack, (VcsRef)sourceBranchRef, (VcsRef)targetBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (intSet == null) {
                return null;
            }
            IntSet sourceBranchCommits = intSet;
            IntSet result$iv = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, sourceBranchCommits, false);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            return result$iv;
        }

        private final IntSet getCommitsFromGit(VirtualFile root, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(this.getProject(), root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            IntOpenHashSet pickedCommits = new IntOpenHashSet();
            handler.addLineListener(new GitLineHandlerListener(this, pickedCommits, root){
                final /* synthetic */ MyTask this$0;
                final /* synthetic */ IntOpenHashSet $pickedCommits;
                final /* synthetic */ VirtualFile $root;

                /*
                 * WARNING - void declaration
                 */
                public final void onLineAvailable(String l, Key<Object> $noName_1) {
                    String line;
                    String string = line = l;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
                    if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
                        try {
                            int firstSpace;
                            void $this$trim$iv;
                            String string2 = line;
                            int n = 2;
                            String string3 = string2.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                            string2 = string3;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((firstSpace = StringsKt.indexOf$default((CharSequence)(line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)' ', (int)0, (boolean)false, (int)6, null)) > 0) {
                                String string4 = line;
                                int n2 = 0;
                                String string5 = string4.substring(n2, firstSpace);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                line = string5;
                            }
                            this.$pickedCommits.add(DeepComparator.access$getStorage$p(this.this$0.DeepComparator.this).getCommitIndex(HashImpl.build((String)line), this.$root));
                        }
                        catch (Exception e) {
                            DeepComparator.access$getLOG$cp().error("Couldn't parse line [" + line + "]", (Throwable)e);
                        }
                    }
                }
                {
                    this.this$0 = myTask;
                    this.$pickedCommits = intOpenHashSet;
                    this.$root = virtualFile;
                }
            });
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
            return (IntSet)pickedCommits;
        }

        private final IntSet getCommitsFromIndex(DataPack dataPack, VirtualFile root, VcsRef sourceBranchRef, VcsRef targetBranchRef, IntSet sourceBranchCommits, boolean reliable) {
            if (dataPack == null) {
                return null;
            }
            if (sourceBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) {
                return null;
            }
            VcsLogIndex vcsLogIndex = DeepComparator.this.vcsLogData.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"vcsLogData.index");
            IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
            if (indexDataGetter == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)indexDataGetter, (String)"vcsLogData.index.dataGetter ?: return null");
            IndexDataGetter dataGetter = indexDataGetter;
            IntSet intSet = DataPackUtilKt.subgraphDifference((DataPack)dataPack, (VcsRef)targetBranchRef, (VcsRef)sourceBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (intSet == null) {
                return null;
            }
            IntSet targetBranchCommits = intSet;
            if (targetBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            IntSet match2 = GitCompareUtilKt.match(dataGetter, root, sourceBranchCommits, targetBranchCommits, reliable);
            sourceBranchCommits.removeAll((IntCollection)match2);
            if (!match2.isEmpty()) {
                LOG.debug("Using index, detected " + match2.size() + " commits in " + sourceBranchRef.getName() + "#" + root.getName() + " that were picked to the current branch" + (reliable ? " with different patch id but matching cherry-picked suffix" : " with matching author, author time and message"));
            }
            return sourceBranchCommits;
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithCurrentBranches;
        }

        public MyTask(@NotNull Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataPack vcsLogDataPack, String comparedBranch) {
            Intrinsics.checkNotNullParameter(repositoriesWithCurrentBranches, (String)"repositoriesWithCurrentBranches");
            Intrinsics.checkNotNullParameter((Object)vcsLogDataPack, (String)"vcsLogDataPack");
            Intrinsics.checkNotNullParameter((Object)comparedBranch, (String)"comparedBranch");
            super(DeepComparator.this.project, GitBundle.message("git.log.cherry.picked.highlighter.process", new Object[0]));
            this.repositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.comparedBranch = comparedBranch;
            VcsLogDataPack vcsLogDataPack2 = vcsLogDataPack;
            if (!(vcsLogDataPack2 instanceof VisiblePack)) {
                vcsLogDataPack2 = null;
            }
            VisiblePack visiblePack = (VisiblePack)vcsLogDataPack2;
            Object object = visiblePack != null ? visiblePack.getDataPack() : null;
            if (!(object instanceof DataPack)) {
                object = null;
            }
            this.dataPack = (DataPack)object;
            this.collectedNonPickedCommits = new IntOpenHashSet();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/branch/DeepComparator$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            Project project = logData.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"logData.project");
            return Companion.getInstance(project, logData, logUi2);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            String string = GitBundle.message("action.Git.Log.DeepCompare.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"actio\u2026it.Log.DeepCompare.text\")");
            return string;
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getComparedBranchFromFilters", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "refs", "Lcom/intellij/vcs/log/VcsLogRefs;", "getInstance", "Lgit4idea/branch/DeepComparator;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            DeepComparator deepComparator = ((DeepComparatorHolder)project.getService(DeepComparatorHolder.class)).getInstance(dataProvider, logUi2);
            Intrinsics.checkNotNullExpressionValue((Object)deepComparator, (String)"project.getService(DeepC\u2026ance(dataProvider, logUi)");
            return deepComparator;
        }

        @JvmStatic
        @Nullable
        public final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
            String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)filters, (VcsLogRefs)refs);
            if (singleFilteredBranch != null) {
                return singleFilteredBranch;
            }
            VcsLogRangeFilter vcsLogRangeFilter = (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER);
            if (vcsLogRangeFilter == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogRangeFilter, (String)"filters.get(VcsLogFilter\u2026GE_FILTER) ?: return null");
            VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
            VcsLogRangeFilter.RefRange refRange = (VcsLogRangeFilter.RefRange)CollectionsKt.singleOrNull((List)rangeFilter.getRanges());
            return refRange != null ? refRange.getInclusiveRef() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

