/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.io.PathKt;
import git4idea.FsMonitor;
import git4idea.GitStatisticsCollectorKt;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0004*\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"MAX_SIZE", "", "MAX_TIME", "isInnerRepo", "", "root", "Ljava/io/File;", "dir", "detectFsMonitor", "Lgit4idea/FsMonitor;", "Lgit4idea/repo/GitRepository;", "isWorkTreeUsed", "sumWithLimits", "Lkotlin/sequences/Sequence;", "workingCopySize", "intellij.vcs.git"})
public final class GitStatisticsCollectorKt {
    private static final long MAX_SIZE = 0x100000000L;
    private static final long MAX_TIME = 300000L;

    private static final long sumWithLimits(Sequence<Long> $this$sumWithLimits) {
        long sum = 0L;
        long startTime = System.currentTimeMillis();
        Iterator iterator = $this$sumWithLimits.iterator();
        while (iterator.hasNext()) {
            long element = ((Number)iterator.next()).longValue();
            if (System.currentTimeMillis() - startTime > 300000L) {
                return -1L;
            }
            if ((sum += element) < 0x100000000L) continue;
            return 0x100000000L;
        }
        return sum;
    }

    private static final long workingCopySize(GitRepository $this$workingCopySize) {
        long l;
        try {
            File root;
            File file = root = $this$workingCopySize.getRoot().toNioPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root");
            l = GitStatisticsCollectorKt.sumWithLimits((Sequence<Long>)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null).onEnter((Function1)new Function1<File, Boolean>(root){
                final /* synthetic */ File $root;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)".git") ^ true)) return false;
                    File file = this.$root;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root");
                    if (GitStatisticsCollectorKt.access$isInnerRepo(file, it)) return false;
                    return true;
                }
                {
                    this.$root = file;
                    super(1);
                }
            })), (Function1)workingCopySize.2.INSTANCE), (Function1)workingCopySize.3.INSTANCE));
        }
        catch (Exception e) {
            l = -1L;
        }
        return l;
    }

    private static final boolean isInnerRepo(File root, File dir) {
        if (Intrinsics.areEqual((Object)root, (Object)dir)) {
            return false;
        }
        Path path = Path.of(dir.toString(), ".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Path.of(dir.toString(), GitUtil.DOT_GIT)");
        return PathKt.exists((Path)path);
    }

    private static final boolean isWorkTreeUsed(GitRepository $this$isWorkTreeUsed) {
        boolean bl;
        try {
            Path worktreesPath;
            Path dotGit;
            Path path = $this$isWorkTreeUsed.getRoot().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.root.toNioPath()");
            Path rootPath = path;
            Path path2 = dotGit = Path.of(((Object)rootPath).toString(), ".git");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dotGit");
            if (PathKt.isFile((Path)path2)) {
                return true;
            }
            GitRepositoryFiles gitRepositoryFiles = $this$isWorkTreeUsed.getRepositoryFiles();
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryFiles, (String)"repositoryFiles");
            Path path3 = worktreesPath = gitRepositoryFiles.getWorktreesDirFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"worktreesPath");
            if (!PathKt.exists((Path)path3)) {
                return false;
            }
            if (!PathKt.isDirectory((Path)worktreesPath)) {
                return false;
            }
            bl = Files.list(worktreesPath).count() > 0L;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private static final FsMonitor detectFsMonitor(GitRepository $this$detectFsMonitor) {
        try {
            Boolean bl = GitConfigUtil.getBooleanValue(GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.useBuiltinFSMonitor"));
            if (bl == null) {
                bl = false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"GitConfigUtil.getBoolean\u2026                 ?: false");
            boolean useBuiltIn = bl;
            if (useBuiltIn) {
                return FsMonitor.BUILTIN;
            }
            String fsMonitorHook = GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.fsmonitor");
            if (fsMonitorHook != null && Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(fsMonitorHook), (Object)false) ^ true) {
                return FsMonitor.EXTERNAL_FS_MONITOR;
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return FsMonitor.NONE;
    }

    public static final /* synthetic */ long access$workingCopySize(GitRepository $this$access_u24workingCopySize) {
        return GitStatisticsCollectorKt.workingCopySize($this$access_u24workingCopySize);
    }

    public static final /* synthetic */ boolean access$isWorkTreeUsed(GitRepository $this$access_u24isWorkTreeUsed) {
        return GitStatisticsCollectorKt.isWorkTreeUsed($this$access_u24isWorkTreeUsed);
    }

    public static final /* synthetic */ FsMonitor access$detectFsMonitor(GitRepository $this$access_u24detectFsMonitor) {
        return GitStatisticsCollectorKt.detectFsMonitor($this$access_u24detectFsMonitor);
    }

    public static final /* synthetic */ boolean access$isInnerRepo(File root, File dir) {
        return GitStatisticsCollectorKt.isInnerRepo(root, dir);
    }
}

