/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgVersion
implements Comparable<HgVersion> {
    private static final Logger LOGGER = Logger.getInstance(HgVersion.class);
    private static final Pattern HG_VERSION_PATTERN = Pattern.compile(".+\\(\\s*\\S+\\s+(\\d+)\\.(\\d+)[\\.]?(\\d)?.*\\s*\\)\\s*.*\\s*", 2);
    private static final Pattern HG_UNSUPPORTED_EXTENSION = Pattern.compile("\\*\\*\\*\\s*failed to import\\s+extension\\s+([a-zA-z0-9\\.-]+).*", 2);
    public static final HgVersion MIN = new HgVersion(2, 0, 1);
    public static final HgVersion AMEND_SUPPORTED = new HgVersion(2, 2, 0);
    public static final HgVersion BUILT_IN_FUNCTION_SUPPORTED = new HgVersion(2, 6, 0);
    public static final HgVersion PARENT_REVISION_TEMPLATES_SUPPORTED = new HgVersion(2, 4, 0);
    public static final HgVersion BRANCH_HEADS_BASE_SERVED_FILE_EXIST = new HgVersion(2, 5, 0);
    public static final HgVersion BRANCH2_FILE_EXIST = new HgVersion(2, 9, 0);
    public static final HgVersion IGNORE_WHITESPACE_DIFF_IN_ANNOTATIONS = new HgVersion(2, 1, 0);
    private static final HgVersion LARGEFILES_WITH_FOLLOW_SUPPORTED = new HgVersion(2, 7, 0);
    public static final HgVersion NULL = new HgVersion(0, 0, 0);
    private final int myMajor;
    private final int myMiddle;
    private final int myMinor;
    @NotNull
    private final Set<String> myUnsupportedExtensions;

    public HgVersion(int major, int middle, int minor) {
        this(major, middle, minor, Collections.emptySet());
    }

    public HgVersion(int major, int middle, int minor, @NotNull Set<String> unsupportedExtensions) {
        if (unsupportedExtensions == null) {
            HgVersion.$$$reportNull$$$0(0);
        }
        this.myMajor = major;
        this.myMiddle = middle;
        this.myMinor = minor;
        this.myUnsupportedExtensions = unsupportedExtensions;
    }

    @NotNull
    public static HgVersion parseVersionAndExtensionInfo(@Nullable String output, @NotNull List<String> errorLines) throws ParseException {
        if (errorLines == null) {
            HgVersion.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            throw new ParseException("Empty hg version output: " + output, 0);
        }
        Matcher matcher = HG_VERSION_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new HgVersion(HgVersion.getIntGroup(matcher, 1), HgVersion.getIntGroup(matcher, 2), HgVersion.getIntGroup(matcher, 3), HgVersion.parseUnsupportedExtensions(errorLines));
        }
        LOGGER.error("Couldn't identify hg version: " + output);
        throw new ParseException("Unsupported format of hg version output: " + output, 0);
    }

    @NotNull
    public static Set<String> parseUnsupportedExtensions(@NotNull List<String> errorLines) {
        if (errorLines == null) {
            HgVersion.$$$reportNull$$$0(2);
        }
        HashSet<String> extensions = new HashSet<String>();
        if (errorLines.isEmpty()) {
            HashSet<String> hashSet = extensions;
            if (hashSet == null) {
                HgVersion.$$$reportNull$$$0(3);
            }
            return hashSet;
        }
        for (String line : errorLines) {
            Matcher matcher = HG_UNSUPPORTED_EXTENSION.matcher(line);
            if (!matcher.matches()) continue;
            extensions.add(matcher.group(1));
        }
        HashSet<String> hashSet = extensions;
        if (hashSet == null) {
            HgVersion.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static int getIntGroup(@NotNull Matcher matcher, int group) {
        if (matcher == null) {
            HgVersion.$$$reportNull$$$0(5);
        }
        if (group > matcher.groupCount() + 1) {
            return 0;
        }
        String match = matcher.group(group);
        if (StringUtil.isEmptyOrSpaces((String)match)) {
            return 0;
        }
        return Integer.parseInt(match);
    }

    @NotNull
    public static HgVersion identifyVersion(@NotNull Project project, @NotNull String executable) throws ShellCommandException, InterruptedException, ParseException {
        if (project == null) {
            HgVersion.$$$reportNull$$$0(6);
        }
        if (executable == null) {
            HgVersion.$$$reportNull$$$0(7);
        }
        HgCommandResult versionResult = HgUtil.getVersionOutput(project, executable);
        return HgVersion.parseVersionAndExtensionInfo(versionResult.getRawOutput(), versionResult.getErrorLines());
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public boolean isAmendSupported() {
        return this.compareTo(AMEND_SUPPORTED) >= 0;
    }

    public boolean isBuiltInFunctionSupported() {
        return this.compareTo(BUILT_IN_FUNCTION_SUPPORTED) >= 0;
    }

    public boolean isLargeFilesWithFollowSupported() {
        return this.compareTo(LARGEFILES_WITH_FOLLOW_SUPPORTED) >= 0;
    }

    public boolean isParentRevisionTemplateSupported() {
        return this.compareTo(PARENT_REVISION_TEMPLATES_SUPPORTED) >= 0;
    }

    public boolean isIgnoreWhitespaceDiffInAnnotationsSupported() {
        return this.compareTo(IGNORE_WHITESPACE_DIFF_IN_ANNOTATIONS) >= 0;
    }

    public boolean hasBranchHeadsBaseServed() {
        return this.compareTo(BRANCH_HEADS_BASE_SERVED_FILE_EXIST) >= 0 && this.compareTo(BRANCH2_FILE_EXIST) < 0;
    }

    public boolean hasBranch2() {
        return this.compareTo(BRANCH2_FILE_EXIST) >= 0;
    }

    public boolean hasUnsupportedExtensions() {
        return !this.myUnsupportedExtensions.isEmpty();
    }

    @NotNull
    public Set<String> getUnsupportedExtensions() {
        Set<String> set = this.myUnsupportedExtensions;
        if (set == null) {
            HgVersion.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HgVersion)) {
            return false;
        }
        return this.compareTo((HgVersion)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.myMajor, this.myMiddle, this.myMinor);
    }

    @Override
    public int compareTo(@NotNull HgVersion o) {
        int d;
        if (o == null) {
            HgVersion.$$$reportNull$$$0(9);
        }
        if ((d = this.myMajor - o.myMajor) != 0) {
            return d;
        }
        d = this.myMiddle - o.myMiddle;
        if (d != 0) {
            return d;
        }
        return this.myMinor - o.myMinor;
    }

    @NotNull
    public String toString() {
        String string = this.myMajor + "." + this.myMiddle + "." + this.myMinor;
        if (string == null) {
            HgVersion.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsupportedExtensions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLines";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/util/HgVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/util/HgVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUnsupportedExtensions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsupportedExtensions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionAndExtensionInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseUnsupportedExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIntGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

