/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCloneCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCloneDialogComponent;
import org.zmlx.hg4idea.ui.HgCloneDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            HgCheckoutProvider.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        HgCloneDialog dialog = new HgCloneDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        String directoryName = dialog.getDirectoryName();
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String parentDirectory = dialog.getParentDirectory();
        HgCheckoutProvider.doClone(project, listener, directoryName, sourceRepositoryURL, parentDirectory);
    }

    public static void doClone(final @NotNull Project project, final @Nullable CheckoutProvider.Listener listener, final @NotNull String directoryName, final @NotNull String sourceRepositoryURL, final @NotNull String parentDirectory) {
        VirtualFile destinationParent;
        if (project == null) {
            HgCheckoutProvider.$$$reportNull$$$0(1);
        }
        if (directoryName == null) {
            HgCheckoutProvider.$$$reportNull$$$0(2);
        }
        if (sourceRepositoryURL == null) {
            HgCheckoutProvider.$$$reportNull$$$0(3);
        }
        if (parentDirectory == null) {
            HgCheckoutProvider.$$$reportNull$$$0(4);
        }
        if ((destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(parentDirectory))) == null) {
            return;
        }
        final String targetDir = destinationParent.getPath() + File.separator + directoryName;
        String projectPath = FileUtilRt.toSystemIndependentName((String)targetDir);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"cloning.repository.cancel", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"clone.repository", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.tooltip", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.canceled", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.title", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.description", (Object[])new Object[]{sourceRepositoryURL}));
            }

            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                HgCloneCommand clone = new HgCloneCommand(project);
                clone.setRepositoryURL(sourceRepositoryURL);
                clone.setDirectory(targetDir);
                HgCommandResult commandResult = clone.executeInCurrentThread();
                if (commandResult == null || HgErrorUtil.hasErrorsInCommandExecution(commandResult)) {
                    new HgCommandResultNotifier(project).notifyError("hg.clone.error", commandResult, DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), HgBundle.message("hg4idea.clone.repo.error.msg", sourceRepositoryURL));
                    CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.FAILURE;
                    if (cloneStatus == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return cloneStatus;
                }
                ApplicationManager.getApplication().invokeLater(() -> DvcsUtil.addMappingIfSubRoot((Project)project, (String)targetDir, (String)"hg4idea"));
                if (listener != null) {
                    listener.directoryCheckedOut(new File(parentDirectory, directoryName), HgVcs.getKey());
                    listener.checkoutCompleted();
                }
                CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.SUCCESS;
                if (cloneStatus == null) {
                    1.$$$reportNull$$$0(2);
                }
                return cloneStatus;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/zmlx/hg4idea/provider/HgCheckoutProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/zmlx/hg4idea/provider/HgCheckoutProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "run";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    public String getVcsName() {
        return "_Mercurial";
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        if (project == null) {
            HgCheckoutProvider.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            HgCheckoutProvider.$$$reportNull$$$0(6);
        }
        if (dialogStateListener == null) {
            HgCheckoutProvider.$$$reportNull$$$0(7);
        }
        return new HgCloneDialogComponent(project, dialogStateListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRepositoryURL";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogStateListener";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/provider/HgCheckoutProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckout";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doClone";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVcsCloneComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

