/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.indexing.shared.util.zipFs.TraceableFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jetbrains.annotations.NotNull;

public abstract class FileBlockReadOnlyFileChannel
extends FileChannel {
    private final String myEntryName;
    @NotNull
    private final TraceableFileChannel myUnderlying;
    private final long myStartOffset;
    private final long myEndOffset;
    private final long mySize;
    private volatile long myGlobalPosition;
    private volatile long myLocalPosition;

    /*
     * WARNING - void declaration
     */
    public FileBlockReadOnlyFileChannel(@NotNull String entryName, @NotNull TraceableFileChannel underlying, long startOffset, long l) {
        void size;
        if (entryName == null) {
            FileBlockReadOnlyFileChannel.$$$reportNull$$$0(0);
        }
        if (underlying == null) {
            FileBlockReadOnlyFileChannel.$$$reportNull$$$0(1);
        }
        this.myEntryName = entryName;
        this.myUnderlying = underlying;
        this.myStartOffset = startOffset;
        this.myEndOffset = startOffset + size;
        this.mySize = size;
        this.myGlobalPosition = this.myStartOffset;
        this.myLocalPosition = 0L;
    }

    public String toString() {
        return "FileBlockReadOnlyFileChannel{myEntryName='" + this.myEntryName + "', myStartOffset=" + this.myStartOffset + ", mySize=" + this.mySize + "}";
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = this.read(dst, this.myLocalPosition);
        if (read > 0) {
            this.position(this.myLocalPosition + (long)read);
        }
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("Not implemented for " + this);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        long globalPosition = this.myStartOffset + position;
        if (position >= this.mySize) {
            return -1;
        }
        int read = this.myUnderlying.read(dst, globalPosition);
        if (read <= 0) {
            return read;
        }
        if ((long)read > this.mySize - position) {
            return (int)(this.mySize - position);
        }
        return read;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public long position() {
        return this.myGlobalPosition - this.myStartOffset;
    }

    @Override
    public FileChannel position(long newPosition) {
        this.myGlobalPosition = this.myStartOffset + newPosition;
        this.myLocalPosition = newPosition;
        assert (this.myGlobalPosition <= this.myEndOffset);
        assert (this.myLocalPosition <= this.mySize);
        return this;
    }

    @Override
    public long size() {
        return this.mySize;
    }

    @Override
    public FileChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force(boolean metaData) {
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) {
        throw new UnsupportedOperationException("Implement it for " + this);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) {
        throw new UnsupportedOperationException("transferFrom is not implemented for " + this);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        throw new UnsupportedOperationException("map is not implemented for " + this);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) {
        return null;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        return null;
    }

    @Override
    protected void implCloseChannel() throws IOException {
    }

    @NotNull
    private IOException createWriteNotSupportedException() {
        return new IOException("Write operation is not supported for " + this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "entryName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "underlying";
                break;
            }
        }
        objectArray[1] = "com/intellij/indexing/shared/util/zipFs/FileBlockReadOnlyFileChannel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

